/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJob;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJobSchedule;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class PostgreJobScheduleManager
extends SQLObjectEditor<PostgreJobSchedule, PostgreJob>
implements DBEObjectRenamer<PostgreJobSchedule> {
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreJobSchedule> getObjectsCache(PostgreJobSchedule object) {
        return object.getParentObject().getScheduleCache();
    }

    protected PostgreJobSchedule createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        PostgreJob job = (PostgreJob)container;
        String name = DBUtils.makeNewObjectName((DBRProgressMonitor)monitor, (String)"Schedule{0}", (DBSObject)job, PostgreJobSchedule.class, PostgreJob::getSchedule, (DBECommandContext)context);
        return new PostgreJobSchedule(job, name);
    }

    protected StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, PostgreJob owner, DBECommandAbstract<PostgreJobSchedule> command, Map<String, Object> options) {
        return new StringBuilder(this.getCreateDDL((PostgreJobSchedule)command.getObject(), true));
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create schedule", this.getCreateDDL((PostgreJobSchedule)command.getObject(), false)));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) throws DBException {
        PostgreJobSchedule schedule = (PostgreJobSchedule)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Delete schedule", "DELETE FROM pgagent.pga_schedule\nWHERE jscid=" + schedule.getObjectId()));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        PostgreJobSchedule schedule = (PostgreJobSchedule)command.getObject();
        StringJoiner values = new StringJoiner(",\n\t");
        if (command.hasProperty((Object)"description")) {
            values.add("jscdesc=" + SQLUtils.quoteString((DBPDataSource)schedule.getDataSource(), (String)CommonUtils.notEmpty((String)schedule.getDescription())));
        }
        if (command.getProperty((Object)"enabled") != null) {
            values.add("jscenabled=" + schedule.isEnabled());
        }
        if (values.length() > 0) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Alter schedule", "UPDATE pgagent.pga_schedule\nSET\n\t" + String.valueOf(values) + "\nWHERE jscid=" + schedule.getObjectId()));
        }
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        PostgreJobSchedule schedule = (PostgreJobSchedule)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename schedule", "UPDATE pgagent.pga_schedule\nSET\n\tjscname=" + SQLUtils.quoteString((DBPDataSource)schedule.getDataSource(), (String)command.getNewName()) + "\nWHERE jscid=" + schedule.getObjectId()));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreJobSchedule object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    @NotNull
    private String getCreateDDL(@NotNull PostgreJobSchedule schedule, boolean nested) {
        StringJoiner values = new StringJoiner(", ", "(", ")");
        values.add(nested ? "(SELECT jobid FROM job)" : String.valueOf(schedule.getParentObject().getObjectId()));
        values.add(SQLUtils.quoteString((DBSObject)schedule, (String)schedule.getName()));
        values.add(SQLUtils.quoteString((DBSObject)schedule, (String)schedule.getDescription()));
        values.add(String.valueOf(schedule.isEnabled()));
        values.add(SQLUtils.quoteString((DBSObject)schedule, (String)schedule.getStart().toString()));
        values.add(schedule.getEnd() != null ? SQLUtils.quoteString((DBSObject)schedule, (String)schedule.getEnd().toString()) : "NULL");
        values.add(this.toCompactArray(schedule.getMinutes()));
        values.add(this.toCompactArray(schedule.getHours()));
        values.add(this.toCompactArray(schedule.getWeekDays()));
        values.add(this.toCompactArray(schedule.getMonthDays()));
        values.add(this.toCompactArray(schedule.getMonths()));
        return "INSERT INTO pgagent.pga_schedule (jscjobid, jscname, jscdesc, jscenabled, jscstart, jscend, jscminutes, jschours, jscweekdays, jscmonthdays, jscmonths)\nVALUES " + String.valueOf(values);
    }

    @NotNull
    private String toCompactArray(@NotNull boolean[] values) {
        StringJoiner joiner = new StringJoiner(",", "'{", "}'");
        boolean[] blArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            boolean value = blArray[n2];
            joiner.add(value ? "t" : "f");
            ++n2;
        }
        return joiner.toString();
    }
}

