/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.random;

import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import net.schmizz.sshj.transport.random.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureRandomProvider
implements Random {
    private static final Logger logger = LoggerFactory.getLogger(SecureRandomProvider.class);
    private byte[] tmp = new byte[16];
    private SecureRandom random;

    protected SecureRandomProvider() {
        this.random = SecureRandomProvider.newRandom();
    }

    protected SecureRandomProvider(String algorithm, String provider) {
        this.random = SecureRandomProvider.newRandom(algorithm, provider);
    }

    private static SecureRandom newRandom() {
        return new SecureRandom();
    }

    private static SecureRandom newRandom(String algorithm, String provider) {
        logger.info("Generating random seed from SecureRandom of {}.", (Object)provider);
        long t = System.currentTimeMillis();
        try {
            SecureRandom secureRandom = SecureRandom.getInstance(algorithm, provider);
            return secureRandom;
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(String.format("%s provider is not in the classpath", provider), e);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to initialize SecureRandom with %s provider", provider), e);
        }
        finally {
            logger.debug("Creating random seed took {} ms", (Object)(System.currentTimeMillis() - t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void fill(byte[] bytes, int start, int len) {
        if (start == 0 && len == bytes.length) {
            this.random.nextBytes(bytes);
        } else {
            SecureRandomProvider secureRandomProvider = this;
            synchronized (secureRandomProvider) {
                if (len > this.tmp.length) {
                    this.tmp = new byte[len];
                }
                this.random.nextBytes(this.tmp);
                System.arraycopy(this.tmp, 0, bytes, start, len);
            }
        }
    }

    @Override
    public void fill(byte[] bytes) {
        this.random.nextBytes(bytes);
    }
}

