/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JButton;

public class LinkButton
extends JButton {
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final Color COLOR_VISITED = new Color(0x800088);
    private String linkText;
    private boolean visited = false;
    private Color unvisitedColor = new Color(255);
    private Color visitedColor = null;
    private Color hoverColor;
    private Color disabledColor = Color.GRAY;
    private Font hoverFont = null;
    private int hoverFontStyle = 4;
    private int visitedFontStyle = 0;
    private int unvisitedFontStyle = 0;
    private int disabledFontStyle = 0;
    private final Handler handler = new Handler();
    private boolean mouseOver = false;

    public LinkButton() {
        this("");
    }

    public LinkButton(Action a) {
        super(a);
        this.initLinkButton();
    }

    public LinkButton(String text) {
        super(text);
        this.initLinkButton();
    }

    private void initLinkButton() {
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setForeground(this.getUnvisitedColor());
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setMaximumSize(this.getPreferredSize());
        this.addMouseListener(this.getHandler());
        this.addActionListener(this.getHandler());
        this.addHierarchyListener(this.getHandler());
        this.setFont(this.getFont().deriveFont(0));
    }

    @Override
    public void setText(String text) {
        this.linkText = text;
        StringBuffer sb = new StringBuffer("<html>");
        StringBuffer sb2 = new StringBuffer();
        int fs = !this.isEnabled() ? this.getDisabledFontStyle() : (this.isMouseOver() ? this.getHoverFontStyle() : (this.isVisited() ? this.getVisitedFontStyle() : this.getUnvisitedFontStyle()));
        if ((fs & 4) == 4) {
            sb.append("<u>");
            sb2.insert(0, "</u>");
        }
        if ((fs & 1) == 1) {
            sb.append("<b>");
            sb2.insert(0, "</b>");
        }
        if ((fs & 2) == 2) {
            sb.append("<i>");
            sb2.insert(0, "</i>");
        }
        sb.append(text).append(sb2);
        super.setText(sb.toString());
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverColor(Color c) {
        this.hoverColor = c;
        this.updateFontColor();
    }

    public Font getHoverFont() {
        return this.hoverFont;
    }

    public void setHoverFont(Font hoverFont) {
        this.hoverFont = hoverFont;
        if (this.isMouseOver() && hoverFont != null && this.isEnabled()) {
            this.setFont(hoverFont);
        }
    }

    public int getHoverFontStyle() {
        return this.hoverFontStyle;
    }

    public void setHoverFontStyle(int style) {
        this.hoverFontStyle = style;
        this.setText(this.linkText);
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
        this.updateFontColor();
    }

    public Color getVisitedColor() {
        return this.visitedColor;
    }

    public void setVisitedColor(Color c) {
        this.visitedColor = c;
        this.updateFontColor();
    }

    public int getVisitedFontStyle() {
        return this.visitedFontStyle;
    }

    public void setVisitedFontStyle(int style) {
        this.visitedFontStyle = style;
        this.setText(this.linkText);
    }

    public Color getUnvisitedColor() {
        return this.unvisitedColor;
    }

    public void setUnvisitedColor(Color c) {
        if (c == null) {
            throw new IllegalArgumentException("c must be non-null");
        }
        this.unvisitedColor = c;
        this.updateFontColor();
    }

    public int getUnvisitedFontStyle() {
        return this.unvisitedFontStyle;
    }

    public void setUnvisitedFontStyle(int style) {
        this.unvisitedFontStyle = style;
        this.setText(this.linkText);
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color c) {
        if (c == null) {
            throw new IllegalArgumentException("c must be non-null");
        }
        this.disabledColor = c;
        this.updateFontColor();
    }

    public int getDisabledFontStyle() {
        return this.disabledFontStyle;
    }

    public void setDisabledFontStyle(int style) {
        this.disabledFontStyle = style;
        this.setText(this.linkText);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.updateFontColor();
        this.setText(this.linkText);
    }

    private boolean isMouseOver() {
        return this.mouseOver;
    }

    private Handler getHandler() {
        return this.handler;
    }

    private void updateFontColor() {
        if (!this.isEnabled()) {
            this.setForeground(this.getDisabledColor());
        } else if (this.isMouseOver() && this.getHoverColor() != null) {
            this.setForeground(this.getHoverColor());
        } else if (this.isVisited() && this.getVisitedColor() != null) {
            this.setForeground(this.getVisitedColor());
        } else {
            this.setForeground(this.getUnvisitedColor());
        }
    }

    private class Handler
    extends MouseAdapter
    implements ActionListener,
    HierarchyListener {
        private Font font = null;

        private Handler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            LinkButton.this.mouseOver = true;
            if (LinkButton.this.getHoverFont() != null && LinkButton.this.isEnabled()) {
                this.font = LinkButton.this.getFont();
                LinkButton.this.setFont(LinkButton.this.getHoverFont());
            }
            LinkButton.this.updateFontColor();
            LinkButton.this.setText(LinkButton.this.linkText);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            LinkButton.this.mouseOver = false;
            if (this.font != null) {
                LinkButton.this.setFont(this.font);
                this.font = null;
            }
            LinkButton.this.updateFontColor();
            LinkButton.this.setText(LinkButton.this.linkText);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LinkButton.this.setVisited(true);
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) == 4L) {
                if (LinkButton.this.getMousePosition() == null) {
                    this.mouseExited(null);
                } else {
                    this.mouseEntered(null);
                }
            }
        }
    }
}

