/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.commands.remote.IracUpdateKeyRequest;
import org.infinispan.xsite.commands.remote.XSiteRequest;

public class IracPutManyRequest
extends IracUpdateKeyRequest<IntSet> {
    private static final Log log = LogFactory.getLog(IracPutManyRequest.class);
    private static final byte WRITE = 0;
    private static final byte REMOVE = 1;
    private static final byte EXPIRE = 2;
    private List<Update> updateList;

    public IracPutManyRequest() {
        super(null);
    }

    public IracPutManyRequest(ByteString cacheName, int maxCapacity) {
        super(cacheName);
        this.updateList = new ArrayList<Update>(maxCapacity);
    }

    @Override
    public CompletionStage<IntSet> executeOperation(BackupReceiver receiver) {
        IntSet rsp = IntSets.concurrentSet((int)this.updateList.size());
        AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage((Object)rsp);
        for (int i = 0; i < this.updateList.size(); ++i) {
            int keyIndex = i;
            Update update = this.updateList.get(i);
            stage.dependsOn(update.execute(receiver).exceptionally(throwable -> {
                if (log.isTraceEnabled()) {
                    log.tracef((Throwable)throwable, "[IRAC] Received exception while applying %s", update);
                }
                rsp.set(keyIndex);
                return null;
            }));
        }
        return stage.freeze();
    }

    @Override
    public byte getCommandId() {
        return 3;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.updateList, (ObjectOutput)output, IracPutManyRequest::writeUpdateTo);
        super.writeTo(output);
    }

    @Override
    public XSiteRequest<IntSet> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.updateList = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new, IracPutManyRequest::readUpdateFrom);
        return super.readFrom(input);
    }

    public String toString() {
        return "IracPutManyCommand{cacheName=" + String.valueOf(this.cacheName) + ", updateList=" + Util.toStr(this.updateList) + "}";
    }

    public void addUpdate(Object key, Object value, Metadata metadata, IracMetadata iracMetadata) {
        this.updateList.add(new Write(key, iracMetadata, value, metadata));
    }

    public void addRemove(Object key, IracMetadata tombstone) {
        this.updateList.add(new Remove(key, tombstone));
    }

    public void addExpire(Object key, IracMetadata tombstone) {
        this.updateList.add(new Expire(key, tombstone));
    }

    private static void writeUpdateTo(ObjectOutput output, Update update) throws IOException {
        output.writeByte(update.getType());
        update.writeTo(output);
    }

    private static Update readUpdateFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        switch (input.readByte()) {
            case 0: {
                return new Write(input.readObject(), IracMetadata.readFrom(input), input.readObject(), (Metadata)input.readObject());
            }
            case 1: {
                return new Remove(input.readObject(), IracMetadata.readFrom(input));
            }
            case 2: {
                return new Expire(input.readObject(), IracMetadata.readFrom(input));
            }
        }
        throw new IllegalStateException();
    }

    public boolean isEmpty() {
        return this.updateList.isEmpty();
    }

    private static interface Update {
        public byte getType();

        public CompletionStage<Void> execute(BackupReceiver var1);

        public void writeTo(ObjectOutput var1) throws IOException;
    }

    private static final class Write
    extends Remove {
        private final Object value;
        private final Metadata metadata;

        private Write(Object key, IracMetadata metadata, Object value, Metadata metadata1) {
            super(key, metadata);
            this.value = value;
            this.metadata = metadata1;
        }

        @Override
        public byte getType() {
            return 0;
        }

        @Override
        public CompletionStage<Void> execute(BackupReceiver backupReceiver) {
            return backupReceiver.putKeyValue(this.key, this.value, this.metadata, this.iracMetadata);
        }

        @Override
        public void writeTo(ObjectOutput output) throws IOException {
            super.writeTo(output);
            output.writeObject(this.value);
            output.writeObject(this.metadata);
        }

        @Override
        public String toString() {
            return "Write{key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr((Object)this.value) + ", iracMetadata=" + String.valueOf(this.iracMetadata) + ", metadata=" + String.valueOf(this.metadata) + "}";
        }
    }

    private static class Remove
    implements Update {
        final Object key;
        final IracMetadata iracMetadata;

        private Remove(Object key, IracMetadata iracMetadata) {
            this.key = key;
            this.iracMetadata = iracMetadata;
        }

        @Override
        public byte getType() {
            return 1;
        }

        @Override
        public CompletionStage<Void> execute(BackupReceiver backupReceiver) {
            return backupReceiver.removeKey(this.key, this.iracMetadata, false);
        }

        @Override
        public void writeTo(ObjectOutput output) throws IOException {
            output.writeObject(this.key);
            IracMetadata.writeTo(output, this.iracMetadata);
        }

        public String toString() {
            return "Remove{key=" + Util.toStr((Object)this.key) + ", iracMetadata=" + String.valueOf(this.iracMetadata) + "}";
        }
    }

    private static final class Expire
    extends Remove {
        private Expire(Object key, IracMetadata tombstone) {
            super(key, tombstone);
        }

        @Override
        public byte getType() {
            return 2;
        }

        @Override
        public CompletionStage<Void> execute(BackupReceiver backupReceiver) {
            return backupReceiver.removeKey(this.key, this.iracMetadata, true);
        }

        @Override
        public String toString() {
            return "Expire{key=" + Util.toStr((Object)this.key) + ", iracMetadata=" + String.valueOf(this.iracMetadata) + "}";
        }
    }
}

