/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.infinispan.commons.util.Util;

public interface ByteBuffer {
    public byte[] getBuf();

    public int getOffset();

    public int getLength();

    public ByteBuffer copy();

    default public byte[] trim() {
        if (this.getLength() == 0) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        if (this.getOffset() == 0 && this.getBuf().length == this.getLength()) {
            return this.getBuf();
        }
        byte[] trimBuf = new byte[this.getLength()];
        System.arraycopy(this.getBuf(), this.getOffset(), trimBuf, 0, this.getLength());
        return trimBuf;
    }

    default public InputStream getStream() {
        return new ByteArrayInputStream(this.getBuf(), this.getOffset(), this.getLength());
    }
}

