/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.GlassFishExecutors;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.actions.DebugAction;
import org.netbeans.modules.glassfish.common.actions.RefreshAction;
import org.netbeans.modules.glassfish.common.actions.RestartAction;
import org.netbeans.modules.glassfish.common.actions.StartServerAction;
import org.netbeans.modules.glassfish.common.actions.StopServerAction;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RecognizerCookie;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.server.FetchLog;
import org.netbeans.modules.glassfish.tooling.server.FetchLogEvent;
import org.netbeans.modules.glassfish.tooling.server.FetchLogEventListener;
import org.netbeans.modules.glassfish.tooling.server.FetchLogPiped;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class LogViewMgr {
    private static final Logger LOGGER = GlassFishLogger.get(LogViewMgr.class);
    private static final boolean strictFilter = Boolean.getBoolean("glassfish.logger.strictfilter");
    private static final int DELAY = Utilities.isWindows() ? 1 : 100;
    private static final Map<String, WeakReference<LogViewMgr>> instances = new HashMap<String, WeakReference<LogViewMgr>>();
    private final String uri;
    private InputOutput io;
    private final List<WeakReference<LoggerRunnable>> readers = Collections.synchronizedList(new ArrayList());
    private final Locale logLocale = this.getLogLocale();
    private static final String logBundleName = "org.netbeans.modules.glassfish.common.resources.logging";
    private final String localizedWarning = this.getLocalized(Level.WARNING.getName());
    private final String localizedSevere = this.getLocalized(Level.SEVERE.getName());
    private final Map<String, String> localizedLevels = this.getLevelMap();
    private AtomicBoolean visibleCheck = new AtomicBoolean();
    private final long VISIBILITY_CHECK_DELAY = 60000L;
    private final String OUTPUT_WINDOW_TCID = "output";
    private volatile long lastVisibleCheck = 0L;
    private WeakReference<TopComponent> outputTCRef = new WeakReference<Object>(null);
    private volatile Method setClosedMethod;
    private static Pattern colorPattern = Pattern.compile("\\033\\[([\\d]{1,3})(?:;([\\d]{1,3}))?(?:;([\\d]{1,3}))?(?:;([\\d]{1,3}))?(?:;([\\d]{1,3}))?m");
    private static final Color LOG_RED = new Color(204, 0, 0);
    private static final Color LOG_GREEN = new Color(0, 192, 0);
    private static final Color LOG_YELLOW = new Color(204, 204, 0);
    private static final Color LOG_BLUE = Color.BLUE;
    private static final Color LOG_MAGENTA = new Color(204, 0, 204);
    private static final Color LOG_CYAN = new Color(0, 153, 255);
    private static Color[] colorTable = new Color[]{Color.BLACK, LOG_RED, LOG_GREEN, LOG_YELLOW, LOG_BLUE, LOG_MAGENTA, LOG_CYAN};
    private static final WeakHashMap<ServerInstance, InputOutput> ioWeakMap = new WeakHashMap();
    private static final Map<GlassfishInstance, FetchLog> serverInputStreams = new HashMap<GlassfishInstance, FetchLog>();

    private LogViewMgr(String uri) {
        this.uri = uri;
        this.io = LogViewMgr.getServerIO(uri);
        if (this.io == null) {
            return;
        }
        try {
            this.io.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogViewMgr getInstance(String uri) {
        LogViewMgr logViewMgr;
        Map<String, WeakReference<LogViewMgr>> map = instances;
        synchronized (map) {
            WeakReference<LogViewMgr> viewRef = instances.get(uri);
            LogViewMgr logViewMgr2 = logViewMgr = viewRef != null ? (LogViewMgr)viewRef.get() : null;
            if (logViewMgr == null) {
                logViewMgr = new LogViewMgr(uri);
                instances.put(uri, new WeakReference<LogViewMgr>(logViewMgr));
            }
        }
        return logViewMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureActiveReader(List<Recognizer> recognizers, FetchLog serverLog, GlassfishInstance instance) {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            boolean activeReader = false;
            for (WeakReference<LoggerRunnable> ref : this.readers) {
                LoggerRunnable logger = (LoggerRunnable)ref.get();
                if (logger == null) continue;
                activeReader = true;
                break;
            }
            if (!activeReader && serverLog != null) {
                this.readInputStreams(recognizers, serverLog.getInputStream() instanceof FileInputStream, instance, serverLog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readInputStreams(List<Recognizer> recognizers, boolean fromFile, GlassfishInstance instance, FetchLog ... serverLogs) {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            this.stopReaders();
            for (FetchLog serverLog : serverLogs) {
                LoggerRunnable logger = new LoggerRunnable(recognizers, serverLog, fromFile, instance);
                this.readers.add(new WeakReference<LoggerRunnable>(logger));
                Thread t = new Thread(logger);
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReaders() {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            for (WeakReference<LoggerRunnable> ref : this.readers) {
                LoggerRunnable logger = (LoggerRunnable)ref.get();
                if (logger == null) continue;
                logger.stop();
            }
            this.readers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReader(LoggerRunnable logger) {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            int size = this.readers.size();
            for (int i = 0; i < size; ++i) {
                WeakReference<LoggerRunnable> ref = this.readers.get(i);
                if (logger != ref.get()) continue;
                this.readers.remove(i);
                break;
            }
        }
    }

    public synchronized void write(String s, boolean error) {
        OutputWriter writer = this.getWriter(error);
        if (writer != null) {
            writer.print(s);
        }
    }

    public synchronized void write(String s, OutputListener link, boolean important, boolean error) {
        try {
            OutputWriter writer = this.getWriter(error);
            if (writer != null) {
                writer.println(s, link, important);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, ex.getLocalizedMessage(), ex);
        }
    }

    private OutputWriter getWriter(boolean error) {
        OutputWriter writer;
        if (null == this.io) {
            return null;
        }
        OutputWriter outputWriter = writer = error ? this.io.getErr() : this.io.getOut();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "getIOWriter: closed = {0} [ {1} ], output error flag = {2}", new Object[]{this.io.isClosed(), error ? "STDERR" : "STDOUT", writer.checkError()});
        }
        if (writer.checkError()) {
            InputOutput newIO = LogViewMgr.getServerIO(this.uri);
            if (newIO == null) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Unable to recreate I/O for {0}, still in error state", this.uri);
                }
                writer = null;
            } else {
                this.io = newIO;
                writer = error ? this.io.getErr() : this.io.getOut();
            }
        }
        return writer;
    }

    private Locale getLogLocale() {
        String language = System.getProperty("user.language");
        if (language != null) {
            return new Locale(language, System.getProperty("user.country", ""), System.getProperty("user.variant", ""));
        }
        return Locale.getDefault();
    }

    private String getLocalized(String text) {
        ResourceBundle bundle = ResourceBundle.getBundle(logBundleName, this.logLocale);
        String localized = bundle.getString(text);
        return localized != null ? localized : text;
    }

    private Map<String, String> getLevelMap() {
        HashMap<String, String> levelMap = new HashMap<String, String>();
        for (Level l : new Level[]{Level.ALL, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.INFO, Level.SEVERE, Level.WARNING}) {
            String name = l.getName();
            levelMap.put(name, this.getLocalized(name));
        }
        return levelMap;
    }

    private String getLocalizedLevel(String level) {
        String localizedLevel = this.localizedLevels.get(level);
        return localizedLevel != null ? localizedLevel : level;
    }

    public synchronized void selectIO(boolean force) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "selectIO: closed = {0}, output error flag = {1}", new Object[]{this.io.isClosed(), this.io.getOut().checkError()});
        }
        if (this.io.isClosed()) {
            try {
                this.io.getOut().reset();
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "ignorable problem", ex);
            }
            this.io.select();
            this.invokeSetClosed(this.io, false);
        }
        if (force) {
            this.lastVisibleCheck = 0L;
            this.io.select();
        }
        if (System.currentTimeMillis() > this.lastVisibleCheck + 60000L) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    if (LogViewMgr.this.visibleCheck.getAndSet(true)) {
                        try {
                            TopComponent tc = null;
                            if (LogViewMgr.this.outputTCRef != null) {
                                tc = (TopComponent)LogViewMgr.this.outputTCRef.get();
                            }
                            if (tc == null && (tc = WindowManager.getDefault().findTopComponent("output")) != null) {
                                LogViewMgr.this.outputTCRef = new WeakReference<TopComponent>(tc);
                            }
                            if (tc != null && !tc.isOpened()) {
                                tc.open();
                            }
                            LogViewMgr.this.lastVisibleCheck = System.currentTimeMillis();
                        }
                        finally {
                            LogViewMgr.this.visibleCheck.set(false);
                        }
                    }
                }
            });
        }
    }

    private void invokeSetClosed(InputOutput io, boolean closed) {
        block4: {
            if (this.setClosedMethod == null) {
                this.setClosedMethod = this.initSetClosedMethod(io);
            }
            if (this.setClosedMethod != null) {
                try {
                    this.setClosedMethod.invoke((Object)io, closed);
                }
                catch (Exception ex) {
                    if (!LOGGER.isLoggable(Level.FINER)) break block4;
                    LOGGER.log(Level.FINER, "invokeSetClosed", ex);
                }
            }
        }
    }

    private Method initSetClosedMethod(InputOutput io) {
        Method method;
        block2: {
            method = null;
            try {
                Class clazz = io.getClass();
                method = clazz.getDeclaredMethod("setClosed", Boolean.TYPE);
                method.setAccessible(true);
            }
            catch (Exception ex) {
                if (!LOGGER.isLoggable(Level.FINER)) break block2;
                LOGGER.log(Level.FINER, "initSetClosedMethod", ex);
            }
        }
        return method;
    }

    private boolean filter(String line) {
        return line.startsWith("INFO: Started bundle ") || line.startsWith("INFO: Stopped bundle ") || line.startsWith("INFO: ### ") || line.startsWith("felix.") || line.startsWith("log4j:");
    }

    private static String stripNewline(String s) {
        int len = s.length();
        if (len > 0 && '\n' == s.charAt(len - 1)) {
            s = s.substring(0, len - 1);
        }
        return s;
    }

    private boolean isWarning(String line) {
        return line.startsWith(this.localizedWarning) || line.startsWith(this.localizedSevere);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputOutput getServerIO(String uri) {
        InputOutput newIO;
        ServerInstance si = GlassfishInstanceProvider.getInstanceByUri(uri);
        if (null == si) {
            return null;
        }
        WeakHashMap<ServerInstance, InputOutput> weakHashMap = ioWeakMap;
        synchronized (weakHashMap) {
            InputOutput serverIO = ioWeakMap.get(si);
            if (serverIO != null) {
                boolean valid = true;
                if (serverIO.isClosed() && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Output window for {0} is closed.", uri);
                }
                if (serverIO.getOut().checkError()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Standard out for {0} is in error state.", uri);
                    }
                    valid = false;
                }
                if (serverIO.getErr().checkError()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Standard error for {0} is in error state.", uri);
                    }
                    valid = false;
                }
                if (valid) {
                    return serverIO;
                }
                if (!serverIO.isClosed()) {
                    serverIO.closeInputOutput();
                }
                ioWeakMap.put(si, null);
            }
        }
        Node node = si.getFullNode();
        if (node == null) {
            return null;
        }
        GlassfishModule commonSupport = (GlassfishModule)node.getLookup().lookup(GlassfishModule.class);
        if (commonSupport == null) {
            return null;
        }
        Action[] actions = new Action[]{new StartServerAction.OutputAction(commonSupport), new DebugAction.OutputAction(commonSupport), new RestartAction.OutputAction(commonSupport), new StopServerAction.OutputAction(commonSupport), new RefreshAction.OutputAction(commonSupport)};
        WeakHashMap<ServerInstance, InputOutput> weakHashMap2 = ioWeakMap;
        synchronized (weakHashMap2) {
            newIO = ioWeakMap.get(si);
            if (newIO == null) {
                newIO = IOProvider.getDefault().getIO(si.getDisplayName(), actions);
                ioWeakMap.put(si, newIO);
            }
        }
        return newIO;
    }

    public static void displayOutput(GlassfishInstance instance, Lookup lookup) {
        String uri = instance.getProperty("url");
        if (null != uri && (uri.contains("gfv3ee6wc") || uri.contains("localhost"))) {
            FetchLog log = LogViewMgr.getServerLogStream(instance);
            LogViewMgr mgr = LogViewMgr.getInstance(uri);
            List<Recognizer> recognizers = new ArrayList<Recognizer>();
            if (null != lookup) {
                recognizers = LogViewMgr.getRecognizers(lookup.lookupAll(RecognizerCookie.class));
            }
            mgr.ensureActiveReader(recognizers, log, instance);
            mgr.selectIO(true);
        }
    }

    private static List<Recognizer> getRecognizers(Collection<? extends RecognizerCookie> cookies) {
        List<Recognizer> recognizers;
        if (!cookies.isEmpty()) {
            recognizers = new LinkedList();
            for (RecognizerCookie recognizerCookie : cookies) {
                recognizers.addAll(recognizerCookie.getRecognizers());
            }
            recognizers = Collections.unmodifiableList(recognizers);
        } else {
            recognizers = Collections.emptyList();
        }
        return recognizers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addLog(GlassfishInstance instance, FetchLogPiped log) {
        FetchLog oldLog;
        Map<GlassfishInstance, FetchLog> map = serverInputStreams;
        synchronized (map) {
            oldLog = serverInputStreams.put(instance, (FetchLog)log);
        }
        log.addListener((FetchLogEventListener)new LogStateListener(instance, log));
        if (oldLog != null) {
            oldLog.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLog(GlassfishInstance instance) {
        FetchLog oldLog;
        Map<GlassfishInstance, FetchLog> map = serverInputStreams;
        synchronized (map) {
            oldLog = serverInputStreams.remove(instance);
        }
        if (oldLog != null) {
            oldLog.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FetchLog getServerLogStream(GlassfishInstance instance) {
        FetchLog log;
        FetchLog deadLog = null;
        Map<GlassfishInstance, FetchLog> map = serverInputStreams;
        synchronized (map) {
            log = serverInputStreams.get(instance);
            if (log != null) {
                if (log instanceof FetchLogPiped) {
                    if (((FetchLogPiped)log).isRunning()) {
                        return log;
                    }
                    deadLog = log;
                    LogViewMgr.removeLog(instance);
                } else {
                    return log;
                }
            }
            log = FetchLogPiped.create((ExecutorService)GlassFishExecutors.fetchLogExecutor(), (GlassFishServer)instance);
            LogViewMgr.addLog(instance, (FetchLogPiped)log);
        }
        if (deadLog != null) {
            deadLog.close();
        }
        return log;
    }

    private class LoggerRunnable
    implements Runnable {
        private final List<Recognizer> recognizers;
        private FetchLog serverLog;
        private final boolean ignoreEof;
        private volatile boolean shutdown;
        private GlassfishInstance instance;

        public LoggerRunnable(List<Recognizer> recognizers, FetchLog serverLog, boolean ignoreEof, GlassfishInstance instance) {
            this.recognizers = recognizers;
            this.serverLog = serverLog;
            this.ignoreEof = ignoreEof;
            this.shutdown = false;
            this.instance = instance;
        }

        public void stop() {
            this.shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String originalName = Thread.currentThread().getName();
            BufferedReader reader = null;
            try {
                Thread.currentThread().setName(this.getClass().getName() + " - " + String.valueOf(this.serverLog.getInputStream()));
                reader = new BufferedReader(new InputStreamReader(this.serverLog.getInputStream()));
                LogFileFilter filter = this.ignoreEof ? new LogFileFilter(LogViewMgr.this.localizedLevels) : (LogViewMgr.this.uri.contains("]deployer:gfv3ee6") ? new LogFileFilter(LogViewMgr.this.localizedLevels) : new StreamFilter());
                char[] chars = new char[1024];
                int len = 0;
                while (!this.shutdown && len != -1) {
                    if (this.ignoreEof) {
                        reader = this.followLogRotation(reader);
                        while (!this.shutdown && reader.ready()) {
                            String text = filter.process((char)reader.read());
                            if (text == null) continue;
                            this.processLine(text);
                        }
                    } else {
                        while (!this.shutdown && (len = reader.read(chars)) != -1) {
                            for (int i = 0; i < len; ++i) {
                                String text = filter.process(chars[i]);
                                if (text == null) continue;
                                this.processLine(text);
                            }
                            if (reader.ready()) continue;
                        }
                    }
                    try {
                        if (this.ignoreEof) {
                            LogViewMgr.this.io.getErr().close();
                            LogViewMgr.this.io.getOut().close();
                        }
                        Thread.sleep(DELAY);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "I/O exception reading server log", ex);
            }
            finally {
                this.serverLog.close();
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, "I/O exception closing stream buffer", ex);
                    }
                }
                LogViewMgr.this.removeReader(this);
                Thread.currentThread().setName(originalName);
            }
            LogViewMgr.this.io.getErr().close();
            LogViewMgr.this.io.getOut().close();
        }

        private void processLine(String line) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "processing text: ''{0}''", line);
            }
            if (strictFilter && LogViewMgr.this.filter(line)) {
                return;
            }
            Message message = new Message(line);
            message.process(this.recognizers);
            message.print();
            LogViewMgr.this.selectIO(false);
            if (this.shutdown) {
                LogViewMgr.this.io.getErr().close();
                LogViewMgr.this.io.getOut().close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized BufferedReader followLogRotation(BufferedReader reader) {
            BufferedReader retVal = reader;
            if (this.instance != null && this.instance.getProperties() != null) {
                FetchLog newServerLog = null;
                String dir = this.instance.getProperty("domainsfolder");
                if (null == dir) {
                    return retVal;
                }
                try {
                    newServerLog = LogViewMgr.getServerLogStream(this.instance);
                    if (this.serverLog.getInputStream() instanceof FileInputStream && newServerLog.getInputStream() instanceof FileInputStream) {
                        FileInputStream fis = (FileInputStream)newServerLog.getInputStream();
                        long newSize = fis.getChannel().size();
                        long oldSize = ((FileInputStream)this.serverLog.getInputStream()).getChannel().size();
                        if (oldSize != newSize) {
                            retVal = new BufferedReader(new InputStreamReader(newServerLog.getInputStream()));
                            this.serverLog.close();
                            this.serverLog = newServerLog;
                        }
                    }
                }
                catch (IOException ioe) {
                    Logger.getLogger("glassfish").log(Level.WARNING, null, ioe);
                }
                finally {
                    if (null != newServerLog && newServerLog != this.serverLog) {
                        newServerLog.close();
                    }
                }
            }
            return retVal;
        }
    }

    private static class LogStateListener
    implements FetchLogEventListener {
        private final GlassfishInstance instance;
        private final FetchLogPiped log;

        LogStateListener(GlassfishInstance instance, FetchLogPiped log) {
            this.instance = instance;
            this.log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(FetchLogEvent event) {
            switch (event.getState()) {
                case COMPLETED: 
                case FAILED: {
                    FetchLog oldLog = null;
                    Map<GlassfishInstance, FetchLog> map = serverInputStreams;
                    synchronized (map) {
                        FetchLog storedLog = serverInputStreams.get(this.instance);
                        if (this.log.equals(storedLog)) {
                            oldLog = serverInputStreams.remove(this.instance);
                        }
                    }
                    if (oldLog == null) break;
                    oldLog.close();
                }
            }
        }
    }

    private static final class LogFileFilter
    extends StateFilter {
        private String time;
        private String type;
        private String version;
        private String classinfo;
        private String threadinfo;
        private boolean multiline;
        private final Map<String, String> typeMap;

        public LogFileFilter(Map<String, String> typeMap) {
            this.typeMap = typeMap;
            this.reset();
        }

        @Override
        protected void reset() {
            super.reset();
            this.threadinfo = "";
            this.classinfo = "";
            this.version = "";
            this.type = "";
            this.time = "";
            this.multiline = false;
        }

        private String getLocalizedType(String type) {
            String localizedType = this.typeMap.get(type);
            return localizedType != null ? localizedType : type;
        }

        @Override
        public String process(char c) {
            Object result = null;
            switch (this.state) {
                case 0: {
                    if (c == '[') {
                        this.state = 1;
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append(c);
                        result = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append(c);
                    break;
                }
                case 1: {
                    if (c == '#') {
                        this.state = 2;
                        break;
                    }
                    this.state = 0;
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append(c);
                        result = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append('[');
                    this.msg.append(c);
                    break;
                }
                case 2: {
                    if (c == '|') {
                        this.state = 3;
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append(c);
                        result = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.state = 0;
                    this.msg.append('[');
                    this.msg.append('#');
                    this.msg.append(c);
                    break;
                }
                case 3: {
                    if (c == '|') {
                        this.state = 4;
                        this.time = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 4: {
                    if (c == '|') {
                        this.state = 5;
                        this.type = this.getLocalizedType(this.msg.toString());
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 5: {
                    if (c == '|') {
                        this.state = 6;
                        this.version = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 6: {
                    if (c == '|') {
                        this.state = 7;
                        this.classinfo = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 7: {
                    if (c == '|') {
                        this.state = 8;
                        this.threadinfo = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 8: {
                    if (c == '|') {
                        this.state = 9;
                        this.message = this.msg.toString();
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append('\n');
                        result = !this.multiline ? this.type + ": " + this.msg.toString() : this.msg.toString();
                        this.multiline = true;
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append(c);
                    break;
                }
                case 9: {
                    if (c == '#') {
                        this.state = 10;
                        break;
                    }
                    this.state = 8;
                    this.msg.append('|');
                    this.msg.append(c);
                    break;
                }
                case 10: {
                    if (c == ']') {
                        this.state = 0;
                        this.msg.setLength(0);
                        result = (String)(this.multiline ? this.message : this.type + ": " + this.message) + "\n";
                        this.reset();
                        break;
                    }
                    this.state = 8;
                    this.msg.append('|');
                    this.msg.append('#');
                    this.msg.append(c);
                }
            }
            return result;
        }
    }

    private static final class StreamFilter
    extends StateFilter {
        private static final Pattern messagePattern = Pattern.compile("([\\p{Lu}]{0,16}?):|([^\\r\\n]{0,24}?\\d\\d?:\\d\\d?:\\d\\d?)");
        private String line;

        public StreamFilter() {
            this.reset();
        }

        @Override
        protected void reset() {
            super.reset();
            this.line = "";
        }

        @Override
        public String process(char c) {
            String result = null;
            if (c == '\n') {
                if (this.msg.length() > 0) {
                    this.msg.append(c);
                    this.line = this.msg.toString();
                    this.msg.setLength(0);
                    Matcher matcher = messagePattern.matcher(this.line);
                    result = matcher.find() && matcher.start() == 0 && matcher.groupCount() > 1 && matcher.group(2) != null ? null : this.line;
                }
            } else if (c != '\r') {
                this.msg.append(c);
            }
            return result;
        }
    }

    private static abstract class StateFilter
    implements Filter {
        protected String message;
        protected int state = 0;
        protected StringBuilder msg = new StringBuilder(128);

        StateFilter() {
        }

        protected void reset() {
            this.message = "";
        }

        @Override
        public abstract String process(char var1);
    }

    private static interface Filter {
        public String process(char var1);
    }

    private class Message {
        private String message;
        private int level;
        private Color color;
        private OutputListener listener;

        public Message(String line) {
            this.message = line;
        }

        void process(List<Recognizer> recognizers) {
            this.processLevel();
            this.processColors();
            this.processRecognizers(recognizers);
        }

        private void processLevel() {
            this.level = 0;
            int colon = this.message.substring(0, Math.min(this.message.length(), 15)).indexOf(58);
            if (colon != -1) {
                try {
                    String levelPrefix = this.message.substring(0, colon);
                    this.level = Level.parse(levelPrefix).intValue();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        private void processColors() {
            try {
                Matcher matcher = colorPattern.matcher(this.message);
                boolean result = matcher.find();
                if (result) {
                    StringBuffer sb = new StringBuffer(this.message.length());
                    do {
                        int count = matcher.groupCount();
                        for (int i = 1; i < count && matcher.group(i) != null; ++i) {
                            int code = Integer.parseInt(matcher.group(i));
                            if (code < 30 || code > 36 || this.color != null) continue;
                            this.color = colorTable[code - 30];
                        }
                        matcher.appendReplacement(sb, "");
                    } while (result = matcher.find());
                    matcher.appendTail(sb);
                    this.message = sb.toString();
                }
            }
            catch (Exception ex) {
                Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
            if (this.color == null && this.level > 0) {
                if (this.level <= Level.FINE.intValue()) {
                    this.color = LOG_GREEN;
                } else if (this.level <= Level.INFO.intValue()) {
                    this.color = Color.GRAY;
                }
            }
        }

        private void processRecognizers(List<Recognizer> recognizers) {
            if (this.message.length() > 500) {
                return;
            }
            Iterator<Recognizer> iterator = recognizers.iterator();
            while (iterator.hasNext() && this.listener == null) {
                Recognizer r = iterator.next();
                try {
                    this.listener = r.processLine(this.message);
                }
                catch (Exception ex) {
                    Logger.getLogger("glassfish").log(Level.INFO, "Recognizer " + r.getClass().getName() + " generated an exception.", ex);
                }
            }
        }

        void print() {
            OutputWriter writer = LogViewMgr.this.getWriter(this.level >= 900);
            try {
                if (this.color != null && this.listener == null && IOColorLines.isSupported((InputOutput)LogViewMgr.this.io)) {
                    this.message = LogViewMgr.stripNewline(this.message);
                    IOColorLines.println((InputOutput)LogViewMgr.this.io, (CharSequence)this.message, (Color)this.color);
                } else if (writer != null) {
                    if (this.listener != null) {
                        this.message = LogViewMgr.stripNewline(this.message);
                        writer.println(this.message, this.listener, false);
                    } else {
                        writer.print(this.message);
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, ex.getLocalizedMessage(), ex);
            }
        }
    }
}

