/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.common;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.jar.Manifest;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.scripting.Scripting;
import org.netbeans.modules.apisupport.project.api.EditableManifest;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.spi.LayerUtil;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class CreatedModifiedFiles {
    private final SortedSet<String> createdPaths = new TreeSet<String>();
    private final SortedSet<String> modifiedPaths = new TreeSet<String>();
    private final SortedSet<String> invalidPaths = new TreeSet<String>();
    private final Project project;
    private final List<Operation> operations = new ArrayList<Operation>();
    private LayerHandle layerHandle;

    LayerHandle getLayerHandle() {
        if (this.layerHandle == null) {
            this.layerHandle = LayerHandle.forProject((Project)this.project);
        }
        return this.layerHandle;
    }

    public CreatedModifiedFiles(Project project) {
        this.project = project;
    }

    public void add(Operation operation) {
        this.operations.add(operation);
        this.createdPaths.addAll(Arrays.asList(operation.getCreatedPaths()));
        this.modifiedPaths.addAll(Arrays.asList(operation.getModifiedPaths()));
        this.invalidPaths.addAll(Arrays.asList(operation.getInvalidPaths()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        boolean oldAutosave = false;
        if (this.layerHandle != null) {
            oldAutosave = this.layerHandle.isAutosave();
            this.layerHandle.setAutosave(false);
        }
        try {
            AddModuleDependency depOp = null;
            Iterator<Operation> it = this.operations.iterator();
            while (it.hasNext()) {
                Operation oper = it.next();
                if (!(oper instanceof AddModuleDependency)) continue;
                if (depOp == null) {
                    depOp = (AddModuleDependency)oper;
                    continue;
                }
                depOp.addDependencies(((AddModuleDependency)oper).getDependencies());
                it.remove();
            }
            AddModuleToTargetPlatform targetPlatfOp = null;
            Iterator<Operation> it2 = this.operations.iterator();
            while (it2.hasNext()) {
                Operation oper = it2.next();
                if (!(oper instanceof AddModuleToTargetPlatform)) continue;
                if (targetPlatfOp == null) {
                    targetPlatfOp = (AddModuleToTargetPlatform)oper;
                    continue;
                }
                targetPlatfOp.addDependencies(((AddModuleToTargetPlatform)oper).getDependencies());
                it2.remove();
            }
            for (Operation op : this.operations) {
                op.run();
            }
            if (this.layerHandle != null) {
                this.layerHandle.save();
            }
        }
        finally {
            if (this.layerHandle != null) {
                this.layerHandle.setAutosave(oldAutosave);
            }
        }
    }

    public String[] getCreatedPaths() {
        if (this.createdPaths == null) {
            return new String[0];
        }
        String[] s = new String[this.createdPaths.size()];
        return this.createdPaths.toArray(s);
    }

    public String[] getModifiedPaths() {
        if (this.modifiedPaths == null) {
            return new String[0];
        }
        String[] s = new String[this.modifiedPaths.size()];
        return this.modifiedPaths.toArray(s);
    }

    public String[] getInvalidPaths() {
        if (this.invalidPaths == null) {
            return new String[0];
        }
        String[] s = new String[this.invalidPaths.size()];
        return this.invalidPaths.toArray(s);
    }

    public static FileObject getTemplate(String name) {
        FileObject f = FileUtil.getConfigFile((String)("Templates/NetBeansModuleDevelopment-files/" + name));
        assert (f != null) : name;
        return f;
    }

    public Operation createFile(String path, FileObject content) {
        return new CreateFile(this.project, path, content);
    }

    public Operation createFileWithSubstitutions(String path, FileObject content, Map<String, ? extends Object> tokens) {
        if (tokens == null) {
            throw new NullPointerException();
        }
        return new CreateFile(this.project, path, content, tokens);
    }

    public Operation bundleKeyFromPackagePath(String bundlePath, String key, String value) {
        return new BundleKey(this.project, key, value, bundlePath, true);
    }

    public Operation bundleKey(String bundlePath, String key, String value) {
        return new BundleKey(this.project, key, value, bundlePath, false);
    }

    public Operation bundleKeyDefaultBundle(String key, String value) {
        return new BundleKey(this.project, key, value);
    }

    public Operation addLoaderSection(String dataLoaderClass, String installBefore) {
        return new AddLoaderSection(this.project, dataLoaderClass, installBefore);
    }

    public Operation addLookupRegistration(String interfaceClass, String implClass, boolean inTests) {
        return new AddLookupRegistration(this.project, interfaceClass, implClass, inTests);
    }

    public Operation addModuleDependency(String codeNameBase, String releaseVersion, SpecificationVersion version, boolean useInCompiler) {
        return new AddModuleDependency(this.project, codeNameBase, releaseVersion, version, useInCompiler, false);
    }

    public Operation addModuleDependency(String codeNameBase) {
        return this.addModuleDependency(codeNameBase, null, null, true);
    }

    public Operation addModuleDependency(String codeNameBase, String releaseVersion, SpecificationVersion version, boolean useInCompiler, String clusterName) {
        return new AddModuleDependency(this.project, codeNameBase, releaseVersion, version, useInCompiler, false, clusterName);
    }

    public Operation addModuleDependency(String codeNameBase, String clusterName) {
        return this.addModuleDependency(codeNameBase, null, null, true, clusterName);
    }

    public Operation addTestModuleDependency(String codeNameBase) {
        return new AddModuleDependency(this.project, codeNameBase, null, null, true, true);
    }

    public Operation addTestModuleDependency(String codeNameBase, String clusterName) {
        return new AddModuleDependency(this.project, codeNameBase, null, null, true, true, clusterName);
    }

    public Operation addModuleToTargetPlatform(String codeNameBase, String releaseVersion, SpecificationVersion version, boolean useInCompiler, String clusterName) {
        return new AddModuleToTargetPlatform(this.project, codeNameBase, releaseVersion, version, useInCompiler, false, clusterName);
    }

    public Operation addModuleToTargetPlatform(String codeNameBase, String clusterName) {
        return this.addModuleToTargetPlatform(codeNameBase, null, null, true, clusterName);
    }

    public Operation manifestModification(String section, Map<String, String> attributes) {
        ModifyManifest retval = new ModifyManifest(this.project);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            retval.setAttribute(entry.getKey(), entry.getValue(), section);
        }
        return retval;
    }

    public Operation addManifestToken(final String header, final String token) {
        return new ModifyManifest(this, this.project){
            final /* synthetic */ CreatedModifiedFiles this$0;
            {
                this.this$0 = this$0;
                super(project);
                this.setAttribute(header, token, null);
            }

            @Override
            protected void performModification(EditableManifest em, String name, String value, String section) throws IllegalArgumentException {
                String originalValue = em.getAttribute(name, section);
                if (originalValue != null) {
                    if (!Arrays.asList(originalValue.split("[, ]+")).contains(value)) {
                        em.setAttribute(name, originalValue + ", " + value, section);
                    }
                } else {
                    super.performModification(em, name, value, section);
                }
            }
        };
    }

    public Operation propertiesModification(String propertyPath, Map<String, String> properties) {
        ModifyProperties retval = new ModifyProperties(this.project, propertyPath);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            retval.setProperty(entry.getKey(), entry.getValue());
        }
        return retval;
    }

    public Operation layerModifications(LayerOperation op, Set<String> externalFiles) {
        return new LayerModifications(this.project, op, externalFiles, this);
    }

    public Operation createLayerEntry(String layerPath, FileObject content, Map<String, ? extends Object> substitutionTokens, String localizedDisplayName, Map<String, ?> fileAttributes) {
        return new CreateLayerEntry(this, this.project, layerPath, content, substitutionTokens, localizedDisplayName, fileAttributes);
    }

    public Operation createLayerAttribute(final String parentPath, final String attrName, final Object attrValue) {
        return this.layerModifications(new LayerOperation(){
            final /* synthetic */ CreatedModifiedFiles this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(FileSystem layer) throws IOException {
                FileObject f = layer.findResource(parentPath);
                if (f == null) {
                    throw new IOException(parentPath);
                }
                f.setAttribute(attrName, attrValue);
            }
        }, Collections.emptySet());
    }

    public Operation orderLayerEntry(final String layerPath, final String precedingItemName, final String newItemName, final String followingItemName) {
        return this.layerModifications(new LayerOperation(){
            final /* synthetic */ CreatedModifiedFiles this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(FileSystem layer) throws IOException {
                FileObject f = layer.findResource(layerPath);
                if (f == null) {
                    throw new IOException("No such folder " + layerPath);
                }
                FileObject merged = ((NbModuleProvider)this.this$0.project.getLookup().lookup(NbModuleProvider.class)).getEffectiveSystemFilesystem().findResource(layerPath);
                assert (merged != null) : layerPath;
                Integer beforePos = this.getPosition(merged, precedingItemName);
                Integer afterPos = this.getPosition(merged, followingItemName);
                if (beforePos != null && afterPos != null) {
                    f.getFileObject(newItemName).setAttribute("position", (Object)((beforePos + afterPos) / 2));
                } else if (beforePos != null) {
                    f.getFileObject(newItemName).setAttribute("position", (Object)(beforePos + 100));
                } else if (afterPos != null) {
                    f.getFileObject(newItemName).setAttribute("position", (Object)(afterPos - 100));
                } else {
                    if (precedingItemName != null) {
                        f.setAttribute(precedingItemName + '/' + newItemName, (Object)true);
                    }
                    if (followingItemName != null) {
                        f.setAttribute(newItemName + '/' + followingItemName, (Object)true);
                    }
                }
            }

            private Integer getPosition(FileObject folder, String name) {
                if (name == null) {
                    return null;
                }
                FileObject f = folder.getFileObject(name);
                if (f == null) {
                    return null;
                }
                Object pos = f.getAttribute("position");
                return pos instanceof Integer ? (Integer)pos : null;
            }
        }, Collections.emptySet());
    }

    public Operation packageInfo(String packageName, Map<String, ? extends Map<String, ?>> annotations) {
        return new PackageInfo(this.project, packageName, annotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyByteAfterByte(FileObject content, FileObject target) throws IOException {
        try (OutputStream os = target.getOutputStream();
             InputStream is = content.getInputStream();){
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAndSubstituteTokens(FileObject content, FileObject target, Map<String, ? extends Object> tokens) throws IOException {
        ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (l == null) {
            l = Thread.currentThread().getContextClassLoader();
        }
        ScriptEngineManager scriptEngineManager = Scripting.createManager();
        ScriptEngine engine = scriptEngineManager.getEngineByName("freemarker");
        assert (engine != null) : "#163878: " + scriptEngineManager.getEngineFactories() + " lacks freemarker using " + l + " though lookup has " + Lookup.getDefault().lookupAll(ScriptEngineFactory.class);
        Bindings bindings = engine.getContext().getBindings(100);
        String basename = target.getName();
        for (CreateFromTemplateAttributesProvider provider : Lookup.getDefault().lookupAll(CreateFromTemplateAttributesProvider.class)) {
            Map map = provider.attributesFor(DataObject.find((FileObject)content), DataFolder.findFolder((FileObject)target.getParent()), basename);
            if (map == null) continue;
            bindings.putAll(map);
        }
        bindings.put("name", basename.replaceFirst("\\.[^./]+$", ""));
        bindings.put("user", System.getProperty("user.name"));
        Date d = new Date();
        bindings.put("date", DateFormat.getDateInstance().format(d));
        bindings.put("time", DateFormat.getTimeInstance().format(d));
        bindings.put("nameAndExt", target.getNameExt());
        bindings.putAll(tokens);
        Charset targetEnc = FileEncodingQuery.getEncoding((FileObject)target);
        Charset sourceEnc = FileEncodingQuery.getEncoding((FileObject)content);
        bindings.put("encoding", targetEnc.name());
        try (OutputStreamWriter w = new OutputStreamWriter(target.getOutputStream(), targetEnc);){
            engine.getContext().setWriter(w);
            engine.getContext().setAttribute(FileObject.class.getName(), content, 100);
            engine.getContext().setAttribute("javax.script.filename", content.getNameExt(), 100);
            try (InputStreamReader is = new InputStreamReader(content.getInputStream(), sourceEnc);){
                engine.eval(is);
            }
        }
    }

    public static interface Operation {
        public void run() throws IOException;

        public String[] getModifiedPaths();

        public String[] getCreatedPaths();

        public String[] getInvalidPaths();
    }

    private static final class AddModuleDependency
    extends AddOperation {
        public AddModuleDependency(Project project, String codeNameBase, String releaseVersion, SpecificationVersion specVersion, boolean useInCompiler, boolean test, String clusterName) {
            super(project, codeNameBase, releaseVersion, specVersion, useInCompiler, test, clusterName);
        }

        public AddModuleDependency(Project project, String codeNameBase, String releaseVersion, SpecificationVersion specVersion, boolean useInCompiler, boolean test) {
            super(project, codeNameBase, releaseVersion, specVersion, useInCompiler, test);
        }

        @Override
        public void run() throws IOException {
            this.getModuleInfo().addDependencies(this.dependencies.toArray(new NbModuleProvider.ModuleDependency[0]));
            ProjectManager.getDefault().saveProject(this.getProject());
        }
    }

    private static final class AddModuleToTargetPlatform
    extends AddOperation {
        public AddModuleToTargetPlatform(Project project, String codeNameBase, String releaseVersion, SpecificationVersion specVersion, boolean useInCompiler, boolean test, String clusterName) {
            super(project, codeNameBase, releaseVersion, specVersion, useInCompiler, test, clusterName);
        }

        public AddModuleToTargetPlatform(Project project, String codeNameBase, String releaseVersion, SpecificationVersion specVersion, boolean useInCompiler, boolean test) {
            super(project, codeNameBase, releaseVersion, specVersion, useInCompiler, test);
        }

        @Override
        public void run() throws IOException {
            this.getModuleInfo().addModulesToTargetPlatform(this.dependencies.toArray(new NbModuleProvider.ModuleDependency[0]));
            ProjectManager.getDefault().saveProject(this.getProject());
        }
    }

    private static final class CreateFile
    extends AbstractOperation {
        private String path;
        private FileObject content;
        private Map<String, ? extends Object> tokens;

        public CreateFile(Project project, String path, FileObject content) {
            this(project, path, content, null);
        }

        public CreateFile(Project project, String path, FileObject content, Map<String, ? extends Object> tokens) {
            super(project);
            this.path = path;
            if (content == null) {
                throw new NullPointerException();
            }
            this.content = content;
            this.tokens = tokens;
            this.addCreatedOrModifiedPath(path, false);
        }

        @Override
        public void run() throws IOException {
            FileObject target = FileUtil.createData((FileObject)this.getProject().getProjectDirectory(), (String)this.path);
            if (this.tokens == null) {
                CreatedModifiedFiles.copyByteAfterByte(this.content, target);
            } else {
                CreatedModifiedFiles.copyAndSubstituteTokens(this.content, target, this.tokens);
            }
            if (target.hasExt("form")) {
                FileObject java = FileUtil.findBrother((FileObject)target, (String)"java");
                if (java != null) {
                    java.setAttribute("justCreatedByNewWizard", (Object)true);
                }
            } else if (target.hasExt("java") && FileUtil.findBrother((FileObject)target, (String)"form") != null) {
                target.setAttribute("justCreatedByNewWizard", (Object)true);
            }
        }
    }

    private static final class BundleKey
    extends AbstractOperation {
        private final String bundlePath;
        private final String key;
        private final String value;

        public BundleKey(Project project, String key, String value) {
            this(project, key, value, null, false);
        }

        public BundleKey(Project project, String key, String value, String bundlePath, Boolean packageBundlePath) {
            super(project);
            this.key = key;
            this.value = value;
            if (bundlePath == null) {
                ManifestManager mm = ManifestManager.getInstance((Manifest)Util.getManifest((FileObject)this.getModuleInfo().getManifestFile()), (boolean)false);
                String srcDir = this.getModuleInfo().getResourceDirectoryPath(false);
                this.bundlePath = srcDir + "/" + mm.getLocalizingBundle();
            } else if (packageBundlePath.booleanValue()) {
                String srcDir = this.getModuleInfo().getResourceDirectoryPath(false);
                this.bundlePath = srcDir + "/" + bundlePath.replace('.', '/') + ".properties";
            } else {
                this.bundlePath = bundlePath;
            }
            this.addCreatedOrModifiedPath(this.bundlePath, true);
        }

        @Override
        public void run() throws IOException {
            FileObject prjDir = this.getProject().getProjectDirectory();
            FileObject bundleFO = FileUtil.createData((FileObject)prjDir, (String)this.bundlePath);
            EditableProperties ep = Util.loadProperties((FileObject)bundleFO);
            ep.setProperty(this.key, this.value);
            Util.storeProperties((FileObject)bundleFO, (EditableProperties)ep);
        }
    }

    private static final class AddLoaderSection
    extends AbstractOperation {
        private FileObject mfFO;
        private String dataLoaderClass;
        private String installBefore;

        public AddLoaderSection(Project project, String dataLoaderClass, String installBefore) {
            super(project);
            this.dataLoaderClass = dataLoaderClass + ".class";
            this.installBefore = installBefore;
            this.mfFO = this.getModuleInfo().getManifestFile();
            this.addModifiedFileObject(this.mfFO);
        }

        @Override
        public void run() throws IOException {
            try {
                DataObject dobj = DataObject.find((FileObject)this.mfFO);
                SaveCookie safe = (SaveCookie)dobj.getLookup().lookup(SaveCookie.class);
                if (safe != null) {
                    safe.save();
                }
            }
            catch (DataObjectNotFoundException ex) {
                Util.err.notify(16, (Throwable)ex);
            }
            EditableManifest em = Util.loadManifest((FileObject)this.mfFO);
            em.addSection(this.dataLoaderClass);
            em.setAttribute("OpenIDE-Module-Class", "Loader", this.dataLoaderClass);
            if (this.installBefore != null) {
                em.setAttribute("Install-Before", this.installBefore, this.dataLoaderClass);
            }
            Util.storeManifest((FileObject)this.mfFO, (EditableManifest)em);
        }
    }

    private static final class AddLookupRegistration
    extends AbstractOperation {
        private String interfaceClassPath;
        private String implClass;

        public AddLookupRegistration(Project project, String interfaceClass, String implClass, boolean inTests) {
            super(project);
            this.implClass = implClass;
            this.interfaceClassPath = this.getModuleInfo().getResourceDirectoryPath(inTests) + "/META-INF/services/" + interfaceClass;
            this.addCreatedOrModifiedPath(this.interfaceClassPath, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() throws IOException {
            FileObject service = FileUtil.createData((FileObject)this.getProject().getProjectDirectory(), (String)this.interfaceClassPath);
            ArrayList<String> lines = new ArrayList<String>();
            try (InputStream serviceIS = service.getInputStream();){
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(serviceIS, StandardCharsets.UTF_8));
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
            }
            try (OutputStream os = service.getOutputStream();){
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
                Iterator it = lines.iterator();
                while (it.hasNext()) {
                    String line = (String)it.next();
                    if (!it.hasNext() && line.trim().equals("")) continue;
                    pw.println(line);
                }
                pw.println(this.implClass);
                pw.flush();
            }
        }
    }

    private static class ModifyManifest
    extends AbstractOperation {
        private final FileObject manifestFile = this.getModuleInfo().getManifestFile();
        private Map<String, Map<String, String>> attributesToAdd = new HashMap<String, Map<String, String>>();

        public ModifyManifest(Project project) {
            super(project);
            if (this.manifestFile != null) {
                this.addModifiedFileObject(this.manifestFile);
            }
        }

        public final void setAttribute(String name, String value, String section) {
            Map<String, String> attribs = this.attributesToAdd.get(section);
            if (attribs == null) {
                attribs = new HashMap<String, String>();
                this.attributesToAdd.put(section, attribs);
            }
            attribs.put(name, value);
        }

        protected void performModification(EditableManifest em, String name, String value, String section) {
            if (section != null && em.getSectionNames().contains(section)) {
                em.addSection(section);
            }
            em.setAttribute(name, value, section);
        }

        @Override
        public final void run() throws IOException {
            if (this.manifestFile == null) {
                throw new IOException("No manifest.mf to edit");
            }
            this.ensureSavingFirst();
            EditableManifest em = Util.loadManifest((FileObject)this.manifestFile);
            for (Map.Entry<String, Map<String, String>> entry : this.attributesToAdd.entrySet()) {
                String section = entry.getKey();
                for (Map.Entry<String, String> subentry : entry.getValue().entrySet()) {
                    this.performModification(em, subentry.getKey(), subentry.getValue(), "null".equals(section) ? null : section);
                }
            }
            Util.storeManifest((FileObject)this.manifestFile, (EditableManifest)em);
        }

        private void ensureSavingFirst() throws IOException {
            try {
                DataObject dobj = DataObject.find((FileObject)this.manifestFile);
                SaveCookie safe = (SaveCookie)dobj.getLookup().lookup(SaveCookie.class);
                if (safe != null) {
                    safe.save();
                }
            }
            catch (DataObjectNotFoundException ex) {
                Util.err.notify(16, (Throwable)ex);
            }
        }
    }

    private static class ModifyProperties
    extends AbstractOperation {
        private Map<String, String> properties;
        private final String propertyPath;
        private EditableProperties ep;
        private FileObject propertiesFile;

        private ModifyProperties(Project project, String propertyPath) {
            super(project);
            this.propertyPath = propertyPath;
            this.addCreatedOrModifiedPath(propertyPath, true);
        }

        @Override
        public void run() throws IOException {
            EditableProperties p = this.getEditableProperties();
            p.putAll(this.getProperties());
            Util.storeProperties((FileObject)this.getPropertyFile(), (EditableProperties)p);
        }

        public final void setProperty(String name, String value) {
            this.getProperties().put(name, value);
        }

        protected final FileObject getPropertyFile() throws IOException {
            if (this.propertiesFile == null) {
                FileObject projectDirectory = this.getProject().getProjectDirectory();
                this.propertiesFile = FileUtil.createData((FileObject)projectDirectory, (String)this.propertyPath);
            }
            return this.propertiesFile;
        }

        protected final EditableProperties getEditableProperties() throws IOException {
            if (this.ep == null) {
                this.ep = Util.loadProperties((FileObject)this.getPropertyFile());
            }
            return this.ep;
        }

        protected final Map<String, String> getProperties() {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            return this.properties;
        }
    }

    private static final class LayerModifications
    implements Operation {
        private final Project project;
        private final LayerOperation op;
        private final Set<String> externalFiles;
        private final CreatedModifiedFiles cmf;

        public LayerModifications(Project project, LayerOperation op, Set<String> externalFiles, CreatedModifiedFiles cmf) {
            this.project = project;
            this.op = op;
            this.externalFiles = externalFiles;
            this.cmf = cmf;
        }

        @Override
        public void run() throws IOException {
            this.op.run(this.cmf.getLayerHandle().layer(true));
        }

        @Override
        public String[] getModifiedPaths() {
            FileObject layer = this.cmf.getLayerHandle().getLayerFile();
            NbModuleProvider provider = (NbModuleProvider)this.project.getLookup().lookup(NbModuleProvider.class);
            if (layer != null) {
                return new String[]{FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)layer)};
            }
            if (provider.getManifestFile() != null) {
                return new String[]{FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)provider.getManifestFile())};
            }
            return new String[0];
        }

        @Override
        public String[] getCreatedPaths() {
            LayerHandle handle = this.cmf.getLayerHandle();
            FileObject layer = handle.getLayerFile();
            String layerPath = layer != null ? FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)layer) : ((NbModuleProvider)this.project.getLookup().lookup(NbModuleProvider.class)).getResourceDirectoryPath(false) + '/' + handle.newLayerPath();
            int slash = layerPath.lastIndexOf(47);
            String prefix = layerPath.substring(0, slash + 1);
            TreeSet<String> s = new TreeSet<String>();
            if (layer == null) {
                s.add(layerPath);
            }
            for (String file : this.externalFiles) {
                s.add(prefix + file);
            }
            return s.toArray(new String[0]);
        }

        @Override
        public String[] getInvalidPaths() {
            return new String[0];
        }
    }

    public static interface LayerOperation {
        public void run(FileSystem var1) throws IOException;
    }

    private static final class CreateLayerEntry
    extends AbstractOperation {
        private final Operation createBundleKey;
        private final Operation layerOp;

        public CreateLayerEntry(CreatedModifiedFiles cmf, Project project, final String layerPath, final FileObject content, final Map<String, ? extends Object> tokens, final String localizedDisplayName, final Map<String, ?> attrs) {
            super(project);
            Set<String> externalFiles;
            final String locBundleKey = localizedDisplayName != null ? LayerUtil.generateBundleKeyForFile((String)layerPath) : null;
            LayerOperation op = new LayerOperation(){
                final /* synthetic */ CreateLayerEntry this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run(FileSystem layer) throws IOException {
                    FileObject targetFO = FileUtil.createData((FileObject)layer.getRoot(), (String)layerPath);
                    if (content != null) {
                        if (tokens == null) {
                            CreatedModifiedFiles.copyByteAfterByte(content, targetFO);
                        } else {
                            CreatedModifiedFiles.copyAndSubstituteTokens(content, targetFO, tokens);
                        }
                    }
                    if (localizedDisplayName != null) {
                        String bundlePath = ManifestManager.getInstance((Manifest)Util.getManifest((FileObject)this.this$0.getModuleInfo().getManifestFile()), (boolean)false).getLocalizingBundle();
                        String suffix = ".properties";
                        if (bundlePath != null && bundlePath.endsWith(suffix)) {
                            String name = bundlePath.substring(0, bundlePath.length() - suffix.length()).replace('/', '.');
                            targetFO.setAttribute("displayName", (Object)("bundlevalue:" + name + "#" + locBundleKey));
                        }
                    }
                    if (attrs != null) {
                        for (Map.Entry entry : attrs.entrySet()) {
                            targetFO.setAttribute((String)entry.getKey(), entry.getValue());
                        }
                    }
                }
            };
            if (content != null) {
                FileObject xml = LayerHandle.forProject((Project)project).getLayerFile();
                FileObject parent = xml != null ? xml.getParent() : null;
                externalFiles = Collections.singleton(LayerUtil.findGeneratedName((FileObject)parent, (String)layerPath));
            } else {
                externalFiles = Collections.emptySet();
            }
            FileSystem layer = cmf.getLayerHandle().layer(false);
            this.layerOp = layer != null && layer.findResource(layerPath) != null ? new Operation(){
                final /* synthetic */ CreateLayerEntry this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() throws IOException {
                    throw new IOException("cannot overwrite " + layerPath);
                }

                @Override
                public String[] getModifiedPaths() {
                    return new String[0];
                }

                @Override
                public String[] getCreatedPaths() {
                    return new String[0];
                }

                @Override
                public String[] getInvalidPaths() {
                    return new String[]{layerPath};
                }
            } : new LayerModifications(project, op, externalFiles, cmf);
            this.addPaths(this.layerOp);
            if (localizedDisplayName != null) {
                this.createBundleKey = new BundleKey(this.getProject(), locBundleKey, localizedDisplayName);
                this.addPaths(this.createBundleKey);
            } else {
                this.createBundleKey = null;
            }
        }

        @Override
        public void run() throws IOException {
            this.layerOp.run();
            if (this.createBundleKey != null) {
                this.createBundleKey.run();
            }
        }
    }

    private static class PackageInfo
    extends AbstractOperation {
        private final Map<String, ? extends Map<String, ?>> annotations;
        private final String srcRootPath;
        private final String srcRelPath;

        PackageInfo(Project project, String packageName, Map<String, ? extends Map<String, ?>> annotations) {
            super(project);
            this.annotations = annotations;
            this.srcRootPath = this.getModuleInfo().getSourceDirectoryPath();
            this.srcRelPath = packageName.replace('.', '/') + "/package-info.java";
            this.addCreatedOrModifiedPath(this.srcRootPath + '/' + this.srcRelPath, true);
        }

        @Override
        public void run() throws IOException {
            final FileObject top = this.getProject().getProjectDirectory();
            top.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){
                final /* synthetic */ PackageInfo this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() throws IOException {
                    FileObject srcFile2;
                    JavaSource source;
                    final FileObject srcRoot = FileUtil.createFolder((FileObject)top, (String)this.this$0.srcRootPath);
                    final FileObject srcFile = srcRoot.getFileObject(this.this$0.srcRelPath);
                    if (srcFile != null) {
                        source = JavaSource.forFileObject((FileObject)srcFile);
                        if (source == null) {
                            throw new IOException("unparsable: " + srcFile);
                        }
                    } else {
                        source = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)srcRoot), (FileObject[])new FileObject[0]);
                    }
                    try {
                        source.runWhenScanFinished((Task)new Task<CompilationController>(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run(CompilationController parameter) throws Exception {
                                source.runModificationTask((Task)new Task<WorkingCopy>(){
                                    final /* synthetic */ PackageInfo.1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    public void run(WorkingCopy wc) throws Exception {
                                        CompilationUnitTree old;
                                        CompilationUnitTree nue;
                                        wc.toPhase(JavaSource.Phase.RESOLVED);
                                        TreeMaker make = wc.getTreeMaker();
                                        ArrayList<AnnotationTree> anns = new ArrayList<AnnotationTree>();
                                        for (Map.Entry ann : this.this$2.this$1.this$0.annotations.entrySet()) {
                                            TypeElement annType = wc.getElements().getTypeElement((CharSequence)ann.getKey());
                                            if (annType == null) {
                                                throw new IOException("No annotation " + (String)ann.getKey() + " in " + wc.getClasspathInfo());
                                            }
                                            ExpressionTree annotationTypeTree = make.QualIdent((Element)annType);
                                            ArrayList<AssignmentTree> arguments = new ArrayList<AssignmentTree>();
                                            for (Map.Entry attr : ((Map)ann.getValue()).entrySet()) {
                                                ExpressionTree expression;
                                                Object value = attr.getValue();
                                                if (value instanceof Object[]) {
                                                    ArrayList<LiteralTree> expressions = new ArrayList<LiteralTree>();
                                                    for (Object element : (Object[])value) {
                                                        expressions.add(make.Literal(element));
                                                    }
                                                    expression = make.NewArray(null, Collections.emptyList(), expressions);
                                                } else {
                                                    expression = make.Literal(value);
                                                }
                                                arguments.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)attr.getKey()), expression));
                                            }
                                            anns.add(make.Annotation((Tree)annotationTypeTree, arguments));
                                        }
                                        if (srcFile != null) {
                                            old = nue = wc.getCompilationUnit();
                                            for (AnnotationTree ann : anns) {
                                                nue = make.addPackageAnnotation(nue, ann);
                                            }
                                        } else {
                                            old = null;
                                            nue = make.CompilationUnit(anns, srcRoot, this.this$2.this$1.this$0.srcRelPath, Collections.emptyList(), Collections.emptyList());
                                        }
                                        nue = (CompilationUnitTree)GeneratorUtilities.get((WorkingCopy)wc).importFQNs((Tree)nue);
                                        wc.rewrite((Tree)old, (Tree)nue);
                                    }
                                }).commit();
                            }
                        }, false).get();
                    }
                    catch (IOException x) {
                        throw x;
                    }
                    catch (InterruptedException x) {
                        throw new IOException(x);
                    }
                    catch (ExecutionException x) {
                        throw new IOException(x);
                    }
                    FileObject fileObject = srcFile2 = srcFile != null ? srcFile : srcRoot.getFileObject(this.this$0.srcRelPath);
                    if (srcFile2 == null) {
                        throw new IOException("#204274: no package-info.java created?");
                    }
                    SaveCookie sc = (SaveCookie)DataObject.find((FileObject)srcFile2).getLookup().lookup(SaveCookie.class);
                    if (sc != null) {
                        sc.save();
                    }
                }
            });
        }
    }

    private static abstract class AddOperation
    extends AbstractOperation {
        protected List<NbModuleProvider.ModuleDependency> dependencies = new ArrayList<NbModuleProvider.ModuleDependency>();
        private Map<String, NbModuleProvider.ModuleDependency> codenamebaseMap = new HashMap<String, NbModuleProvider.ModuleDependency>();

        public AddOperation(Project project, String codeNameBase, String releaseVersion, SpecificationVersion specVersion, boolean useInCompiler, boolean test, String clusterName) {
            super(project);
            NbModuleProvider.ModuleDependency module = new NbModuleProvider.ModuleDependency(codeNameBase, releaseVersion, specVersion, useInCompiler, clusterName);
            if (test) {
                module.setTestDependency(true);
            }
            this.addDependencies(Collections.singletonList(module));
            this.getModifiedPathsSet().add(this.getModuleInfo().getProjectFilePath());
        }

        public AddOperation(Project project, String codeNameBase, String releaseVersion, SpecificationVersion specVersion, boolean useInCompiler, boolean test) {
            this(project, codeNameBase, releaseVersion, specVersion, useInCompiler, test, null);
        }

        public List<NbModuleProvider.ModuleDependency> getDependencies() {
            return this.dependencies;
        }

        protected void addDependencies(List<NbModuleProvider.ModuleDependency> list) {
            for (NbModuleProvider.ModuleDependency md : list) {
                NbModuleProvider.ModuleDependency res = this.codenamebaseMap.get(md.getCodeNameBase());
                if (res != null) continue;
                this.codenamebaseMap.put(md.getCodeNameBase(), md);
                this.dependencies.add(md);
            }
        }
    }

    public static abstract class AbstractOperation
    implements Operation {
        private Project project;
        private SortedSet<String> createdPaths;
        private SortedSet<String> modifiedPaths;
        private SortedSet<String> invalidPaths;

        protected AbstractOperation(Project project) {
            this.project = project;
        }

        protected Project getProject() {
            return this.project;
        }

        protected NbModuleProvider getModuleInfo() {
            return (NbModuleProvider)this.getProject().getLookup().lookup(NbModuleProvider.class);
        }

        @Override
        public String[] getModifiedPaths() {
            String[] s = new String[this.getModifiedPathsSet().size()];
            return this.getModifiedPathsSet().toArray(s);
        }

        @Override
        public String[] getCreatedPaths() {
            String[] s = new String[this.getCreatedPathsSet().size()];
            return this.getCreatedPathsSet().toArray(s);
        }

        @Override
        public String[] getInvalidPaths() {
            String[] s = new String[this.getInvalidPathsSet().size()];
            return this.getInvalidPathsSet().toArray(s);
        }

        protected void addCreatedOrModifiedPath(String relPath, boolean allowFileModification) {
            if (this.getProject().getProjectDirectory().getFileObject(relPath) == null) {
                this.getCreatedPathsSet().add(relPath);
            } else if (allowFileModification) {
                this.getModifiedPathsSet().add(relPath);
            } else {
                this.getInvalidPathsSet().add(relPath);
            }
        }

        protected void addPaths(Operation o) {
            this.getCreatedPathsSet().addAll(Arrays.asList(o.getCreatedPaths()));
            this.getModifiedPathsSet().addAll(Arrays.asList(o.getModifiedPaths()));
            this.getInvalidPathsSet().addAll(Arrays.asList(o.getInvalidPaths()));
        }

        protected SortedSet<String> getCreatedPathsSet() {
            if (this.createdPaths == null) {
                this.createdPaths = new TreeSet<String>();
            }
            return this.createdPaths;
        }

        protected SortedSet<String> getInvalidPathsSet() {
            if (this.invalidPaths == null) {
                this.invalidPaths = new TreeSet<String>();
            }
            return this.invalidPaths;
        }

        protected SortedSet<String> getModifiedPathsSet() {
            if (this.modifiedPaths == null) {
                this.modifiedPaths = new TreeSet<String>();
            }
            return this.modifiedPaths;
        }

        protected boolean addCreatedFileObject(FileObject fo) {
            Parameters.notNull((CharSequence)"fo", (Object)fo);
            return this.getCreatedPathsSet().add(this.getProjectPath(fo));
        }

        protected boolean addModifiedFileObject(FileObject fo) {
            Parameters.notNull((CharSequence)"fo", (Object)fo);
            return this.getModifiedPathsSet().add(this.getProjectPath(fo));
        }

        private String getProjectPath(FileObject file) {
            return PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.getProject().getProjectDirectory()), (File)FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)file)));
        }
    }
}

