/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExadataInfrastructureOcpusRequest
extends BmcRequest<Void> {
    private String autonomousExadataInfrastructureId;
    private String opcRequestId;

    public String getAutonomousExadataInfrastructureId() {
        return this.autonomousExadataInfrastructureId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().autonomousExadataInfrastructureId(this.autonomousExadataInfrastructureId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",autonomousExadataInfrastructureId=").append(String.valueOf(this.autonomousExadataInfrastructureId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExadataInfrastructureOcpusRequest)) {
            return false;
        }
        GetExadataInfrastructureOcpusRequest other = (GetExadataInfrastructureOcpusRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.autonomousExadataInfrastructureId, other.autonomousExadataInfrastructureId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.autonomousExadataInfrastructureId == null ? 43 : this.autonomousExadataInfrastructureId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExadataInfrastructureOcpusRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String autonomousExadataInfrastructureId = null;
        private String opcRequestId = null;

        public Builder autonomousExadataInfrastructureId(String autonomousExadataInfrastructureId) {
            this.autonomousExadataInfrastructureId = autonomousExadataInfrastructureId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExadataInfrastructureOcpusRequest o) {
            this.autonomousExadataInfrastructureId(o.getAutonomousExadataInfrastructureId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExadataInfrastructureOcpusRequest build() {
            GetExadataInfrastructureOcpusRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExadataInfrastructureOcpusRequest buildWithoutInvocationCallback() {
            GetExadataInfrastructureOcpusRequest request = new GetExadataInfrastructureOcpusRequest();
            request.autonomousExadataInfrastructureId = this.autonomousExadataInfrastructureId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

