/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.commit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.spellchecker.api.Spellchecker;
import org.netbeans.modules.versioning.util.UndoRedoSupport;

public class MessageArea
extends JTextArea {
    private UndoRedoSupport um;
    private int messageWidth;
    private int titleWidth;

    @Override
    public void paint(Graphics g) {
        Rectangle intersect;
        int x;
        super.paint(g);
        int charWidth = g.getFontMetrics().charWidth(' ');
        int bodyLineStarts = 0;
        int charHeight = g.getFontMetrics().getHeight();
        Rectangle visibleRect = this.getVisibleRect();
        if (this.titleWidth > 0) {
            x = this.titleWidth * charWidth;
            intersect = visibleRect.intersection(new Rectangle(x, 0, 1, charHeight));
            if (!intersect.isEmpty()) {
                g.setColor(Color.red);
                g.drawLine(x, intersect.y, x, intersect.y + intersect.height);
            }
            bodyLineStarts = 2 * charHeight;
        }
        if (this.messageWidth > 0 && !(intersect = visibleRect.intersection(new Rectangle(x = this.messageWidth * charWidth, bodyLineStarts, 1, visibleRect.y + visibleRect.height))).isEmpty()) {
            g.setColor(Color.red);
            g.drawLine(x, intersect.y, x, intersect.y + intersect.height);
        }
    }

    public void open() {
        if (this.um == null) {
            this.um = UndoRedoSupport.register((JTextComponent)this);
            Spellchecker.register((JTextComponent)this);
        }
    }

    public void close() {
        if (this.um != null) {
            this.um.unregister();
            this.um = null;
        }
    }

    void setNumberOfChars(int numberOfChars) {
        this.messageWidth = numberOfChars;
    }

    void setNumberOfTitleChars(int numberOfTitleChars) {
        this.titleWidth = numberOfTitleChars;
    }
}

