/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.options.HintsPanelLogic;

public final class InspectionComboModel
extends AbstractListModel
implements ComboBoxModel {
    private Object selected;
    private final ArrayList<Object> hintsList;

    public InspectionComboModel(Collection<? extends HintMetadata> hints) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.constructTM(hints, false).getRoot();
        Enumeration<TreeNode> enumeration = root.preorderEnumeration();
        this.hintsList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            Object userObject = ((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
            if (userObject == null) continue;
            this.hintsList.add(userObject);
        }
        if (this.getSize() > 0) {
            this.selected = this.getElementAt(Math.min(this.getSize(), 1));
        }
    }

    @Override
    public int getSize() {
        return this.hintsList.size();
    }

    @Override
    public Object getElementAt(int i) {
        return this.hintsList.get(i);
    }

    @Override
    public void setSelectedItem(Object o) {
        this.selected = o;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    private DefaultTreeModel constructTM(Collection<? extends HintMetadata> metadata, boolean allHints) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        TreeMap<HintsPanelLogic.HintCategory, TreeSet<HintMetadata>> cat2Hints = new TreeMap<HintsPanelLogic.HintCategory, TreeSet<HintMetadata>>(new Comparator<HintsPanelLogic.HintCategory>(){

            @Override
            public int compare(HintsPanelLogic.HintCategory o1, HintsPanelLogic.HintCategory o2) {
                return o1.displayName.compareToIgnoreCase(o2.displayName);
            }
        });
        HashMap<String, HintsPanelLogic.HintCategory> cat2CatDesc = new HashMap<String, HintsPanelLogic.HintCategory>();
        for (HintMetadata hintMetadata : metadata) {
            TreeSet<HintMetadata> catNode;
            if (hintMetadata.options.contains(HintMetadata.Options.NON_GUI) || hintMetadata.options.contains(HintMetadata.Options.QUERY)) continue;
            HintsPanelLogic.HintCategory cat = (HintsPanelLogic.HintCategory)cat2CatDesc.get(hintMetadata.category);
            if (cat == null) {
                cat = new HintsPanelLogic.HintCategory(hintMetadata.category);
                cat2CatDesc.put(hintMetadata.category, cat);
            }
            if ((catNode = (TreeSet<HintMetadata>)cat2Hints.get(cat)) == null) {
                catNode = new TreeSet<HintMetadata>(new Comparator<HintMetadata>(){

                    @Override
                    public int compare(HintMetadata o1, HintMetadata o2) {
                        return o1.displayName.compareToIgnoreCase(o2.displayName);
                    }
                });
                cat2Hints.put(cat, catNode);
            }
            catNode.add(hintMetadata);
        }
        for (Map.Entry entry : cat2Hints.entrySet()) {
            DefaultMutableTreeNode catNode = new DefaultMutableTreeNode(entry.getKey());
            for (HintMetadata hm : (Collection)entry.getValue()) {
                DefaultMutableTreeNode hmNode = new DefaultMutableTreeNode(hm);
                catNode.add(hmNode);
            }
            root.add(catNode);
        }
        return new DefaultTreeModel(root);
    }
}

