/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.model.Range;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetObjectRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String bucketName;
    private String objectName;
    private String versionId;
    private String ifMatch;
    private String ifNoneMatch;
    private String opcClientRequestId;
    private Range range;
    private String opcSseCustomerAlgorithm;
    private String opcSseCustomerKey;
    private String opcSseCustomerKeySha256;
    private String httpResponseContentDisposition;
    private String httpResponseCacheControl;
    private String httpResponseContentType;
    private String httpResponseContentLanguage;
    private String httpResponseContentEncoding;
    private String httpResponseExpires;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public Range getRange() {
        return this.range;
    }

    public String getOpcSseCustomerAlgorithm() {
        return this.opcSseCustomerAlgorithm;
    }

    public String getOpcSseCustomerKey() {
        return this.opcSseCustomerKey;
    }

    public String getOpcSseCustomerKeySha256() {
        return this.opcSseCustomerKeySha256;
    }

    public String getHttpResponseContentDisposition() {
        return this.httpResponseContentDisposition;
    }

    public String getHttpResponseCacheControl() {
        return this.httpResponseCacheControl;
    }

    public String getHttpResponseContentType() {
        return this.httpResponseContentType;
    }

    public String getHttpResponseContentLanguage() {
        return this.httpResponseContentLanguage;
    }

    public String getHttpResponseContentEncoding() {
        return this.httpResponseContentEncoding;
    }

    public String getHttpResponseExpires() {
        return this.httpResponseExpires;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).objectName(this.objectName).versionId(this.versionId).ifMatch(this.ifMatch).ifNoneMatch(this.ifNoneMatch).opcClientRequestId(this.opcClientRequestId).range(this.range).opcSseCustomerAlgorithm(this.opcSseCustomerAlgorithm).opcSseCustomerKey(this.opcSseCustomerKey).opcSseCustomerKeySha256(this.opcSseCustomerKeySha256).httpResponseContentDisposition(this.httpResponseContentDisposition).httpResponseCacheControl(this.httpResponseCacheControl).httpResponseContentType(this.httpResponseContentType).httpResponseContentLanguage(this.httpResponseContentLanguage).httpResponseContentEncoding(this.httpResponseContentEncoding).httpResponseExpires(this.httpResponseExpires);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",bucketName=").append(String.valueOf(this.bucketName));
        sb.append(",objectName=").append(String.valueOf(this.objectName));
        sb.append(",versionId=").append(String.valueOf(this.versionId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",range=").append(String.valueOf(this.range));
        sb.append(",opcSseCustomerAlgorithm=").append(String.valueOf(this.opcSseCustomerAlgorithm));
        sb.append(",opcSseCustomerKey=").append(String.valueOf(this.opcSseCustomerKey));
        sb.append(",opcSseCustomerKeySha256=").append(String.valueOf(this.opcSseCustomerKeySha256));
        sb.append(",httpResponseContentDisposition=").append(String.valueOf(this.httpResponseContentDisposition));
        sb.append(",httpResponseCacheControl=").append(String.valueOf(this.httpResponseCacheControl));
        sb.append(",httpResponseContentType=").append(String.valueOf(this.httpResponseContentType));
        sb.append(",httpResponseContentLanguage=").append(String.valueOf(this.httpResponseContentLanguage));
        sb.append(",httpResponseContentEncoding=").append(String.valueOf(this.httpResponseContentEncoding));
        sb.append(",httpResponseExpires=").append(String.valueOf(this.httpResponseExpires));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetObjectRequest)) {
            return false;
        }
        GetObjectRequest other = (GetObjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.versionId, other.versionId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.range, other.range) && Objects.equals(this.opcSseCustomerAlgorithm, other.opcSseCustomerAlgorithm) && Objects.equals(this.opcSseCustomerKey, other.opcSseCustomerKey) && Objects.equals(this.opcSseCustomerKeySha256, other.opcSseCustomerKeySha256) && Objects.equals(this.httpResponseContentDisposition, other.httpResponseContentDisposition) && Objects.equals(this.httpResponseCacheControl, other.httpResponseCacheControl) && Objects.equals(this.httpResponseContentType, other.httpResponseContentType) && Objects.equals(this.httpResponseContentLanguage, other.httpResponseContentLanguage) && Objects.equals(this.httpResponseContentEncoding, other.httpResponseContentEncoding) && Objects.equals(this.httpResponseExpires, other.httpResponseExpires);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.versionId == null ? 43 : this.versionId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.range == null ? 43 : this.range.hashCode());
        result = result * 59 + (this.opcSseCustomerAlgorithm == null ? 43 : this.opcSseCustomerAlgorithm.hashCode());
        result = result * 59 + (this.opcSseCustomerKey == null ? 43 : this.opcSseCustomerKey.hashCode());
        result = result * 59 + (this.opcSseCustomerKeySha256 == null ? 43 : this.opcSseCustomerKeySha256.hashCode());
        result = result * 59 + (this.httpResponseContentDisposition == null ? 43 : this.httpResponseContentDisposition.hashCode());
        result = result * 59 + (this.httpResponseCacheControl == null ? 43 : this.httpResponseCacheControl.hashCode());
        result = result * 59 + (this.httpResponseContentType == null ? 43 : this.httpResponseContentType.hashCode());
        result = result * 59 + (this.httpResponseContentLanguage == null ? 43 : this.httpResponseContentLanguage.hashCode());
        result = result * 59 + (this.httpResponseContentEncoding == null ? 43 : this.httpResponseContentEncoding.hashCode());
        result = result * 59 + (this.httpResponseExpires == null ? 43 : this.httpResponseExpires.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetObjectRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String bucketName = null;
        private String objectName = null;
        private String versionId = null;
        private String ifMatch = null;
        private String ifNoneMatch = null;
        private String opcClientRequestId = null;
        private Range range = null;
        private String opcSseCustomerAlgorithm = null;
        private String opcSseCustomerKey = null;
        private String opcSseCustomerKeySha256 = null;
        private String httpResponseContentDisposition = null;
        private String httpResponseCacheControl = null;
        private String httpResponseContentType = null;
        private String httpResponseContentLanguage = null;
        private String httpResponseContentEncoding = null;
        private String httpResponseExpires = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder range(Range range) {
            this.range = range;
            return this;
        }

        public Builder opcSseCustomerAlgorithm(String opcSseCustomerAlgorithm) {
            this.opcSseCustomerAlgorithm = opcSseCustomerAlgorithm;
            return this;
        }

        public Builder opcSseCustomerKey(String opcSseCustomerKey) {
            this.opcSseCustomerKey = opcSseCustomerKey;
            return this;
        }

        public Builder opcSseCustomerKeySha256(String opcSseCustomerKeySha256) {
            this.opcSseCustomerKeySha256 = opcSseCustomerKeySha256;
            return this;
        }

        public Builder httpResponseContentDisposition(String httpResponseContentDisposition) {
            this.httpResponseContentDisposition = httpResponseContentDisposition;
            return this;
        }

        public Builder httpResponseCacheControl(String httpResponseCacheControl) {
            this.httpResponseCacheControl = httpResponseCacheControl;
            return this;
        }

        public Builder httpResponseContentType(String httpResponseContentType) {
            this.httpResponseContentType = httpResponseContentType;
            return this;
        }

        public Builder httpResponseContentLanguage(String httpResponseContentLanguage) {
            this.httpResponseContentLanguage = httpResponseContentLanguage;
            return this;
        }

        public Builder httpResponseContentEncoding(String httpResponseContentEncoding) {
            this.httpResponseContentEncoding = httpResponseContentEncoding;
            return this;
        }

        public Builder httpResponseExpires(String httpResponseExpires) {
            this.httpResponseExpires = httpResponseExpires;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetObjectRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.objectName(o.getObjectName());
            this.versionId(o.getVersionId());
            this.ifMatch(o.getIfMatch());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.range(o.getRange());
            this.opcSseCustomerAlgorithm(o.getOpcSseCustomerAlgorithm());
            this.opcSseCustomerKey(o.getOpcSseCustomerKey());
            this.opcSseCustomerKeySha256(o.getOpcSseCustomerKeySha256());
            this.httpResponseContentDisposition(o.getHttpResponseContentDisposition());
            this.httpResponseCacheControl(o.getHttpResponseCacheControl());
            this.httpResponseContentType(o.getHttpResponseContentType());
            this.httpResponseContentLanguage(o.getHttpResponseContentLanguage());
            this.httpResponseContentEncoding(o.getHttpResponseContentEncoding());
            this.httpResponseExpires(o.getHttpResponseExpires());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetObjectRequest build() {
            GetObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetObjectRequest buildWithoutInvocationCallback() {
            GetObjectRequest request = new GetObjectRequest();
            request.namespaceName = this.namespaceName;
            request.bucketName = this.bucketName;
            request.objectName = this.objectName;
            request.versionId = this.versionId;
            request.ifMatch = this.ifMatch;
            request.ifNoneMatch = this.ifNoneMatch;
            request.opcClientRequestId = this.opcClientRequestId;
            request.range = this.range;
            request.opcSseCustomerAlgorithm = this.opcSseCustomerAlgorithm;
            request.opcSseCustomerKey = this.opcSseCustomerKey;
            request.opcSseCustomerKeySha256 = this.opcSseCustomerKeySha256;
            request.httpResponseContentDisposition = this.httpResponseContentDisposition;
            request.httpResponseCacheControl = this.httpResponseCacheControl;
            request.httpResponseContentType = this.httpResponseContentType;
            request.httpResponseContentLanguage = this.httpResponseContentLanguage;
            request.httpResponseContentEncoding = this.httpResponseContentEncoding;
            request.httpResponseExpires = this.httpResponseExpires;
            return request;
        }
    }
}

