/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.editor.api.gsf.HtmlErrorFilterContext;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.HtmlParsingResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.CloseTag;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.hints.HintsProvider;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.util.NbBundle;

public class ComponentUsagesChecker
extends HintsProvider {
    @Override
    public List<Hint> compute(RuleContext context) {
        HtmlErrorFilterContext errContext;
        HtmlErrorFilterContext htmlErrorFilterContext = errContext = context instanceof HtmlErrorFilterContext ? (HtmlErrorFilterContext)context : null;
        if (errContext != null && !errContext.isOnlyBadging()) {
            return Collections.emptyList();
        }
        return ComponentUsagesChecker.checkCCCalls((HtmlParserResult)context.parserResult);
    }

    private static List<Hint> checkCCCalls(HtmlParserResult result) {
        ArrayList<Hint> hints = new ArrayList<Hint>();
        Snapshot snapshot = result.getSnapshot();
        CharSequence documentContent = null;
        Map declaredLibraries = LibraryUtils.getDeclaredLibraries((HtmlParsingResult)result);
        for (Map.Entry declaredLib : declaredLibraries.entrySet()) {
            Node root = result.root((String)declaredLib.getKey());
            if (root == null) continue;
            if (documentContent == null) {
                documentContent = ComponentUsagesChecker.getSourceText(snapshot.getSource());
            }
            ComponentUsageVisitor componentVisitor = new ComponentUsageVisitor(snapshot, (Library)declaredLib.getValue(), documentContent);
            ElementUtils.visitChildren((Element)root, (ElementVisitor)componentVisitor, (ElementType)ElementType.OPEN_TAG);
            hints.addAll(componentVisitor.getHints());
        }
        return hints;
    }

    private static class ComponentUsageVisitor
    implements ElementVisitor {
        private final Snapshot snapshot;
        private final Library lib;
        private final CharSequence docText;
        private final List<Hint> hints = new ArrayList<Hint>();

        public ComponentUsageVisitor(Snapshot snapshot, Library lib, CharSequence docText) {
            this.snapshot = snapshot;
            this.lib = lib;
            this.docText = docText;
        }

        public List<Hint> getHints() {
            return this.hints;
        }

        public void visit(Element node) {
            OpenTag openTag = (OpenTag)node;
            String tagName = openTag.unqualifiedName().toString();
            LibraryComponent component = this.lib.getComponent(tagName);
            if (component == null) {
                this.hints.add(new Hint((Rule)HintsProvider.ERROR_RULE_BADGING, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNKNOWN_CC_COMPONENT", (Object)this.lib.getDisplayName(), (Object)tagName), this.snapshot.getSource().getFileObject(), JsfUtils.createOffsetRange(this.snapshot, this.docText, node.from(), node.to()), Collections.EMPTY_LIST, 50));
                CloseTag matchingCloseTag = openTag.matchingCloseTag();
                if (matchingCloseTag != null) {
                    this.hints.add(new Hint((Rule)HintsProvider.ERROR_RULE_BADGING, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNKNOWN_CC_COMPONENT", (Object)this.lib.getDisplayName(), (Object)tagName), this.snapshot.getSource().getFileObject(), JsfUtils.createOffsetRange(this.snapshot, this.docText, matchingCloseTag.from(), matchingCloseTag.to()), Collections.EMPTY_LIST, 50));
                }
            } else {
                Tag tag = component.getTag();
                if (tag != null) {
                    if (!tag.hasNonGenenericAttributes()) {
                        return;
                    }
                    Collection attrs = tag.getAttributes();
                    for (org.netbeans.modules.web.jsfapi.api.Attribute attr : attrs) {
                        if (!attr.isRequired() || attr.getDefaultValue() != null || openTag.getAttribute(attr.getName()) != null) continue;
                        Hint hint = new Hint((Rule)HintsProvider.ERROR_RULE_BADGING, NbBundle.getMessage(HintsProvider.class, (String)"MSG_MISSING_REQUIRED_ATTRIBUTE", (Object)attr.getName()), this.snapshot.getSource().getFileObject(), JsfUtils.createOffsetRange(this.snapshot, this.docText, node.from(), node.to()), Collections.EMPTY_LIST, 50);
                        this.hints.add(hint);
                    }
                    for (Attribute nodeAttr : openTag.attributes()) {
                        String nodeAttrName = nodeAttr.name().toString();
                        if (nodeAttr.namespacePrefix() != null || tag.getAttribute(nodeAttrName) != null || "xmlns".equals(nodeAttrName.toLowerCase(Locale.ENGLISH))) continue;
                        Hint hint = new Hint((Rule)HintsProvider.ERROR_RULE_BADGING, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNKNOWN_ATTRIBUTE", (Object)nodeAttr.name(), (Object)tag.getName()), this.snapshot.getSource().getFileObject(), JsfUtils.createOffsetRange(this.snapshot, this.docText, nodeAttr.from(), nodeAttr.to()), Collections.EMPTY_LIST, 50);
                        this.hints.add(hint);
                    }
                }
            }
        }
    }
}

