/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing;

import java.util.HashMap;
import java.util.Map;
import net.atmp.SpecialText;
import net.sourceforge.plantuml.activitydiagram3.ftile.CenteredText;
import net.sourceforge.plantuml.klimt.CopyForegroundColorToBackgroundColor;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.legacy.AtomText;
import net.sourceforge.plantuml.klimt.drawing.AbstractCommonUGraphic;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.MinMaxMutable;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import net.sourceforge.plantuml.klimt.shape.UComment;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UEmpty;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPixel;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;

public abstract class AbstractUGraphic<O>
extends AbstractCommonUGraphic {
    private O graphic;
    private MinMaxMutable minmax;
    private final Map<Class<? extends UShape>, UDriver<?, O>> drivers = new HashMap();
    private static final UDriver<?, ?> NOOP_DRIVER = new UDriver<UShape, Object>(){

        @Override
        public void draw(UShape shape, double x, double y, ColorMapper mapper, UParam param, Object object) {
        }
    };
    private static final double HACK_X_FOR_POLYGON = 10.0;

    protected AbstractUGraphic(StringBounder stringBounder) {
        super(stringBounder);
    }

    public void copy(HColor defaultBackground, ColorMapper colorMapper, O graphic) {
        this.basicCopy(defaultBackground, colorMapper);
        this.graphic = graphic;
        this.minmax = MinMaxMutable.getEmpty(true);
    }

    protected void copy(AbstractUGraphic<O> other) {
        this.basicCopy(other);
        this.graphic = other.graphic;
        this.minmax = other.minmax;
    }

    protected final O getGraphicObject() {
        return this.graphic;
    }

    protected boolean manageHiddenAutomatically() {
        return true;
    }

    protected final <SHAPE extends UShape> void registerDriver(Class<SHAPE> cl, UDriver<SHAPE, O> driver) {
        this.drivers.put(cl, driver);
    }

    protected final <SHAPE extends UShape> void ignoreShape(Class<SHAPE> cl) {
        this.registerDriver(cl, NOOP_DRIVER);
    }

    @Override
    public final <SHAPE extends UShape> void draw(SHAPE shape) {
        if (shape instanceof SpecialText) {
            ((SpecialText)shape).getTitle().drawU(this);
            return;
        }
        if (shape instanceof UEmpty) {
            return;
        }
        if (shape instanceof UComment) {
            this.drawComment((UComment)shape);
            return;
        }
        this.updateMinMax(shape);
        UDriver<?, O> driver = this.drivers.get(shape.getClass());
        if (driver == null) {
            throw new UnsupportedOperationException(shape.getClass().toString() + " " + this.getClass());
        }
        if (this.getParam().isHidden() && this.manageHiddenAutomatically()) {
            return;
        }
        this.beforeDraw();
        driver.draw(shape, this.getTranslateX(), this.getTranslateY(), this.getColorMapper(), this.getParam(), this.graphic);
        this.afterDraw();
    }

    private void updateMinMax(UShape shape) {
        if (this.matchesProperty("SPECIALTXT") && shape instanceof AtomText) {
            return;
        }
        double x = this.getTranslate().getDx();
        double y = this.getTranslate().getDy();
        if (shape instanceof UText) {
            this.drawText(x, y, (UText)shape);
        } else if (shape instanceof ULine) {
            this.drawULine(x, y, (ULine)shape);
        } else if (shape instanceof UEllipse) {
            this.drawEllipse(x, y, (UEllipse)shape);
        } else if (shape instanceof UPolygon) {
            this.drawUPolygon(x, y, (UPolygon)shape);
        } else if (shape instanceof UPath) {
            this.drawUPath(x, y, (UPath)shape);
        } else if (shape instanceof URectangle) {
            this.drawRectangle(x, y, (URectangle)shape);
        } else if (shape instanceof DotPath) {
            this.drawDotPath(x, y, (DotPath)shape);
        } else if (shape instanceof UImage) {
            this.drawImage(x, y, (UImage)shape);
        } else if (shape instanceof UImageSvg) {
            this.drawImageSvg(x, y, (UImageSvg)shape);
        } else if (!(shape instanceof UComment)) {
            if (shape instanceof UEmpty) {
                this.drawEmpty(x, y, (UEmpty)shape);
            } else if (shape instanceof TextBlock) {
                TextBlock tb = (TextBlock)shape;
                tb.drawU(this);
            } else if (!(shape instanceof UCenteredCharacter || shape instanceof CenteredText || shape instanceof SpecialText || shape instanceof CopyForegroundColorToBackgroundColor)) {
                if (shape instanceof UPixel) {
                    this.addPoint(x, y);
                } else {
                    throw new UnsupportedOperationException(shape.getClass().getName());
                }
            }
        }
    }

    private void addPoint(double x, double y) {
        if (this.getClip() == null || this.getClip().isInside(x, y)) {
            this.minmax.addPoint(x, y);
        }
    }

    private void drawEmpty(double x, double y, UEmpty shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth(), y + shape.getHeight());
    }

    private void drawUPath(double x, double y, UPath shape) {
        this.addPoint(x + shape.getMinX(), y + shape.getMinY());
        this.addPoint(x + shape.getMaxX(), y + shape.getMaxY());
    }

    private void drawUPolygon(double x, double y, UPolygon shape) {
        if (shape.getPoints().size() == 0) {
            return;
        }
        this.addPoint(x + shape.getMinX() - 10.0, y + shape.getMinY());
        this.addPoint(x + shape.getMaxX() + 10.0, y + shape.getMaxY());
    }

    private void drawULine(double x, double y, ULine shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getDX(), y + shape.getDY());
    }

    private void drawRectangle(double x, double y, URectangle shape) {
        this.addPoint(x - 1.0, y - 1.0);
        this.addPoint(x + shape.getWidth() - 1.0 + shape.getDeltaShadow() * 2.0, y + shape.getHeight() - 1.0 + shape.getDeltaShadow() * 2.0);
    }

    private void drawDotPath(double x, double y, DotPath shape) {
        MinMax shapeMinMax = shape.getMinMax();
        this.addPoint(x + shapeMinMax.getMinX(), y + shapeMinMax.getMinY());
        this.addPoint(x + shapeMinMax.getMaxX(), y + shapeMinMax.getMaxY());
    }

    private void drawImage(double x, double y, UImage shape) {
        this.addPoint(x, y);
        this.addPoint(x + (double)shape.getWidth() - 1.0, y + (double)shape.getHeight() - 1.0);
    }

    private void drawImageSvg(double x, double y, UImageSvg shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth() - 1.0, y + shape.getHeight() - 1.0);
    }

    private void drawEllipse(double x, double y, UEllipse shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth() - 1.0 + shape.getDeltaShadow() * 2.0, y + shape.getHeight() - 1.0 + shape.getDeltaShadow() * 2.0);
    }

    private void drawText(double x, double y, UText text) {
        XDimension2D dim = this.getStringBounder().calculateDimension(text.getFontConfiguration().getFont(), text.getText());
        this.addPoint(x, y -= dim.getHeight() - 1.5);
        this.addPoint(x, y + dim.getHeight());
        this.addPoint(x + dim.getWidth(), y);
        this.addPoint(x + dim.getWidth(), y + dim.getHeight());
    }

    protected void drawComment(UComment shape) {
    }

    protected void beforeDraw() {
    }

    protected void afterDraw() {
    }

    public final double getMaxX() {
        return this.minmax.getMaxX();
    }

    public final double getMaxY() {
        return this.minmax.getMaxY();
    }

    public final void resetMax() {
        this.minmax.reset();
    }
}

