\name{GrayscaleConnectedOpeningImageFilter}
\alias{GrayscaleConnectedOpeningImageFilter}
\title{GrayscaleConnectedOpeningImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Enhance pixels associated with a bright object (identified by a seed
pixel) where the bright object is surrounded by a darker object.
GrayscaleConnectedOpeningImageFilter}
\details{
GrayscaleConnectedOpeningImageFilter is useful for enhancing bright objects that are surrounded by dark
borders. This filter makes it easier to threshold the image and
extract just the object of interest.
Geodesic morphology and the connected opening algorithm is described
in Chapter 6 of Pierre Soille's book "Morphological Image Analysis:
Principles and Applications", Second Edition, Springer, 2003.
See:
GrayscaleGeodesicDilateImageFilter
MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter
GrayscaleConnectedOpening for the procedural interface
itk::GrayscaleConnectedOpeningImageFilter for the Doxygen on the original ITK class.
GrayscaleConnectedOpeningImageFilter}
%C++ includes: sitkGrayscaleConnectedOpeningImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetSeed() const:}{
Set/Get the seed pixel for the segmentation
}
\item{ GrayscaleConnectedOpeningImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{Self SetSeed(std::vector< unsigned int > Seed):}{
Set/Get the seed pixel for the segmentation
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GrayscaleConnectedOpeningImageFilter():}{
Destructor
}
}
}
