/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.extraction.ExtractingDocumentLoader;
import org.apache.solr.handler.extraction.ExtractionBackend;
import org.apache.solr.handler.extraction.LocalTikaExtractionBackend;
import org.apache.solr.handler.extraction.ParseContextConfig;
import org.apache.solr.handler.extraction.SolrContentHandlerFactory;
import org.apache.solr.handler.extraction.TikaServerExtractionBackend;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractingRequestHandler
extends ContentStreamHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PARSE_CONTEXT_CONFIG = "parseContext.config";
    public static final String CONFIG_LOCATION = "tika.config";
    protected String tikaConfigLoc;
    protected ParseContextConfig parseContextConfig;
    protected SolrContentHandlerFactory factory;
    protected String defaultBackendName;
    protected LocalTikaExtractionBackend localBackend;
    protected TikaServerExtractionBackend tikaServerBackend;

    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    public void inform(SolrCore core) {
        try {
            String backendName;
            this.tikaConfigLoc = (String)this.initArgs.get(CONFIG_LOCATION);
            String parseContextConfigLoc = (String)this.initArgs.get(PARSE_CONTEXT_CONFIG);
            this.parseContextConfig = parseContextConfigLoc == null ? new ParseContextConfig() : new ParseContextConfig(core.getResourceLoader(), parseContextConfigLoc);
            this.localBackend = new LocalTikaExtractionBackend(core, this.tikaConfigLoc, this.parseContextConfig);
            String tikaServerUrl = (String)this.initArgs.get("tikaserver.url");
            if (tikaServerUrl != null && !tikaServerUrl.trim().isEmpty()) {
                int timeoutSecs = 0;
                Object initTimeout = this.initArgs.get("tikaserver.timeoutSeconds");
                if (initTimeout != null) {
                    try {
                        timeoutSecs = Integer.parseInt(String.valueOf(initTimeout));
                    }
                    catch (NumberFormatException nfe) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid value for 'tikaserver.timeoutSeconds': " + String.valueOf(initTimeout), (Throwable)nfe);
                    }
                }
                Object maxCharsObj = this.initArgs.get("tikaserver.maxChars");
                long maxCharsLimit = 0x6400000L;
                if (maxCharsObj != null) {
                    try {
                        maxCharsLimit = Long.parseLong(String.valueOf(maxCharsObj));
                    }
                    catch (NumberFormatException nfe) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid value for 'tikaserver.maxChars': " + String.valueOf(maxCharsObj));
                    }
                }
                this.tikaServerBackend = new TikaServerExtractionBackend(tikaServerUrl, timeoutSecs, this.initArgs, maxCharsLimit);
            }
            switch (this.defaultBackendName = (backendName = (String)this.initArgs.get("extraction.backend")) == null || backendName.trim().isEmpty() ? "local" : backendName) {
                case "local": {
                    break;
                }
                case "tikaserver": {
                    if (this.tikaServerBackend == null) {
                        throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Tika Server backend requested but no URL configured");
                    }
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid extraction backend: '" + this.defaultBackendName + "'. Must be one of: 'local', 'tikaserver'");
                }
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to initialize ExtractingRequestHandler", (Throwable)e);
        }
        this.factory = new SolrContentHandlerFactory();
    }

    protected ContentStreamLoader newLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
        ExtractionBackend extractionBackend;
        String nameToUse;
        String backendParam = req.getParams().get("extraction.backend");
        String string = nameToUse = backendParam != null && !backendParam.trim().isEmpty() ? backendParam : this.defaultBackendName;
        if ("local".equals(nameToUse)) {
            extractionBackend = this.localBackend;
        } else if ("tikaserver".equals(nameToUse)) {
            if (this.tikaServerBackend == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Tika Server backend requested but 'tikaserver.url' is not configured");
            }
            extractionBackend = this.tikaServerBackend;
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown extraction backend: " + nameToUse);
        }
        return new ExtractingDocumentLoader(req, processor, this.factory, extractionBackend);
    }

    public String getDescription() {
        return "Add/Update Rich document";
    }

    public void close() throws IOException {
        try {
            if (this.tikaServerBackend != null) {
                this.tikaServerBackend.close();
            }
        }
        finally {
            try {
                if (this.localBackend != null) {
                    this.localBackend.close();
                }
            }
            finally {
                super.close();
            }
        }
    }
}

