/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import java.util.Objects;
import java.util.Optional;

public final class FeatureChild {
    private final Rule rule;
    private final Background background;
    private final Scenario scenario;

    public static FeatureChild of(Rule rule) {
        return new FeatureChild(Objects.requireNonNull(rule, "FeatureChild.rule cannot be null"), null, null);
    }

    public static FeatureChild of(Background background) {
        return new FeatureChild(null, Objects.requireNonNull(background, "FeatureChild.background cannot be null"), null);
    }

    public static FeatureChild of(Scenario scenario) {
        return new FeatureChild(null, null, Objects.requireNonNull(scenario, "FeatureChild.scenario cannot be null"));
    }

    public FeatureChild(Rule rule, Background background, Scenario scenario) {
        this.rule = rule;
        this.background = background;
        this.scenario = scenario;
    }

    public Optional<Rule> getRule() {
        return Optional.ofNullable(this.rule);
    }

    public Optional<Background> getBackground() {
        return Optional.ofNullable(this.background);
    }

    public Optional<Scenario> getScenario() {
        return Optional.ofNullable(this.scenario);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureChild that = (FeatureChild)o;
        return Objects.equals(this.rule, that.rule) && Objects.equals(this.background, that.background) && Objects.equals(this.scenario, that.scenario);
    }

    public int hashCode() {
        return Objects.hash(this.rule, this.background, this.scenario);
    }

    public String toString() {
        return "FeatureChild{rule=" + this.rule + ", background=" + this.background + ", scenario=" + this.scenario + '}';
    }
}

