# LinearAlgebraForCAP, single 5
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("linearalgebraforcap05.tst");

# doc/_Chapter_Examples_and_Tests.xml:96-224
gap> KernelObjectFunctorial( u, IdentityMorphism( Source( u ) ), u ) = IdentityMorphism( MatrixCategoryObject( vec, 3 ) );
true
gap> IsZeroForMorphisms( CokernelObjectFunctorial( u, IdentityMorphism( Range( u ) ), u ) );
true
gap> DirectProductFunctorial( [ u, u ] ) = DirectSumFunctorial( [ u, u ] );
true
gap> CoproductFunctorial( [ u, u ] ) = DirectSumFunctorial( [ u, u ] );
true
gap> IsCongruentForMorphisms(
>     FiberProductFunctorial( [ u, u ], [ IdentityMorphism( Source( u ) ), IdentityMorphism( Source( u ) ) ], [ u, u ] ),
>     IdentityMorphism( FiberProduct( [ u, u ] ) )
> );
true
gap> IsCongruentForMorphisms(
>     PushoutFunctorial( [ u, u ], [ IdentityMorphism( Range( u ) ), IdentityMorphism( Range( u ) ) ], [ u, u ] ),
>     IdentityMorphism( Pushout( [ u, u ] ) )
> );
true
gap> IsCongruentForMorphisms( ((1/2) / Q) * alpha, alpha * ((1/2) / Q) );
true
gap> Dimension( HomomorphismStructureOnObjects( a, b ) ) = Dimension( a ) * Dimension( b );
true
gap> IsCongruentForMorphisms(
>     PreCompose( [ u, DualOnMorphisms( i1 ), DualOnMorphisms( alpha ) ] ),
>     InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism( Source( u ), Source( alpha ),
>          PreCompose(
>              InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure( DualOnMorphisms( i1 ) ),
>              HomomorphismStructureOnMorphisms( u, DualOnMorphisms( alpha ) )
>          )
>     )
> );
true
gap> op := Opposite( vec );;
gap> alpha_op := Opposite( op, alpha );
<A morphism in Opposite( Category of matrices over Q )>
gap> basis := BasisOfExternalHom( Source( alpha_op ), Range( alpha_op ) );;
gap> coeffs := CoefficientsOfMorphism( alpha_op );;
gap> Display( coeffs );
[ 1, 0, 0, 0, 0, 1, 0, -1, -1, 0, 2, 1 ]
gap> IsEqualForMorphisms( alpha_op, LinearCombinationOfMorphisms( Source( alpha_op ), coeffs, basis, Range( alpha_op ) ) );
true
gap> vec := CapCategory( alpha );;
gap> t := TensorUnit( vec );;
gap> z := ZeroObject( vec );;
gap> IsCongruentForMorphisms(
>     ZeroObjectFunctorial( vec ),
>     InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism( z, z, ZeroMorphism( t, z ) )
> );
true
gap> IsCongruentForMorphisms(
>     ZeroObjectFunctorial( vec ),
>     InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism(
>         z, z,
>         InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure( ZeroObjectFunctorial( vec ) )
>     )
> );
true
gap> right_side := PreCompose( [ i1, DualOnMorphisms( u ), u ] );;
gap> x := SolveLinearSystemInAbCategory( [ [ i1 ] ], [ [ u ] ], [ right_side ] )[1];;
gap> IsCongruentForMorphisms( PreCompose( [ i1, x, u ] ), right_side );
true
gap> a_otimes_b := TensorProductOnObjects( a, b );
<A vector space object over Q of dimension 12>
gap> hom_ab := InternalHomOnObjects( a, b );
<A vector space object over Q of dimension 12>
gap> cohom_ab := InternalCoHomOnObjects( a, b );
<A vector space object over Q of dimension 12>
gap> hom_ab = cohom_ab;
true
gap> unit_ab := VectorSpaceMorphism(
>           a_otimes_b,
>           HomalgIdentityMatrix( Dimension( a_otimes_b ), Q ),
>           a_otimes_b
>           );
<A morphism in Category of matrices over Q>
gap> unit_hom_ab := VectorSpaceMorphism(
>               hom_ab,
>               HomalgIdentityMatrix( Dimension( hom_ab ), Q ),
>               hom_ab
>             );
<A morphism in Category of matrices over Q>
gap> unit_cohom_ab := VectorSpaceMorphism(
>                 cohom_ab,
>                 HomalgIdentityMatrix( Dimension( cohom_ab ), Q ),
>                 cohom_ab
>               );
<A morphism in Category of matrices over Q>
gap> ev_ab := ClosedMonoidalLeftEvaluationMorphism( a, b );
<A morphism in Category of matrices over Q>
gap> coev_ab := ClosedMonoidalLeftCoevaluationMorphism( a, b );
<A morphism in Category of matrices over Q>
gap> coev_ba := ClosedMonoidalLeftCoevaluationMorphism( b, a );
<A morphism in Category of matrices over Q>
gap> cocl_ev_ab := CoclosedMonoidalLeftEvaluationMorphism( a, b );
<A morphism in Category of matrices over Q>
gap> cocl_ev_ba := CoclosedMonoidalLeftEvaluationMorphism( b, a );
<A morphism in Category of matrices over Q>
gap> cocl_coev_ab := CoclosedMonoidalLeftCoevaluationMorphism( a, b );
<A morphism in Category of matrices over Q>
gap> cocl_coev_ba := CoclosedMonoidalLeftCoevaluationMorphism( b, a );
<A morphism in Category of matrices over Q>
gap> UnderlyingMatrix( ev_ab ) = TransposedMatrix( UnderlyingMatrix( cocl_ev_ab ) );
true
gap> UnderlyingMatrix( coev_ab ) = TransposedMatrix( UnderlyingMatrix( cocl_coev_ab ) );
true
gap> UnderlyingMatrix( coev_ba ) = TransposedMatrix( UnderlyingMatrix( cocl_coev_ba ) );
true
gap> tensor_hom_adj_1_hom_ab := InternalHomToTensorProductLeftAdjunctMorphism( a, b, unit_hom_ab );
<A morphism in Category of matrices over Q>
gap> cohom_tensor_adj_1_cohom_ab := InternalCoHomToTensorProductLeftAdjunctMorphism( a, b, unit_cohom_ab );
<A morphism in Category of matrices over Q>
gap> tensor_hom_adj_1_ab := TensorProductToInternalHomLeftAdjunctMorphism( a, b, unit_ab );
<A morphism in Category of matrices over Q>
gap> cohom_tensor_adj_1_ab := TensorProductToInternalCoHomLeftAdjunctMorphism( a, b, unit_ab );
<A morphism in Category of matrices over Q>
gap> ev_ab = tensor_hom_adj_1_hom_ab;
true
gap> cocl_ev_ba = cohom_tensor_adj_1_cohom_ab;
true
gap> coev_ba = tensor_hom_adj_1_ab;
true
gap> cocl_coev_ba = cohom_tensor_adj_1_ab;
true
gap> c := MatrixCategoryObject( vec, 2 );
<A vector space object over Q of dimension 2>
gap> d := MatrixCategoryObject( vec, 1 );
<A vector space object over Q of dimension 1>

#
gap> STOP_TEST("linearalgebraforcap05.tst", 1);
