/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.configuration.OracleConfigurationParsableProvider;
import oracle.jdbc.util.OracleConfigurationCache;

public class OracleConfigurationFileProvider
extends OracleConfigurationParsableProvider {
    private static final OracleConfigurationCache CACHE = OracleConfigurationCache.create(100);

    @Override
    public OracleConfigurationCache getCache() {
        return CACHE;
    }

    @Override
    public InputStream getInputStream(String fileName) throws SQLException {
        try {
            if (fileName.startsWith("/")) {
                return new FileInputStream(fileName);
            }
            InputStream configFile = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (configFile != null) {
                return configFile;
            }
            if (this.options.containsKey("TNS_ADMIN")) {
                return new FileInputStream((String)this.options.get("TNS_ADMIN") + File.separator + fileName);
            }
            if (System.getProperty("TNS_ADMIN") != null) {
                return new FileInputStream(System.getProperty("TNS_ADMIN") + File.separator + fileName);
            }
            if (System.getenv("TNS_ADMIN") != null) {
                return new FileInputStream(System.getenv("TNS_ADMIN") + File.separator + fileName);
            }
            throw new SQLException("Json configuration file not found.");
        }
        catch (FileNotFoundException ex) {
            throw new SQLException("Error retrieving Json configuration", ex);
        }
    }

    @Override
    public String getType() {
        return "file";
    }
}

