/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.action.AbstractHandlerDelegatingProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.binding.impl.PopulateSignatureSigningParametersHandler;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;

public class PopulateSignatureSigningParameters
extends AbstractHandlerDelegatingProfileAction<PopulateSignatureSigningParametersHandler> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateSignatureSigningParameters.class);
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup(SecurityParametersContext.class, true).compose(new OutboundMessageContextLookup());
    @Nullable
    private Function<ProfileRequestContext, SecurityParametersContext> existingParametersContextLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<SignatureSigningConfiguration>> configurationLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy = new ChildContextLookup(SAMLMetadataContext.class).compose(new ChildContextLookup(SAMLPeerEntityContext.class).compose(new OutboundMessageContextLookup()));
    @NonnullAfterInit
    private SignatureSigningParametersResolver resolver;
    private boolean noResultIsError;

    public PopulateSignatureSigningParameters() {
        super(PopulateSignatureSigningParametersHandler.class, (ContextDataLookupFunction<ProfileRequestContext, MessageContext>)new OutboundMessageContextLookup());
        this.setErrorEvent("InvalidSecurityConfiguration");
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.checkSetterPreconditions();
        this.securityParametersContextLookupStrategy = Constraint.isNotNull(strategy, "SecurityParametersContext lookup strategy cannot be null");
    }

    public void setExistingParametersContextLookupStrategy(@Nullable Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.checkSetterPreconditions();
        this.existingParametersContextLookupStrategy = strategy;
    }

    public void setMetadataContextLookupStrategy(@Nullable Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.metadataContextLookupStrategy = strategy;
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<SignatureSigningConfiguration>> strategy) {
        this.checkSetterPreconditions();
        this.configurationLookupStrategy = Constraint.isNotNull(strategy, "SignatureSigningConfiguration lookup strategy cannot be null");
    }

    public void setSignatureSigningParametersResolver(@Nonnull SignatureSigningParametersResolver newResolver) {
        this.checkSetterPreconditions();
        this.resolver = Constraint.isNotNull(newResolver, "SignatureSigningParametersResolver cannot be null");
    }

    public void setNoResultIsError(boolean flag) {
        this.checkSetterPreconditions();
        this.noResultIsError = flag;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("SignatureSigningParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<ProfileRequestContext, List<SignatureSigningConfiguration>>(){

                @Override
                public List<SignatureSigningConfiguration> apply(ProfileRequestContext input) {
                    return CollectionSupport.singletonList(SecurityConfigurationSupport.ensureGlobalSignatureSigningConfiguration());
                }
            };
        }
        PopulateSignatureSigningParametersHandler delegate = (PopulateSignatureSigningParametersHandler)this.getDelegate();
        delegate.setNoResultIsError(this.noResultIsError);
        delegate.setSignatureSigningParametersResolver(this.resolver);
        delegate.setConfigurationLookupStrategy(this.adaptRequired(this.configurationLookupStrategy));
        delegate.setSecurityParametersContextLookupStrategy(this.adaptRequired(this.securityParametersContextLookupStrategy));
        delegate.setExistingParametersContextLookupStrategy(this.adapt(this.existingParametersContextLookupStrategy));
        delegate.setMetadataContextLookupStrategy(this.adapt(this.metadataContextLookupStrategy));
        delegate.initialize();
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (super.doPreExecute(profileRequestContext)) {
            this.log.debug("{} Signing enabled", (Object)this.getLogPrefix());
            return true;
        }
        this.log.debug("{} Signing not enabled", (Object)this.getLogPrefix());
        return false;
    }
}

