/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.backend.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNode;
import com.intellij.platform.vcs.impl.backend.shelf.ChangesBrowserNodeConverterKt;
import com.intellij.platform.vcs.impl.backend.shelf.NodeToEntityConverter;
import com.intellij.platform.vcs.impl.backend.shelf.ShelfTreeHolder;
import com.intellij.platform.vcs.impl.shared.rhizome.FilePathNodeEntity;
import com.intellij.platform.vcs.impl.shared.rhizome.NodeEntity;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.EntityType;
import fleet.kernel.SharedChangeScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/vcs/impl/backend/shelf/FilePathNodeToEntityConverter;", "Lcom/intellij/platform/vcs/impl/backend/shelf/NodeToEntityConverter;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserFilePathNode;", "<init>", "()V", "convert", "Lcom/intellij/platform/vcs/impl/shared/rhizome/FilePathNodeEntity;", "Lfleet/kernel/SharedChangeScope;", "node", "orderInParent", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl.backend"})
public final class FilePathNodeToEntityConverter
extends NodeToEntityConverter<ChangesBrowserFilePathNode> {
    public FilePathNodeToEntityConverter() {
        super(Reflection.getOrCreateKotlinClass(ChangesBrowserFilePathNode.class));
    }

    @NotNull
    public FilePathNodeEntity convert(@NotNull SharedChangeScope $this$convert, @NotNull ChangesBrowserFilePathNode node, int orderInParent, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (FilePathNodeEntity)$this$convert.new((EntityType)FilePathNodeEntity.Companion, arg_0 -> FilePathNodeToEntityConverter.convert$lambda$0(node, project, orderInParent, arg_0));
    }

    private static final void convert$lambda$0(ChangesBrowserFilePathNode $node, Project $project, int $orderInParent, EntityBuilder.Target it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FilePath filePath = (FilePath)$node.getUserObject();
        if (filePath == null) {
            return;
        }
        FilePath filePath2 = filePath;
        boolean isFlatten = !ShelfTreeHolder.Companion.getInstance($project).isDirectoryGroupingEnabled();
        String string = isFlatten ? filePath2.getName() : $node.getRelativeFilePath($project, filePath2);
        Intrinsics.checkNotNull((Object)string);
        String name = string;
        it.set(FilePathNodeEntity.Companion.getOriginText(), (Object)$node.getOriginText());
        if (isFlatten) {
            FilePath filePath3 = filePath2.getParentPath();
            it.set(FilePathNodeEntity.Companion.getParentPath(), (Object)(filePath3 != null ? ChangesBrowserNodeConverterKt.access$toPresentablePath(filePath3, $project) : null));
        }
        FileStatus fileStatus = $node.getStatus();
        it.set(FilePathNodeEntity.Companion.getFileStatus(), (Object)(fileStatus != null ? fileStatus.getId() : null));
        it.set(FilePathNodeEntity.Companion.getIsDirectory(), (Object)filePath2.isDirectory());
        it.set(FilePathNodeEntity.Companion.getName(), (Object)name);
        it.set(NodeEntity.Companion.getOrder(), (Object)$orderInParent);
    }
}

