/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.exceptions.AndrolibException;
import brut.common.BrutException;
import brut.util.AaptManager;
import brut.util.OS;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;

public class AaptInvoker {
    private static final Logger LOGGER = Logger.getLogger(AaptInvoker.class.getName());
    private final ApkInfo mApkInfo;
    private final Config mConfig;

    public AaptInvoker(ApkInfo apkInfo, Config config) {
        this.mApkInfo = apkInfo;
        this.mConfig = config;
    }

    public void invoke(File apkFile, File manifest, File resDir, File rawDir, File assetDir, File[] include) throws AndrolibException {
        boolean customAapt;
        String aaptPath;
        if (this.mConfig.getAaptBinary() != null) {
            aaptPath = this.mConfig.getAaptBinary().getPath();
            customAapt = true;
        } else {
            try {
                aaptPath = AaptManager.getAaptBinary(this.mConfig.getAaptVersion()).getPath();
                customAapt = false;
            }
            catch (BrutException ex) {
                aaptPath = AaptManager.getAaptName(this.mConfig.getAaptVersion());
                customAapt = true;
                LOGGER.warning(aaptPath + ": " + ex.getMessage() + " (defaulting to $PATH binary)");
            }
        }
        switch (this.mConfig.getAaptVersion()) {
            case 2: {
                this.invokeAapt2(apkFile, manifest, resDir, rawDir, assetDir, include, aaptPath, customAapt);
                break;
            }
            default: {
                this.invokeAapt1(apkFile, manifest, resDir, rawDir, assetDir, include, aaptPath, customAapt);
            }
        }
    }

    private void invokeAapt2(File apkFile, File manifest, File resDir, File rawDir, File assetDir, File[] include, String aaptPath, boolean customAapt) throws AndrolibException {
        ArrayList<String> cmd;
        File resourcesZip = null;
        if (resDir != null && !(resourcesZip = Paths.get(resDir.getParent(), "build", "resources.zip").toFile()).exists()) {
            cmd = new ArrayList();
            cmd.add(aaptPath);
            cmd.add("compile");
            cmd.add("--dir");
            cmd.add(resDir.getAbsolutePath());
            cmd.add("--legacy");
            cmd.add("-o");
            cmd.add(resourcesZip.getAbsolutePath());
            if (this.mConfig.isVerbose()) {
                cmd.add("-v");
            }
            if (this.mConfig.isNoCrunch()) {
                cmd.add("--no-crunch");
            }
            try {
                OS.exec(cmd.toArray(new String[0]));
                LOGGER.fine("aapt2 compile command ran: ");
                LOGGER.fine(((Object)cmd).toString());
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
        }
        if (manifest == null) {
            return;
        }
        cmd = new ArrayList<String>();
        cmd.add(aaptPath);
        cmd.add("link");
        cmd.add("-o");
        cmd.add(apkFile.getAbsolutePath());
        if (this.mApkInfo.packageInfo.forcedPackageId != null && !this.mApkInfo.packageInfo.forcedPackageId.equals("1") && !this.mApkInfo.sharedLibrary) {
            cmd.add("--allow-reserved-package-id");
            cmd.add("--package-id");
            cmd.add(this.mApkInfo.packageInfo.forcedPackageId);
        }
        if (this.mApkInfo.sharedLibrary) {
            cmd.add("--shared-lib");
        }
        if (this.mApkInfo.getMinSdkVersion() != null) {
            cmd.add("--min-sdk-version");
            cmd.add(this.mApkInfo.getMinSdkVersion());
        }
        if (this.mApkInfo.getTargetSdkVersion() != null) {
            cmd.add("--target-sdk-version");
            cmd.add(this.mApkInfo.checkTargetSdkVersionBounds());
        }
        if (this.mApkInfo.packageInfo.renameManifestPackage != null) {
            cmd.add("--rename-manifest-package");
            cmd.add(this.mApkInfo.packageInfo.renameManifestPackage);
            cmd.add("--rename-instrumentation-target-package");
            cmd.add(this.mApkInfo.packageInfo.renameManifestPackage);
        }
        if (this.mApkInfo.versionInfo.versionCode != null) {
            cmd.add("--version-code");
            cmd.add(this.mApkInfo.versionInfo.versionCode);
        }
        if (this.mApkInfo.versionInfo.versionName != null) {
            cmd.add("--version-name");
            cmd.add(this.mApkInfo.versionInfo.versionName);
        }
        cmd.add("--no-auto-version");
        cmd.add("--no-version-vectors");
        cmd.add("--no-version-transitions");
        cmd.add("--no-resource-deduping");
        cmd.add("--no-compile-sdk-metadata");
        cmd.add("--warn-manifest-validation");
        if (this.mApkInfo.sparseResources) {
            cmd.add("--enable-sparse-encoding");
        }
        if (this.mApkInfo.compactEntries) {
            cmd.add("--enable-compact-entries");
        }
        if (this.mApkInfo.isFrameworkApk) {
            cmd.add("-x");
        }
        if (!this.mApkInfo.featureFlags.isEmpty()) {
            File[] featureFlags = new ArrayList();
            for (Map.Entry<String, Boolean> entry : this.mApkInfo.featureFlags.entrySet()) {
                featureFlags.add(entry.getKey() + "=" + entry.getValue());
            }
            cmd.add("--feature-flags");
            cmd.add(String.join((CharSequence)",", (Iterable<? extends CharSequence>)featureFlags));
        }
        if (include != null) {
            for (File file : include) {
                cmd.add("-I");
                cmd.add(file.getPath());
            }
        }
        cmd.add("--manifest");
        cmd.add(manifest.getAbsolutePath());
        if (assetDir != null) {
            cmd.add("-A");
            cmd.add(assetDir.getAbsolutePath());
        }
        if (rawDir != null) {
            cmd.add("-R");
            cmd.add(rawDir.getAbsolutePath());
        }
        if (this.mConfig.isVerbose()) {
            cmd.add("-v");
        }
        if (resourcesZip != null) {
            cmd.add(resourcesZip.getAbsolutePath());
        }
        try {
            OS.exec(cmd.toArray(new String[0]));
            LOGGER.fine("aapt2 link command ran: ");
            LOGGER.fine(((Object)cmd).toString());
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void invokeAapt1(File apkFile, File manifest, File resDir, File rawDir, File assetDir, File[] include, String aaptPath, boolean customAapt) throws AndrolibException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(aaptPath);
        cmd.add("p");
        if (this.mConfig.isVerbose()) {
            cmd.add("-v");
        }
        if (this.mConfig.isUpdateFiles()) {
            cmd.add("-u");
        }
        if (this.mConfig.isDebugMode()) {
            cmd.add("--debug-mode");
        }
        if (this.mConfig.isNoCrunch()) {
            cmd.add("--no-crunch");
        }
        if (this.mApkInfo.packageInfo.forcedPackageId != null && !this.mApkInfo.sharedLibrary && !customAapt) {
            cmd.add("--forced-package-id");
            cmd.add(this.mApkInfo.packageInfo.forcedPackageId);
        }
        if (this.mApkInfo.sharedLibrary) {
            cmd.add("--shared-lib");
        }
        if (this.mApkInfo.getMinSdkVersion() != null) {
            cmd.add("--min-sdk-version");
            cmd.add(this.mApkInfo.getMinSdkVersion());
        }
        if (this.mApkInfo.getTargetSdkVersion() != null) {
            cmd.add("--target-sdk-version");
            cmd.add(this.mApkInfo.checkTargetSdkVersionBounds());
        }
        if (this.mApkInfo.getMaxSdkVersion() != null) {
            cmd.add("--max-sdk-version");
            cmd.add(this.mApkInfo.getMaxSdkVersion());
            cmd.add("--max-res-version");
            cmd.add(this.mApkInfo.getMaxSdkVersion());
        }
        if (this.mApkInfo.packageInfo.renameManifestPackage != null) {
            cmd.add("--rename-manifest-package");
            cmd.add(this.mApkInfo.packageInfo.renameManifestPackage);
        }
        if (this.mApkInfo.versionInfo.versionCode != null) {
            cmd.add("--version-code");
            cmd.add(this.mApkInfo.versionInfo.versionCode);
        }
        if (this.mApkInfo.versionInfo.versionName != null) {
            cmd.add("--version-name");
            cmd.add(this.mApkInfo.versionInfo.versionName);
        }
        cmd.add("--no-version-vectors");
        cmd.add("-F");
        cmd.add(apkFile.getAbsolutePath());
        if (this.mApkInfo.isFrameworkApk) {
            cmd.add("-x");
        }
        if (include != null) {
            for (File file : include) {
                cmd.add("-I");
                cmd.add(file.getPath());
            }
        }
        if (resDir != null) {
            cmd.add("-S");
            cmd.add(resDir.getAbsolutePath());
        }
        if (manifest != null) {
            cmd.add("-M");
            cmd.add(manifest.getAbsolutePath());
        }
        if (assetDir != null) {
            cmd.add("-A");
            cmd.add(assetDir.getAbsolutePath());
        }
        if (rawDir != null) {
            cmd.add(rawDir.getAbsolutePath());
        }
        try {
            OS.exec(cmd.toArray(new String[0]));
            LOGGER.fine("command ran: ");
            LOGGER.fine(((Object)cmd).toString());
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }
}

