/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class BackgroundWorker {
    private final ExecutorService mExecutor;
    private final List<Future<?>> mWorkerFutures;
    private volatile boolean mSubmitAllowed;

    public BackgroundWorker(int threads) {
        this.mExecutor = Executors.newFixedThreadPool(threads);
        this.mWorkerFutures = new ArrayList();
        this.mSubmitAllowed = true;
    }

    public void waitForFinish() {
        this.checkState();
        this.mSubmitAllowed = false;
        for (Future<?> future : this.mWorkerFutures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.mWorkerFutures.clear();
        this.mSubmitAllowed = true;
    }

    public void clearFutures() {
        this.mWorkerFutures.clear();
    }

    private void checkState() {
        if (!this.mSubmitAllowed) {
            throw new IllegalStateException("BackgroundWorker is not ready");
        }
    }

    public void shutdownNow() {
        this.mSubmitAllowed = false;
        this.mExecutor.shutdownNow();
    }

    public ExecutorService getExecutor() {
        return this.mExecutor;
    }

    public void submit(Runnable task) {
        this.checkState();
        this.mWorkerFutures.add(this.mExecutor.submit(task));
    }

    public <T> Future<T> submit(Callable<T> task) {
        this.checkState();
        Future<T> future = this.mExecutor.submit(task);
        this.mWorkerFutures.add(future);
        return future;
    }
}

