/**
* ClockSkewManager.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
*/
/**
* Class to manage clock skew correction.
*/
export default class ClockSkewManager {
    constructor();
    /**
     * Determine if the request can be sent.
     * @returns True if requests can be sent, false otherwise.
     */
    allowRequestSending(): boolean;
    /**
     * Tells the ClockSkewManager that it should assume that the first request has now been sent,
     * If this method had not yet been called AND the clock Skew had not been set this will set
     * allowRequestSending to false until setClockSet() is called.
     */
    firstRequestSent(): void;
    /**
     * Determine if clock skew headers should be added to the request.
     * @returns True if clock skew headers should be added, false otherwise.
     */
    shouldAddClockSkewHeaders(): boolean;
    /**
     * Gets the clock skew header value.
     * @returns The clock skew header value.
     */
    getClockSkewHeaderValue(): string;
    /**
     * Sets the clock skew header value. Once clock skew is set this method
     * is no-op.
     * @param timeDeltaInMillis - Time delta to be saved as the clock skew header value.
     */
    setClockSkew(timeDeltaInMillis?: string): void;
}
