/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDiagnostic
implements Diagnostic,
DiagnosticChain {
    protected int severity;
    protected String message;
    protected List<Diagnostic> children;
    protected List<?> data;
    protected String source;
    protected int code;

    public BasicDiagnostic() {
    }

    public BasicDiagnostic(String source, int code, String message, Object[] data) {
        this.source = source;
        this.code = code;
        this.message = message;
        this.data = this.dataAsList(data);
    }

    public BasicDiagnostic(int severity, String source, int code, String message, Object[] data) {
        this(source, code, message, data);
        this.severity = severity;
    }

    public BasicDiagnostic(String source, int code, List<? extends Diagnostic> children, String message, Object[] data) {
        this(source, code, message, data);
        if (children != null) {
            for (Diagnostic diagnostic : children) {
                this.add(diagnostic);
            }
        }
    }

    protected List<?> dataAsList(Object[] data) {
        if (data == null) {
            return Collections.EMPTY_LIST;
        }
        Object[] copy = new Object[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return new BasicEList.UnmodifiableEList(copy.length, copy);
    }

    protected void setSeverity(int severity) {
        this.severity = severity;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<?> getData() {
        return this.data;
    }

    @Override
    public List<Diagnostic> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children);
    }

    protected void setSource(String source) {
        this.source = source;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    protected void setCode(int code) {
        this.code = code;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public void add(Diagnostic diagnostic) {
        if (this.children == null) {
            this.children = new BasicEList<Diagnostic>();
        }
        this.children.add(diagnostic);
        int childSeverity = diagnostic.getSeverity();
        if (childSeverity > this.getSeverity()) {
            this.severity = childSeverity;
        }
    }

    @Override
    public void addAll(Diagnostic diagnostic) {
        for (Diagnostic child : diagnostic.getChildren()) {
            this.add(child);
        }
    }

    @Override
    public void merge(Diagnostic diagnostic) {
        if (diagnostic.getChildren().isEmpty()) {
            this.add(diagnostic);
        } else {
            this.addAll(diagnostic);
        }
    }

    public int recomputeSeverity() {
        if (this.children != null) {
            this.severity = 0;
            for (Diagnostic child : this.children) {
                int childSeverity;
                int n = childSeverity = child instanceof BasicDiagnostic ? ((BasicDiagnostic)child).recomputeSeverity() : child.getSeverity();
                if (childSeverity <= this.severity) continue;
                this.severity = childSeverity;
            }
        }
        return this.severity;
    }

    @Override
    public Throwable getException() {
        List<?> data = this.getData();
        if (data != null) {
            for (Object datum : data) {
                if (!(datum instanceof Throwable)) continue;
                return (Throwable)datum;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Diagnostic ");
        switch (this.severity) {
            case 0: {
                result.append("OK");
                break;
            }
            case 1: {
                result.append("INFO");
                break;
            }
            case 2: {
                result.append("WARNING");
                break;
            }
            case 4: {
                result.append("ERROR");
                break;
            }
            case 8: {
                result.append("CANCEL");
                break;
            }
            default: {
                result.append(Integer.toHexString(this.severity));
            }
        }
        result.append(" source=");
        result.append(this.source);
        result.append(" code=");
        result.append(this.code);
        result.append(' ');
        result.append(this.message);
        if (this.data != null) {
            result.append(" data=");
            result.append(this.data);
        }
        if (this.children != null) {
            result.append(' ');
            result.append(this.children);
        }
        return result.toString();
    }

    public static Diagnostic toDiagnostic(Throwable throwable) {
        if (throwable instanceof DiagnosticException) {
            return ((DiagnosticException)throwable).getDiagnostic();
        }
        if (throwable instanceof WrappedException) {
            return BasicDiagnostic.toDiagnostic(throwable.getCause());
        }
        String message = throwable.getClass().getName();
        int index = message.lastIndexOf(46);
        if (index >= 0) {
            message = message.substring(index + 1);
        }
        if (throwable.getLocalizedMessage() != null) {
            message = String.valueOf(message) + ": " + throwable.getLocalizedMessage();
        }
        BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.common", 0, message, new Object[]{throwable});
        if (throwable.getCause() != null && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
            basicDiagnostic.add(BasicDiagnostic.toDiagnostic(throwable));
        }
        return basicDiagnostic;
    }
}

