/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.regexp.shared.SplitResult;
import com.google.gwt.user.client.rpc.GwtTransient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.InvocationTargetException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.EModelElementImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EFactoryImpl
extends EModelElementImpl
implements EFactory {
    @GwtTransient
    protected EPackage ePackage;
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final RegExp WHITE_SPACE = RegExp.compile((String)"[ \t\n\r\f]+");
    public static InternalEDateTimeFormat[] EDATE_FORMATS;

    static {
        try {
            class ClientInternalEDateTimeFormat
            implements InternalEDateTimeFormat {
                DateTimeFormat dateTimeFormat;

                ClientInternalEDateTimeFormat(DateTimeFormat dateTimeFormat) {
                    this.dateTimeFormat = dateTimeFormat;
                }

                public Date parse(String value) {
                    return this.dateTimeFormat.parse(value);
                }

                public String format(Date value) {
                    return this.dateTimeFormat.format(value);
                }
            }
            EDATE_FORMATS = new InternalEDateTimeFormat[]{new ClientInternalEDateTimeFormat(DateTimeFormat.getFormat((String)"yyyy-MM-dd'T'HH:mm:ss'.'SSSZ")), new ClientInternalEDateTimeFormat(DateTimeFormat.getFormat((String)"yyyy-MM-dd'T'HH:mm:ss'.'SSS")), new ClientInternalEDateTimeFormat(DateTimeFormat.getFormat((String)"yyyy-MM-dd'T'HH:mm:ss")), new ClientInternalEDateTimeFormat(DateTimeFormat.getFormat((String)"yyyy-MM-dd'T'HH:mm")), new ClientInternalEDateTimeFormat(DateTimeFormat.getFormat((String)"yyyy-MM-dd"))};
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected EFactoryImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return EcorePackage.Literals.EFACTORY;
    }

    @Override
    public EPackage getEPackage() {
        return this.ePackage;
    }

    @Override
    public void setEPackage(EPackage newEPackage) {
        if (newEPackage != this.ePackage) {
            NotificationChain msgs = null;
            if (this.ePackage != null) {
                msgs = ((InternalEObject)((Object)this.ePackage)).eInverseRemove(this, 4, EPackage.class, msgs);
            }
            if (newEPackage != null) {
                msgs = ((InternalEObject)((Object)newEPackage)).eInverseAdd(this, 4, EPackage.class, msgs);
            }
            if ((msgs = this.basicSetEPackage(newEPackage, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newEPackage, (Object)newEPackage));
        }
    }

    public NotificationChain basicSetEPackage(EPackage newEPackage, NotificationChain msgs) {
        EPackage oldEPackage = this.ePackage;
        this.ePackage = newEPackage;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldEPackage, (Object)newEPackage);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getEPackage();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setEPackage((EPackage)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setEPackage(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return this.ePackage != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.getEAnnotation((String)arguments.get(0));
            }
            case 1: {
                return this.create((EClass)arguments.get(0));
            }
            case 2: {
                return this.createFromString((EDataType)arguments.get(0), (String)arguments.get(1));
            }
            case 3: {
                return this.convertToString((EDataType)arguments.get(0), arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public EObject create(EClass eClass) {
        if (this.getEPackage() != eClass.getEPackage() || eClass.isAbstract()) {
            throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
        }
        EList<EClass> eSuperTypes = eClass.getESuperTypes();
        while (!eSuperTypes.isEmpty()) {
            EClass eSuperType = (EClass)eSuperTypes.get(0);
            if (eSuperType.getInstanceClass() != null) {
                EObject result = eSuperType.getEPackage().getEFactoryInstance().create(eSuperType);
                ((InternalEObject)result).eSetClass(eClass);
                return result;
            }
            eSuperTypes = eSuperType.getESuperTypes();
        }
        return this.basicCreate(eClass);
    }

    protected EObject basicCreate(EClass eClass) {
        return eClass.getInstanceClassName() == "java.util.Map$Entry" ? new DynamicEObjectImpl.BasicEMapEntry(eClass) : new DynamicEObjectImpl(eClass);
    }

    @Override
    public Object createFromString(EDataType eDataType, String stringValue) {
        if (stringValue == null) {
            return null;
        }
        if (this.getEPackage() != eDataType.getEPackage()) {
            throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
        }
        if (eDataType instanceof EEnum) {
            EEnumLiteral result = ((EEnum)eDataType).getEEnumLiteralByLiteral(stringValue);
            if (result == null) {
                throw new IllegalArgumentException("The value '" + stringValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
            }
            return result;
        }
        switch (ExtendedMetaData.INSTANCE.getWhiteSpaceFacet(eDataType)) {
            case 2: {
                stringValue = this.replaceWhiteSpace(stringValue);
                break;
            }
            case 3: {
                stringValue = this.collapseWhiteSpace(stringValue);
            }
        }
        EDataType baseType = ExtendedMetaData.INSTANCE.getBaseType(eDataType);
        if (baseType != null) {
            return EcoreUtil.createFromString(baseType, stringValue);
        }
        EDataType itemType = ExtendedMetaData.INSTANCE.getItemType(eDataType);
        if (itemType != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            String[] stringArray = this.split(stringValue);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                result.add(EcoreUtil.createFromString(itemType, item));
                ++n2;
            }
            return result;
        }
        List<EDataType> memberTypes = ExtendedMetaData.INSTANCE.getMemberTypes(eDataType);
        if (!memberTypes.isEmpty()) {
            for (EDataType memberType : memberTypes) {
                try {
                    Object result = EcoreUtil.createFromString(memberType, stringValue);
                    if (result == null) continue;
                    return result;
                }
                catch (RuntimeException result) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("The value '" + stringValue + "' does not match any member types of the union datatype '" + eDataType.getName() + "'");
        }
        EDataType.Internal.ConversionDelegate conversionDelegate = ((EDataType.Internal)eDataType).getConversionDelegate();
        if (conversionDelegate != null) {
            return conversionDelegate.createFromString(stringValue);
        }
        Class<?> c = EcoreUtil.wrapperClassFor(eDataType.getInstanceClass());
        if (c == null) {
            return null;
        }
        if (c == Character.class) {
            char charValue = '\u0000';
            try {
                charValue = (char)Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                char[] carray = stringValue.toCharArray();
                charValue = carray[0];
            }
            return Character.valueOf(charValue);
        }
        if (c == Date.class) {
            int i = 0;
            while (i < EDATE_FORMATS.length) {
                try {
                    return EDATE_FORMATS[i].parse(stringValue);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ++i;
                }
            }
            throw new IllegalArgumentException("The value '" + stringValue + "' is not a date formatted string of the form yyyy-MM-dd'T'HH:mm:ss'.'SSSZ or a valid subset thereof");
        }
        throw new IllegalArgumentException("The value '" + stringValue + "' is invalid. ");
    }

    @Override
    public String convertToString(EDataType eDataType, Object objectValue) {
        if (this.getEPackage() != eDataType.getEPackage()) {
            throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
        }
        EDataType baseType = ExtendedMetaData.INSTANCE.getBaseType(eDataType);
        if (baseType != null) {
            return EcoreUtil.convertToString(baseType, objectValue);
        }
        EDataType itemType = ExtendedMetaData.INSTANCE.getItemType(eDataType);
        if (itemType != null) {
            if (objectValue == null) {
                return null;
            }
            List list = (List)objectValue;
            if (list.isEmpty()) {
                return "";
            }
            StringBuffer result = new StringBuffer();
            for (Object item : list) {
                result.append(EcoreUtil.convertToString(itemType, item));
                result.append(' ');
            }
            return result.substring(0, result.length() - 1);
        }
        List<EDataType> memberTypes = ExtendedMetaData.INSTANCE.getMemberTypes(eDataType);
        if (!memberTypes.isEmpty()) {
            for (EDataType memberType : memberTypes) {
                if (!memberType.isInstance(objectValue)) continue;
                try {
                    String result = EcoreUtil.convertToString(memberType, objectValue);
                    if (result == null) continue;
                    return result;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Invalid value: '" + objectValue + "' for datatype :" + eDataType.getName());
        }
        EDataType.Internal.ConversionDelegate conversionDelegate = ((EDataType.Internal)eDataType).getConversionDelegate();
        if (conversionDelegate != null) {
            return conversionDelegate.convertToString(objectValue);
        }
        if (objectValue == null) {
            return null;
        }
        if (objectValue instanceof Character) {
            return Integer.toString(((Character)objectValue).charValue());
        }
        if (objectValue.getClass() == Date.class) {
            return EDATE_FORMATS[0].format((Date)objectValue);
        }
        return objectValue.toString();
    }

    byte[] hexStringToBytes(String initialValue) {
        if (initialValue == null) {
            return null;
        }
        int size = initialValue.length();
        int limit = (size + 1) / 2;
        byte[] result = new byte[limit];
        if (size % 2 != 0) {
            result[--limit] = EFactoryImpl.hexCharToByte(initialValue.charAt(size - 1));
        }
        int i = 0;
        int j = 0;
        while (i < limit) {
            byte high = EFactoryImpl.hexCharToByte(initialValue.charAt(j++));
            byte low = EFactoryImpl.hexCharToByte(initialValue.charAt(j++));
            result[i] = (byte)(high << 4 | low);
            ++i;
        }
        return result;
    }

    static byte hexCharToByte(char character) {
        switch (character) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return (byte)(character - 48);
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return (byte)(character - 97 + 10);
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return (byte)(character - 65 + 10);
            }
        }
        throw new NumberFormatException("Invalid hexadecimal");
    }

    String bytesToHexString(byte[] bytes, int count) {
        if (bytes == null) {
            return null;
        }
        char[] result = new char[2 * count];
        int i = 0;
        int j = 0;
        while (i < count) {
            int high = bytes[i] >> 4 & 0xF;
            int low = bytes[i] & 0xF;
            result[j++] = HEX_DIGITS[high];
            result[j++] = HEX_DIGITS[low];
            ++i;
        }
        return new String(result);
    }

    protected Object createFromString(String hexString) {
        if (hexString == null) {
            return null;
        }
        return null;
    }

    protected String convertToString(Object instanceValue) {
        return instanceValue.toString();
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getEAnnotations()).basicAdd(otherEnd, msgs);
            }
            case 1: {
                if (this.ePackage != null) {
                    msgs = ((InternalEObject)((Object)this.ePackage)).eInverseRemove(this, 4, EPackage.class, msgs);
                }
                return this.basicSetEPackage((EPackage)((Object)otherEnd), msgs);
            }
        }
        return this.eDynamicInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getEAnnotations()).basicRemove(otherEnd, msgs);
            }
            case 1: {
                return this.basicSetEPackage(null, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    protected String replaceWhiteSpace(String value) {
        return XMLTypeUtil.normalize(value, false);
    }

    protected String collapseWhiteSpace(String value) {
        return XMLTypeUtil.normalize(value, true);
    }

    protected String[] split(String value) {
        SplitResult split = WHITE_SPACE.split(value);
        int length = split.length();
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = split.get(i);
            ++i;
        }
        return result;
    }

    public static interface InternalEDateTimeFormat {
        public Date parse(String var1);

        public String format(Date var1);
    }
}

