/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.Callback;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface URIConverter {
    public static final String OPTION_URI_CONVERTER = "URI_CONVERTER";
    public static final String OPTION_RESPONSE = "RESPONSE";
    public static final String RESPONSE_RESULT = "RESULT";
    public static final String RESPONSE_TIME_STAMP_PROPERTY = "TIME_STAMP";
    public static final String RESPONSE_URI = "URI";
    public static final String OPTION_UPDATE_ONLY_IF_TIME_STAMP_MATCHES = "UPDATE_ONLY_IF_TIME_STAMP_MATCHES";
    public static final Map<URI, URI> URI_MAP = URIMappingRegistryImpl.INSTANCE.map();
    public static final String ATTRIBUTE_TIME_STAMP = "timeStamp";
    public static final long NULL_TIME_STAMP = -1L;
    public static final String ATTRIBUTE_LENGTH = "length";
    public static final String ATTRIBUTE_READ_ONLY = "readOnly";
    public static final String ATTRIBUTE_EXECUTABLE = "executable";
    public static final String ATTRIBUTE_ARCHIVE = "archive";
    public static final String ATTRIBUTE_HIDDEN = "hidden";
    public static final String ATTRIBUTE_DIRECTORY = "directory";
    public static final String OPTION_REQUESTED_ATTRIBUTES = "requestedAttributes";
    public static final URIConverter INSTANCE = new ExtensibleURIConverterImpl();

    public URI normalize(URI var1);

    public Map<URI, URI> getURIMap();

    public EList<URIHandler> getURIHandlers();

    public URIHandler getURIHandler(URI var1);

    public EList<ContentHandler> getContentHandlers();

    public InputStream createInputStream(URI var1) throws IOException;

    public InputStream createInputStream(URI var1, Map<?, ?> var2) throws IOException;

    public void createInputStream(URI var1, Map<?, ?> var2, Callback<Map<?, ?>> var3);

    public OutputStream createOutputStream(URI var1) throws IOException;

    public OutputStream createOutputStream(URI var1, Map<?, ?> var2) throws IOException;

    public void store(URI var1, byte[] var2, Map<?, ?> var3, Callback<Map<?, ?>> var4);

    public void delete(URI var1, Map<?, ?> var2) throws IOException;

    public void delete(URI var1, Map<?, ?> var2, Callback<Map<?, ?>> var3);

    public Map<String, ?> contentDescription(URI var1, Map<?, ?> var2) throws IOException;

    public boolean exists(URI var1, Map<?, ?> var2);

    public void exists(URI var1, Map<?, ?> var2, Callback<Boolean> var3);

    public Map<String, ?> getAttributes(URI var1, Map<?, ?> var2);

    public void setAttributes(URI var1, Map<String, ?> var2, Map<?, ?> var3) throws IOException;

    public static interface Cipher {
        public OutputStream encrypt(OutputStream var1) throws Exception;

        public void finish(OutputStream var1) throws Exception;

        public InputStream decrypt(InputStream var1) throws Exception;

        public void finish(InputStream var1) throws Exception;
    }

    public static interface Loadable {
        public void loadResource(Resource var1) throws IOException;
    }

    public static interface Saveable {
        public void saveResource(Resource var1) throws IOException;
    }
}

