/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource;

import com.google.gwt.user.client.rpc.AsyncCallback;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.Callback;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIServiceAsync;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIServiceCallback
extends URIHandlerImpl {
    protected URIServiceAsync uriService;

    public URIServiceCallback(URIServiceAsync uriService) {
        this.uriService = uriService;
    }

    @Override
    public void createInputStream(final URI uri, Map<?, ?> options, final Callback<Map<?, ?>> callback) {
        HashMap massagedOptions = new HashMap(options);
        massagedOptions.remove("URI_CONVERTER");
        this.uriService.fetch(uri.toString(), massagedOptions, new AsyncCallback<Map<?, ?>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(Map<?, ?> result) {
                Map response = (Map)result.get("RESPONSE");
                Object responseResult = response.get("RESULT");
                if (responseResult == null) {
                    callback.onFailure((Throwable)new IOException("Stream for '" + uri + "' not found"));
                } else if (responseResult instanceof byte[]) {
                    byte[] bytes = (byte[])responseResult;
                    response.put("RESULT", new ByteArrayInputStream(bytes));
                    callback.onSuccess(result);
                } else {
                    callback.onFailure((Throwable)((IOException)responseResult));
                }
            }
        });
    }

    @Override
    public void store(URI uri, byte[] bytes, Map<?, ?> options, final Callback<Map<?, ?>> callback) {
        HashMap massagedOptions = new HashMap(options);
        massagedOptions.remove("URI_CONVERTER");
        this.uriService.store(uri.toString(), bytes, massagedOptions, new AsyncCallback<Map<?, ?>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(Map<?, ?> result) {
                Map response = (Map)result.get("RESPONSE");
                Object responseResult = response.get("RESULT");
                if (responseResult instanceof Throwable) {
                    callback.onFailure((Throwable)responseResult);
                } else {
                    callback.onSuccess(result);
                }
            }
        });
    }

    @Override
    public void delete(URI uri, Map<?, ?> options, final Callback<Map<?, ?>> callback) {
        HashMap massagedOptions = new HashMap(options);
        massagedOptions.remove("URI_CONVERTER");
        Map response = (Map)massagedOptions.get("RESPONSE");
        if (response == null) {
            massagedOptions.put("RESPONSE", new HashMap());
        }
        this.uriService.delete(uri.toString(), massagedOptions, new AsyncCallback<Map<?, ?>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(Map<?, ?> result) {
                Map response = (Map)result.get("RESPONSE");
                Object responseResult = response.get("RESULT");
                if (responseResult instanceof Throwable) {
                    callback.onFailure((Throwable)responseResult);
                } else {
                    callback.onSuccess(result);
                }
            }
        });
    }

    @Override
    public void exists(URI uri, Map<?, ?> options, final Callback<Boolean> callback) {
        HashMap massagedOptions = new HashMap(options);
        massagedOptions.remove("URI_CONVERTER");
        Map response = (Map)massagedOptions.get("RESPONSE");
        if (response == null) {
            massagedOptions.put("RESPONSE", new HashMap());
        }
        this.uriService.exists(uri.toString(), massagedOptions, new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(Boolean result) {
                callback.onSuccess((Object)result);
            }
        });
    }
}

