/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalURIHandlerImpl
extends URIHandlerImpl {
    protected Map<URI, byte[]> localBytes = new HashMap<URI, byte[]>();

    @Override
    public boolean canHandle(URI uri) {
        return "local".equals(uri.scheme());
    }

    @Override
    public OutputStream createOutputStream(final URI uri, Map<?, ?> options) throws IOException {
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                LocalURIHandlerImpl.this.localBytes.put(uri, this.toByteArray());
            }
        };
    }

    @Override
    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        byte[] bytes = this.localBytes.get(uri);
        if (bytes == null) {
            throw new IOException("Resource not found: " + uri);
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public void delete(URI uri, Map<?, ?> options) throws IOException {
        super.delete(uri, options);
    }

    @Override
    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        return super.contentDescription(uri, options);
    }

    @Override
    public boolean exists(URI uri, Map<?, ?> options) {
        return super.exists(uri, options);
    }

    @Override
    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return super.getAttributes(uri, options);
    }

    @Override
    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        super.setAttributes(uri, attributes, options);
    }
}

