/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformResourceURIHandlerImpl
extends URIHandlerImpl {
    @Override
    public boolean canHandle(URI uri) {
        return uri.isPlatformResource();
    }

    @Override
    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        String platformResourcePath = uri.toPlatformString(true);
        URI resolvedLocation = EcorePlugin.resolvePlatformResourcePath(platformResourcePath);
        if (resolvedLocation != null) {
            return ((URIConverter)options.get("URI_CONVERTER")).createOutputStream(resolvedLocation, options);
        }
        throw new IOException("The path '" + platformResourcePath + "' is unmapped");
    }

    @Override
    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        String platformResourcePath = uri.toPlatformString(true);
        URI resolvedLocation = EcorePlugin.resolvePlatformResourcePath(platformResourcePath);
        if (resolvedLocation != null) {
            return this.getURIConverter(options).createInputStream(resolvedLocation, options);
        }
        throw new IOException("The path '" + platformResourcePath + "' is unmapped");
    }

    @Override
    public void delete(URI uri, Map<?, ?> options) throws IOException {
        String platformResourcePath = uri.toPlatformString(true);
        URI resolvedLocation = EcorePlugin.resolvePlatformResourcePath(platformResourcePath);
        if (resolvedLocation == null) {
            throw new IOException("The path '" + platformResourcePath + "' is unmapped");
        }
        this.getURIConverter(options).delete(resolvedLocation, options);
    }

    @Override
    public boolean exists(URI uri, Map<?, ?> options) {
        String platformResourcePath = uri.toPlatformString(true);
        URI resolvedLocation = EcorePlugin.resolvePlatformResourcePath(platformResourcePath);
        return resolvedLocation != null && this.getURIConverter(options).exists(resolvedLocation, options);
    }

    @Override
    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        String platformResourcePath = uri.toPlatformString(true);
        URI resolvedLocation = EcorePlugin.resolvePlatformResourcePath(platformResourcePath);
        return resolvedLocation == null ? Collections.emptyMap() : this.getURIConverter(options).getAttributes(resolvedLocation, options);
    }

    @Override
    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        String platformResourcePath = uri.toPlatformString(true);
        URI resolvedLocation = EcorePlugin.resolvePlatformResourcePath(platformResourcePath);
        if (resolvedLocation == null) {
            throw new IOException("The platform resource path '" + platformResourcePath + "' does not resolve");
        }
        this.getURIConverter(options).setAttributes(resolvedLocation, attributes, options);
    }
}

