/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Callback;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIHandlerImpl
implements URIHandler {
    @Override
    public boolean canHandle(URI uri) {
        return true;
    }

    protected URIConverter getURIConverter(Map<?, ?> options) {
        return (URIConverter)options.get("URI_CONVERTER");
    }

    protected Map<Object, Object> getResponse(Map<?, ?> options) {
        return (Map)options.get("RESPONSE");
    }

    protected Set<String> getRequestedAttributes(Map<?, ?> options) {
        return (Set)options.get("requestedAttributes");
    }

    @Override
    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        return null;
    }

    @Override
    public void store(URI uri, byte[] bytes, Map<?, ?> options, Callback<Map<?, ?>> callback) {
        callback.onSuccess(null);
    }

    @Override
    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        return null;
    }

    @Override
    public void createInputStream(URI uri, Map<?, ?> options, Callback<Map<?, ?>> callback) {
        callback.onSuccess(null);
    }

    @Override
    public void delete(URI uri, Map<?, ?> options) throws IOException {
    }

    @Override
    public void delete(URI uri, Map<?, ?> options, Callback<Map<?, ?>> callback) {
        callback.onSuccess(null);
    }

    @Override
    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        URIConverter uriConverter = (URIConverter)options.get("URI_CONVERTER");
        InputStream inputStream = null;
        Map<String, ?> result = null;
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        try {
            for (ContentHandler contentHandler : uriConverter.getContentHandlers()) {
                if (!contentHandler.canHandle(uri)) continue;
                if (inputStream == null) {
                    inputStream = this.createInputStream(uri, options);
                    inputStream.markSupported();
                    inputStream.mark(Integer.MAX_VALUE);
                } else {
                    inputStream.reset();
                }
                Map<String, ?> contentDescription = contentHandler.contentDescription(uri, inputStream, options, context);
                switch ((ContentHandler.Validity)((Object)contentDescription.get("org.eclipse.emf.ecore:validity"))) {
                    case VALID: {
                        Map<String, ?> map = contentDescription;
                        return map;
                    }
                    case INDETERMINATE: {
                        if (result != null) break;
                        result = contentDescription;
                        break;
                    }
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return result == null ? ContentHandler.INVALID_CONTENT_DESCRIPTION : result;
    }

    @Override
    public boolean exists(URI uri, Map<?, ?> options) {
        return false;
    }

    @Override
    public void exists(URI uri, Map<?, ?> options, Callback<Boolean> callback) {
        callback.onSuccess((Object)false);
    }

    @Override
    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return null;
    }

    @Override
    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
    }
}

