/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xml.type.util;

import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.emf.ecore.xml.type.internal.RegEx;

public final class XMLTypeUtil {
    public static final int EQUALS = 0;
    public static final int LESS_THAN = -1;
    public static final int GREATER_THAN = 1;
    public static final int INDETERMINATE = 2;

    public static boolean isSpace(char value) {
        return DataValue.XMLChar.isSpace(value);
    }

    public static String normalize(String value, boolean collapse) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        if (length == 0) {
            return "";
        }
        char[] valueArray = new char[length];
        value.getChars(0, length, valueArray, 0);
        StringBuffer buffer = null;
        boolean skipSpace = collapse;
        int i = 0;
        int offset = 0;
        while (i < length) {
            char c = valueArray[i];
            if (XMLTypeUtil.isSpace(c)) {
                if (skipSpace) {
                    if (buffer == null) {
                        buffer = new StringBuffer(value);
                    }
                    buffer.deleteCharAt(i - offset++);
                } else {
                    skipSpace = collapse;
                    if (c != ' ') {
                        if (buffer == null) {
                            buffer = new StringBuffer(value);
                        }
                        buffer.setCharAt(i - offset, ' ');
                    }
                }
            } else {
                skipSpace = false;
            }
            ++i;
        }
        if (skipSpace) {
            if (buffer == null) {
                return value.substring(0, length - 1);
            }
            length = buffer.length();
            if (length > 0) {
                return buffer.substring(0, length - 1);
            }
            return "";
        }
        if (buffer == null) {
            return value;
        }
        return buffer.toString();
    }

    public static EValidator.PatternMatcher createPatternMatcher(String pattern) {
        return new PatternMatcherImpl(pattern);
    }

    public static boolean isNameStart(int codePoint) {
        return DataValue.XMLChar.isNameStart(codePoint);
    }

    public static boolean isNamePart(int codePoint) {
        return DataValue.XMLChar.isName(codePoint);
    }

    public static boolean isNCNameStart(int codePoint) {
        return DataValue.XMLChar.isNCNameStart(codePoint);
    }

    public static boolean isNCNamePart(int codePoint) {
        return DataValue.XMLChar.isNCName(codePoint);
    }

    private static class PatternMatcherImpl
    implements EValidator.PatternMatcher {
        protected RegEx.RegularExpression regularExpression;

        public PatternMatcherImpl(String pattern) {
            this.regularExpression = new RegEx.RegularExpression(pattern, "X");
        }

        public boolean matches(String value) {
            return this.regularExpression.matches(value);
        }

        public String toString() {
            return this.regularExpression.getPattern();
        }
    }
}

