/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.server.ecore.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.server.ecore.resource.DatastoreUtil;
import org.eclipse.emf.server.ecore.resource.URIHandlerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreURIHandlerImpl
extends URIHandlerImpl {
    @Override
    public boolean canHandle(URI uri) {
        return "datastore".equals(uri.scheme());
    }

    @Override
    public OutputStream createOutputStream(final URI uri, final Map<?, ?> options) throws IOException {
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                this.flush();
                super.close();
            }

            public void flush() throws IOException {
                byte[] bytes = this.toByteArray();
                DatastoreUtil.store(uri.toString(), bytes, options);
                Map<Object, Object> response = DatastoreURIHandlerImpl.this.getResponse(options);
                Long timestamp = (Long)response.get("TIME_STAMP");
                if (timestamp == null) {
                    throw new IOException("Failed to save " + uri);
                }
            }
        };
    }

    @Override
    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        String uriString = uri.toString();
        DatastoreUtil.fetch(uriString, options);
        Map<Object, Object> response = this.getResponse(options);
        Object result = response.get("RESULT");
        if (result == null) {
            throw new IOException("URI not found " + uri);
        }
        if (result instanceof byte[]) {
            byte[] bytes = (byte[])result;
            return new ByteArrayInputStream(bytes);
        }
        throw (IOException)result;
    }

    @Override
    public void delete(URI uri, Map<?, ?> options) throws IOException {
        DatastoreUtil.delete(uri.toString(), options);
    }

    @Override
    public boolean exists(URI uri, Map<?, ?> options) {
        return DatastoreUtil.exists(uri.toString(), options);
    }

    @Override
    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return super.getAttributes(uri, options);
    }

    @Override
    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        super.setAttributes(uri, attributes, options);
    }
}

