/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.server.ecore.resource;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.server.ecore.resource.DatastoreURIHandlerImpl;
import org.eclipse.emf.server.ecore.resource.URIHandlerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatastoreUtil {
    public static final String OPTION_SESSION = "SESSION";
    protected static final int MAX_BLOB_SIZE = 1000000;

    static {
        EcorePlugin.DEFAULT_URI_HANDLERS.add(new DatastoreURIHandlerImpl());
        EcorePlugin.DEFAULT_URI_HANDLERS.add(new URIHandlerImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new ResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                return new BinaryResourceImpl(uri);
            }
        });
    }

    private DatastoreUtil() {
    }

    public static List<Resource> getResources(ResourceSet resourceSet, ResourceFilter resourceFilter) throws IOException {
        return DatastoreUtil.getResources(resourceSet, resourceFilter, null);
    }

    public static List<Resource> getResources(ResourceSet resourceSet, ResourceFilter resourceFilter, String sessionID) throws IOException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();
        Entity session = DatastoreUtil.getSession(datastoreService, sessionID);
        Key sessionKey = session == null ? null : session.getKey();
        Query query = new Query("org.eclipse.emf.ecore.resource", sessionKey);
        PreparedQuery preparedQuery = datastoreService.prepare(query);
        for (Entity entity : preparedQuery.asIterable()) {
            if (!resourceFilter.isIncluded(entity) || sessionKey == null && entity.getParent() != null) continue;
            URI uri = URI.createURI((String)((String)entity.getProperty("uri")));
            Resource resource = resourceSet.getResource(uri, false);
            if (resource == null) {
                resource = resourceSet.createResource(uri);
            }
            if (!resource.isLoaded()) {
                resource.load(new ByteArrayInputStream(DatastoreUtil.getBytes(entity, datastoreService)), resourceSet.getLoadOptions());
                resource.setTimeStamp((Long)entity.getProperty("timestamp"));
            }
            result.add(resource);
        }
        return result;
    }

    public static List<URI> getResources() {
        return DatastoreUtil.getResources(null);
    }

    public static List<URI> getResources(String sessionID) {
        ArrayList<URI> result = new ArrayList<URI>();
        DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();
        Entity session = DatastoreUtil.getSession(datastoreService, sessionID);
        Key sessionKey = session == null ? null : session.getKey();
        Query query = new Query("org.eclipse.emf.ecore.resource", sessionKey);
        PreparedQuery preparedQuery = datastoreService.prepare(query);
        for (Entity entity : preparedQuery.asIterable()) {
            if (sessionKey == null && entity.getKey() != null) continue;
            URI uri = URI.createURI((String)((String)entity.getProperty("uri")));
            result.add(uri);
        }
        return result;
    }

    public static Entity getEntity(Key sessionKey, PreparedQuery query) {
        if (sessionKey == null) {
            for (Entity entity : query.asIterable()) {
                if (entity.getParent() != null) continue;
                return entity;
            }
            return null;
        }
        return query.asSingleEntity();
    }

    public static Map<?, ?> fetch(String uri, Map<?, ?> options) {
        Map result = (Map)options.get("RESPONSE");
        DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();
        Entity session = DatastoreUtil.getSession(datastoreService, (String)options.get(OPTION_SESSION));
        Key sessionKey = session == null ? null : session.getKey();
        Query query = new Query("org.eclipse.emf.ecore.resource", sessionKey);
        if (uri.equals("datastore:/")) {
            BinaryResourceImpl resource = new BinaryResourceImpl(URI.createURI((String)uri));
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            resource.getContents().add((Object)eAnnotation);
            PreparedQuery preparedQuery = datastoreService.prepare(query);
            for (Entity entity : preparedQuery.asIterable()) {
                if (sessionKey == null && entity.getParent() != null) continue;
                eAnnotation.getDetails().put((Object)entity.getProperty("uri").toString(), (Object)entity.getProperty("timestamp").toString());
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                resource.save(out, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            result.put("RESULT", out.toByteArray());
        } else {
            query.setFilter((Query.Filter)Query.FilterOperator.EQUAL.of("uri", (Object)uri));
            PreparedQuery preparedQuery = datastoreService.prepare(query);
            Entity entity = DatastoreUtil.getEntity(sessionKey, preparedQuery);
            if (entity != null) {
                result.put("TIME_STAMP", entity.getProperty("timestamp"));
                byte[] bytes = DatastoreUtil.getBytes(entity, datastoreService);
                result.put("RESULT", bytes);
            } else {
                result.put("RESULT", null);
            }
        }
        return options;
    }

    public static byte[] getBytes(Entity entity, DatastoreService datastoreService) {
        if (entity.hasProperty("content")) {
            Blob blob = (Blob)entity.getProperty("content");
            return blob.getBytes();
        }
        Query contentBlobsQuery = new Query("ChildBlob", entity.getKey());
        PreparedQuery preparedContentBlobsQuery = datastoreService.prepare(contentBlobsQuery);
        TreeMap<Long, byte[]> contents = new TreeMap<Long, byte[]>();
        int length = 0;
        for (Entity contentBlobEntity : preparedContentBlobsQuery.asIterable()) {
            byte[] childBytes = ((Blob)contentBlobEntity.getProperty("value")).getBytes();
            contents.put((Long)contentBlobEntity.getProperty("index"), childBytes);
            length += childBytes.length;
        }
        byte[] bytes = new byte[length];
        int offset = 0;
        for (byte[] childBytes : contents.values()) {
            System.arraycopy(childBytes, 0, bytes, offset, childBytes.length);
            offset += childBytes.length;
        }
        return bytes;
    }

    public static Entity getSession(DatastoreService datastoreService, String session) {
        Entity entity = null;
        if (session != null) {
            Query query = new Query("org.eclipse.emf.ecore.resource.session");
            query.setFilter((Query.Filter)Query.FilterOperator.EQUAL.of("id", (Object)session));
            PreparedQuery preparedQuery = datastoreService.prepare(query);
            entity = preparedQuery.asSingleEntity();
            if (entity == null) {
                entity = new Entity("org.eclipse.emf.ecore.resource.session");
                entity.setProperty("id", (Object)session);
                datastoreService.put(entity);
            }
        }
        return entity;
    }

    public static Map<?, ?> store(String uri, byte[] bytes, Map<?, ?> options) {
        Map result = (Map)options.get("RESPONSE");
        DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();
        Transaction transaction = datastoreService.beginTransaction();
        Entity session = DatastoreUtil.getSession(datastoreService, (String)options.get(OPTION_SESSION));
        Key sessionKey = session == null ? null : session.getKey();
        Query query = new Query("org.eclipse.emf.ecore.resource", sessionKey);
        query.setFilter((Query.Filter)Query.FilterOperator.EQUAL.of("uri", (Object)uri));
        PreparedQuery preparedQuery = datastoreService.prepare(query);
        Entity entity = DatastoreUtil.getEntity(sessionKey, preparedQuery);
        Long expectedTimestamp = (Long)options.get("UPDATE_ONLY_IF_TIME_STAMP_MATCHES");
        if (entity == null) {
            if (expectedTimestamp != null) {
                transaction.rollback();
                result.put("RESULT", new IOException("The timestamp for '" + uri + "' doesn't match the expected time stamp"));
                return options;
            }
            entity = session == null ? new Entity("org.eclipse.emf.ecore.resource") : new Entity("org.eclipse.emf.ecore.resource", session.getKey());
            entity.setProperty("uri", (Object)uri);
        } else {
            if (expectedTimestamp != null && expectedTimestamp.intValue() != ((Long)entity.getProperty("timestamp")).intValue()) {
                transaction.rollback();
                result.put("RESULT", new IOException("The timestamp for '" + uri + "' doesn't match the expected time stamp"));
                return options;
            }
            if (entity.hasProperty("content")) {
                entity.removeProperty("content");
            } else {
                Query contentBlobsQuery = new Query("ChildBlob", entity.getKey());
                PreparedQuery preparedContentBlobsQuery = datastoreService.prepare(transaction, contentBlobsQuery);
                for (Entity contentBlobEntity : preparedContentBlobsQuery.asIterable()) {
                    datastoreService.delete(transaction, new Key[]{contentBlobEntity.getKey()});
                }
            }
        }
        long timestamp = System.currentTimeMillis();
        entity.setUnindexedProperty("timestamp", (Object)timestamp);
        if (bytes.length > 1000000) {
            Key entityKey = datastoreService.put(transaction, entity);
            int i = 0;
            int offset = 0;
            while (offset < bytes.length) {
                int length = Math.min(bytes.length - offset, 1000000);
                byte[] childBytes = new byte[length];
                System.arraycopy(bytes, offset, childBytes, 0, length);
                Entity childBlobEntity = new Entity("ChildBlob", entityKey);
                childBlobEntity.setProperty("index", (Object)i);
                childBlobEntity.setUnindexedProperty("value", (Object)new Blob(childBytes));
                datastoreService.put(transaction, childBlobEntity);
                offset += 1000000;
                ++i;
            }
        } else {
            entity.setUnindexedProperty("content", (Object)new Blob(bytes));
            datastoreService.put(transaction, entity);
        }
        transaction.commit();
        result.put("TIME_STAMP", timestamp);
        result.put("RESULT", null);
        return options;
    }

    public static Map<?, ?> delete(String uri, Map<?, ?> options) {
        Map result = (Map)options.get("RESPONSE");
        DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();
        Entity session = DatastoreUtil.getSession(datastoreService, (String)options.get(OPTION_SESSION));
        Key sessionKey = session == null ? null : session.getKey();
        Query query = new Query("org.eclipse.emf.ecore.resource", sessionKey);
        query.setFilter((Query.Filter)Query.FilterOperator.EQUAL.of("uri", (Object)uri));
        PreparedQuery preparedQuery = datastoreService.prepare(query);
        Entity entity = DatastoreUtil.getEntity(sessionKey, preparedQuery);
        if (entity != null) {
            Long expectedTimestamp = (Long)options.get("UPDATE_ONLY_IF_TIME_STAMP_MATCHES");
            if (expectedTimestamp != null && expectedTimestamp.longValue() != ((Long)entity.getProperty("timestamp")).longValue()) {
                result.put("RESULT", new IOException("The timestamp for '" + uri + "' doesn't match the expected time stamp"));
                return options;
            }
            Transaction transaction = datastoreService.beginTransaction();
            if (!entity.hasProperty("content")) {
                Query contentBlobsQuery = new Query("ChildBlob", entity.getKey());
                PreparedQuery preparedContentBlobsQuery = datastoreService.prepare(transaction, contentBlobsQuery);
                for (Entity contentBlobEntity : preparedContentBlobsQuery.asIterable()) {
                    datastoreService.delete(transaction, new Key[]{contentBlobEntity.getKey()});
                }
            }
            datastoreService.delete(transaction, new Key[]{entity.getKey()});
            transaction.commit();
            result.put("RESULT", null);
        } else {
            result.put("RESULT", new IOException("No stream found for '" + uri + "'"));
        }
        return options;
    }

    public static boolean exists(String uri, Map<?, ?> options) {
        DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();
        Entity session = DatastoreUtil.getSession(datastoreService, (String)options.get(OPTION_SESSION));
        Key sessionKey = session == null ? null : session.getKey();
        Query query = new Query("org.eclipse.emf.ecore.resource", sessionKey);
        query.setFilter((Query.Filter)Query.FilterOperator.EQUAL.of("uri", (Object)uri));
        PreparedQuery preparedQuery = datastoreService.prepare(query);
        Entity entity = DatastoreUtil.getEntity(sessionKey, preparedQuery);
        return entity != null;
    }

    public static class ResourceFilter {
        public boolean isIncluded(Entity resourceEntity) {
            String uri = (String)resourceEntity.getProperty("uri");
            return this.isIncluded(uri);
        }

        public boolean isIncluded(String resourceURI) {
            return true;
        }
    }
}

