import { startSession, endSessionOnExit } from '../sessions.js';

/** Tracks sessions as the main process lifetime. */
class MainProcessSession {
    constructor(_options = {}) {
        this._options = _options;
        this.name = MainProcessSession.id;
    }
    /** @inheritDoc */
    setupOnce() {
        void startSession(!!this._options.sendOnCreate);
        endSessionOnExit();
    }
}
/** @inheritDoc */
MainProcessSession.id = 'MainProcessSession';

export { MainProcessSession };
//# sourceMappingURL=main-process-session.js.map
