const tslib = require('tslib');
const core = require('@sentry/core');
const utils = require('@sentry/utils');
const electron = require('electron');
const electronNormalize = require('../electron-normalize.js');

/** Adds Screenshots to events */
class Screenshots {
    constructor() {
        this.name = Screenshots.id;
    }
    /** @inheritDoc */
    setupOnce(addGlobalEventProcessor) {
        var _a;
        const attachScreenshot = !!((_a = core.getCurrentHub().getClient()) === null || _a === void 0 ? void 0 : _a.getOptions()).attachScreenshot;
        if (attachScreenshot) {
            addGlobalEventProcessor((event, hint) => tslib.__awaiter(this, void 0, void 0, function* () {
                // We don't capture screenshots for transactions or native crashes
                if (!event.transaction && event.platform !== 'native') {
                    let count = 1;
                    for (const window of electron.BrowserWindow.getAllWindows()) {
                        if (!hint.attachments) {
                            hint.attachments = [];
                        }
                        try {
                            if (!window.isDestroyed() && window.isVisible()) {
                                const filename = count === 1 ? 'screenshot.png' : `screenshot-${count}.png`;
                                const image = yield electronNormalize.capturePage(window);
                                hint.attachments.push({ filename, data: image.toPNG(), contentType: 'image/png' });
                                count += 1;
                            }
                        }
                        catch (e) {
                            // Catch all errors so we don't break event submission if something goes wrong
                            utils.logger.error('Error capturing screenshot', e);
                        }
                    }
                }
                return event;
            }));
        }
    }
}
/** @inheritDoc */
Screenshots.id = 'Screenshots';

exports.Screenshots = Screenshots;
//# sourceMappingURL=screenshots.js.map
