const utils = require('@sentry/utils');
const ipc = require('../ipc.js');

/**
 * @deprecated Events are now sent to the main process via a custom transport.
 *
 * Passes events to the main process.
 */
class EventToMain {
    constructor() {
        // eslint-disable-next-line deprecation/deprecation
        this.name = EventToMain.id;
    }
    /** @inheritDoc */
    setupOnce(addGlobalEventProcessor) {
        const ipc$1 = ipc.getIPC();
        addGlobalEventProcessor((event) => {
            // Ensure breadcrumbs is not `undefined` as `walk` translates it into a string
            event.breadcrumbs = event.breadcrumbs || [];
            // Remove the environment as it defaults to 'production' and overwrites the main process environment
            delete event.environment;
            ipc$1.sendEvent(JSON.stringify(utils.normalize(event, 20, 2000)));
            // Events are handled and sent from the main process so we return null here so nothing is sent from the renderer
            return null;
        });
    }
}
/** @inheritDoc */
EventToMain.id = 'EventToMain';

exports.EventToMain = EventToMain;
//# sourceMappingURL=event-to-main.js.map
