"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = __importDefault(require("lodash"));
const utils_1 = require("./utils");
const FieldProps_1 = require("./models/FieldProps");
class Bindings {
    constructor() {
        Object.defineProperty(this, "templates", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {
            // default: ({ field, form, props, keys, $try }) => ({
            //   [keys.id]: $try(props.id, field.id),
            // }),
            }
        });
        Object.defineProperty(this, "rewriters", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {
                default: {
                    id: FieldProps_1.FieldPropsEnum.id,
                    name: FieldProps_1.FieldPropsEnum.name,
                    type: FieldProps_1.FieldPropsEnum.type,
                    value: FieldProps_1.FieldPropsEnum.value,
                    checked: FieldProps_1.FieldPropsEnum.checked,
                    label: FieldProps_1.FieldPropsEnum.label,
                    placeholder: FieldProps_1.FieldPropsEnum.placeholder,
                    disabled: FieldProps_1.FieldPropsEnum.disabled,
                    onChange: FieldProps_1.FieldPropsEnum.onChange,
                    onBlur: FieldProps_1.FieldPropsEnum.onBlur,
                    onFocus: FieldProps_1.FieldPropsEnum.onFocus,
                    autoFocus: FieldProps_1.FieldPropsEnum.autoFocus,
                    inputMode: FieldProps_1.FieldPropsEnum.inputMode,
                    onKeyUp: FieldProps_1.FieldPropsEnum.onKeyUp,
                    onKeyDown: FieldProps_1.FieldPropsEnum.onKeyDown,
                },
            }
        });
    }
    register(bindings) {
        lodash_1.default.each(bindings, (val, key) => {
            if ((typeof val === 'function'))
                lodash_1.default.merge(this.templates, { [key]: val });
            if (lodash_1.default.isPlainObject(val))
                lodash_1.default.merge(this.rewriters, { [key]: val });
        });
        return this;
    }
    load(field, name = FieldProps_1.FieldPropsEnum.default, props) {
        const args = ({
            keys: lodash_1.default.get(this.rewriters, FieldProps_1.FieldPropsEnum.default),
            form: field.state.form,
            field,
            props,
            $try: utils_1.$try,
        });
        if (lodash_1.default.has(this.templates, FieldProps_1.FieldPropsEnum.default)) {
            return lodash_1.default.get(this.templates, name)(args);
        }
        if (lodash_1.default.has(this.rewriters, name)) {
            const $bindings = {};
            lodash_1.default.each(lodash_1.default.get(this.rewriters, name), ($v, $k) => lodash_1.default.merge($bindings, { [$v]: (0, utils_1.$try)(props[$k], field[$k]) }));
            return $bindings;
        }
        return lodash_1.default.get(this.templates, name)(args);
    }
}
exports.default = Bindings;
//# sourceMappingURL=Bindings.js.map