"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mobx_1 = require("mobx");
const lodash_1 = __importDefault(require("lodash"));
const Base_1 = __importDefault(require("./Base"));
const Validator_1 = __importDefault(require("./Validator"));
const State_1 = __importDefault(require("./State"));
const Field_1 = __importDefault(require("./Field"));
const FieldProps_1 = require("./models/FieldProps");
const OptionsModel_1 = require("./models/OptionsModel");
class Form extends Base_1.default {
    constructor(setup = {}, { name = "", options = {}, plugins = {}, bindings = {}, hooks = {}, handlers = {}, } = {}) {
        super();
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "path", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "validator", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "debouncedValidation", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        (0, mobx_1.makeObservable)(this, {
            fields: mobx_1.observable,
            validatedValues: mobx_1.computed,
            error: mobx_1.computed,
            hasError: mobx_1.computed,
            isValid: mobx_1.computed,
            isPristine: mobx_1.computed,
            isDirty: mobx_1.computed,
            isDefault: mobx_1.computed,
            isEmpty: mobx_1.computed,
            focused: mobx_1.computed,
            touched: mobx_1.computed,
            disabled: mobx_1.computed,
            // init: action,
            invalidate: mobx_1.action,
            clear: mobx_1.action,
            reset: mobx_1.action,
            resetValidation: mobx_1.action,
        });
        this.name = name;
        (0, mobx_1.runInAction)(() => (this.$hooks = hooks));
        (0, mobx_1.runInAction)(() => (this.$handlers = handlers));
        // load data from initializers methods
        const initial = lodash_1.default.each({
            setup,
            options,
            plugins,
            bindings,
        }, (val, key) => (typeof this[key] === 'function')
            ? lodash_1.default.merge(val, this[key].apply(this, [this]))
            : val);
        // setup hooks & handlers from initialization methods
        (0, mobx_1.runInAction)(() => { var _a; return Object.assign(this.$hooks, (_a = this.hooks) === null || _a === void 0 ? void 0 : _a.apply(this, [this])); });
        (0, mobx_1.runInAction)(() => { var _a; return Object.assign(this.$handlers, (_a = this.handlers) === null || _a === void 0 ? void 0 : _a.apply(this, [this])); });
        this.state = new State_1.default({
            form: this,
            initial: initial.setup,
            options: initial.options,
            bindings: initial.bindings,
        });
        this.validator = new Validator_1.default({
            form: this,
            plugins: initial.plugins,
        });
        this.initFields(initial.setup);
        this.debouncedValidation = lodash_1.default.debounce(this.validate, this.state.options.get(OptionsModel_1.OptionsEnum.validationDebounceWait), this.state.options.get(OptionsModel_1.OptionsEnum.validationDebounceOptions));
        // execute validation on form initialization
        this.state.options.get(OptionsModel_1.OptionsEnum.validateOnInit)
            && this.validator.validate({
                showErrors: this.state.options.get(OptionsModel_1.OptionsEnum.showErrorsOnInit),
            });
        this.execHook(FieldProps_1.FieldPropsEnum.onInit);
        // handle Form onChange Hook
        (0, mobx_1.autorun)(() => this.$changed && this.execHook(FieldProps_1.FieldPropsEnum.onChange));
    }
    /* ------------------------------------------------------------------ */
    /* COMPUTED */
    get validatedValues() {
        const data = {};
        this.each(($field) => (data[$field.path] = $field.validatedValue));
        return data;
    }
    get error() {
        return this.validator.error;
    }
    get hasError() {
        return !!this.validator.error || this.check(FieldProps_1.FieldPropsEnum.hasError, true);
    }
    get isValid() {
        return !this.validator.error && this.check(FieldProps_1.FieldPropsEnum.isValid, true);
    }
    get isPristine() {
        return this.check(FieldProps_1.FieldPropsEnum.isPristine, true);
    }
    get isDirty() {
        return this.check(FieldProps_1.FieldPropsEnum.isDirty, true);
    }
    get isDefault() {
        return this.check(FieldProps_1.FieldPropsEnum.isDefault, true);
    }
    get isEmpty() {
        return this.check(FieldProps_1.FieldPropsEnum.isEmpty, true);
    }
    get focused() {
        return this.check(FieldProps_1.FieldPropsEnum.focused, true);
    }
    get touched() {
        return this.check(FieldProps_1.FieldPropsEnum.touched, true);
    }
    get disabled() {
        return this.check(FieldProps_1.FieldPropsEnum.disabled, true);
    }
    makeField(data, FieldClass = Field_1.default) {
        return new FieldClass(data);
    }
    /** DEPRECATED
      Init Form Fields and Nested Fields
  
    init($fields: any = null): void {
      _.set(this, "fields", observable.map({}));
  
      this.state.initial.props.values = $fields; // eslint-disable-line
      this.state.current.props.values = $fields; // eslint-disable-line
  
      this.initFields({
        fields: $fields || this.state.struct(),
      });
    }
    */
    invalidate(message = null, deep = true) {
        this.debouncedValidation.cancel();
        this.validator.error = message || this.state.options.get(OptionsModel_1.OptionsEnum.defaultGenericError) || true;
        deep && this.each((field) => field.debouncedValidation.cancel());
    }
    showErrors(show = true) {
        this.each((field) => field.showErrors(show));
    }
    resetValidation(deep = true) {
        this.validator.error = null;
        deep && this.each((field) => field.resetValidation(deep));
    }
    /**
      Clear Form Fields
    */
    clear(deep = true, execHook = true) {
        execHook && this.execHook(FieldProps_1.FieldPropsEnum.onClear);
        this.$touched = false;
        this.$changed = 0;
        deep && this.each((field) => field.clear(deep));
    }
    /**
      Reset Form Fields
    */
    reset(deep = true, execHook = true) {
        execHook && this.execHook(FieldProps_1.FieldPropsEnum.onReset);
        this.$touched = false;
        this.$changed = 0;
        deep && this.each((field) => field.reset(deep));
    }
}
exports.default = Form;
//# sourceMappingURL=Form.js.map