# ASL code in this folder

For use by herd, this is only for when the architecture is `AArch64` with
variant `asl`, or the architecture is `ASL` with variant `asl+aarch64`.

For use by aslref with type-checking, this is done when running in this
folder `make type-check`.

As of today, herd7 doesn't type-check the whole shared-pseudocode, it uses a
non-failing mode of the type-checker that avoid parsing and checking the whole
300000lines of system register definitions.

## Code used by herd7, variant ASL.

In those settings the following files are used. Some are generated, some are
hand-written.

### Hand-written files

Extra definitions that complete the one in the Arm ARM:

- `implementations.asl`: Extra definitions in ASLv1 to complete what is not
  defined in the Arm ARM.
- `implementations-vmsa.asl`: Extra definitions needed with the variant `vmsa`,
  i.e. when Stage 1 translation is activated.
- `physmem-std.asl`: Definition of memory accesses.
- `physmem-vmsa.asl`: Definition of memory accesses with variant `vmsa`.

Definitions that replace the ones in the Arm ARM:

- `patches.asl`: ASL definitions that replace the ones in the Arm ARM.
- `patches-vmsa.asl`: ASL definitions that replace the ones in the Arm ARM,
  needed by the variant `vmsa`.

### Generated files

Those files are automatically generated from the published machine-readable
specifications by Arm.

- `shared_pseudocode.asl`: library of ASL definitions in the Arm ARM by
  `bundler.py` with argument `--make-shared-pseudocode`.
- `features.asl`: definitions of ASL listing of features. This is generated by
  `build_features.py`.
- `system_registers.asl`: definitions of some system registers in ASL. This is
  generated by `bundler.py` with argument `--make-regs`.
- `aarch64/**/*.opn`: instruction pseudocode extracted from the Arm ARM by
  `bundler.py` with argument `--make-opns`.

To download the machine readable specifications and generate the files, use
`make all` (this requires an internet connection and Python>=3.9).

## Code used by aslref to type-check the shared-pseudocode.

### Generated files

Those files are automatically generated from the published machine-readable
specifications by Arm.

- `shared_pseudocode.asl`: library of ASL definitions in the Arm ARM by
  `bundler.py` with argument `--make-shared-pseudocode`. Currently it is
  roughly 50k lines of code (LoC).
- `features.asl`: definitions of ASL listing of features. This is generated by
  `build_features.py`.
- `all_system_registers.asl`: definitions of most of system registers in ASL.
  This is generated by `bundler.py` with argument `--make-regs`. Currently it
  is 3MLoC.
- `all_instructions.asl`: defines a function for each encoding of an
  instruction. Currently is it roughly 200kLoC.
- `pmu_event_types.asl`: this defines each constant `PMU\w*` as `Zeros{8}` that
  appears in `shared_pseudocode.asl`.

### Hand-written files

Extra definitions that complete the ones automatically generated.

- `type-checking-implementations.asl`: implementations for the few functions
  and types that are not defined by the published xml.
- `trbmpam_el1.asl`: implementations for the system register `TRBMPAM` that
  uses a dynamic field that `bundler.py` doesn't support.

