/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXListCell;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.svg.SVGGlyph;
import com.jfoenix.transitions.CachedTransition;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.TranslateTransition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class JFXDatePickerContent
extends VBox {
    private static final String SPINNER_LABEL = "spinner-label";
    private static final String ROBOTO = "Roboto";
    private static final Color DEFAULT_CELL_COLOR = Color.valueOf((String)"#9C9C9C");
    private static final Color DEFAULT_COLOR = Color.valueOf((String)"#313131");
    protected JFXDatePicker datePicker;
    private JFXButton backMonthButton;
    private JFXButton forwardMonthButton;
    private ObjectProperty<Label> selectedYearCell = new SimpleObjectProperty(null);
    private Label selectedDateLabel;
    private Label selectedYearLabel;
    private Label monthYearLabel;
    protected GridPane contentGrid;
    private StackPane calendarPlaceHolder = new StackPane();
    private CachedTransition showTransition;
    private CachedTransition hideTransition;
    private ParallelTransition tempImageTransition;
    private int daysPerWeek = 7;
    private List<DateCell> weekDaysCells = new ArrayList<DateCell>();
    private List<DateCell> weekNumberCells = new ArrayList<DateCell>();
    protected List<DateCell> dayCells = new ArrayList<DateCell>();
    private LocalDate[] dayCellDates;
    private DateCell currentFocusedDayCell = null;
    private ListView<String> yearsListView = new JFXListView<String>(){
        {
            this.getStyleClass().setAll((Object[])new String[]{"date-picker-list-view"});
            this.setCellFactory(listView -> new JFXListCell<String>(){
                boolean mousePressed = false;
                {
                    this.getStyleClass().setAll((Object[])new String[]{"data-picker-list-cell"});
                    this.setOnMousePressed(click -> {
                        this.mousePressed = true;
                    });
                    this.setOnMouseEntered(enter -> {
                        if (!this.mousePressed) {
                            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.valueOf((String)"#EDEDED"), CornerRadii.EMPTY, Insets.EMPTY)}));
                        }
                    });
                    this.setOnMouseExited(enter -> {
                        if (!this.mousePressed) {
                            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
                        }
                    });
                    this.setOnMouseReleased(release -> {
                        if (this.mousePressed) {
                            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
                        }
                        this.mousePressed = false;
                    });
                    this.setOnMouseClicked(click -> {
                        String selectedItem = (String)JFXDatePickerContent.this.yearsListView.getSelectionModel().getSelectedItem();
                        if (selectedItem != null && selectedItem.equals(((Label)this.cellContent).getText())) {
                            int offset = Integer.parseInt(((Label)this.cellContent).getText()) - Integer.parseInt(JFXDatePickerContent.this.selectedYearLabel.getText());
                            JFXDatePickerContent.this.forward(offset, ChronoUnit.YEARS, false, false);
                            JFXDatePickerContent.this.hideTransition.setOnFinished(finish -> {
                                JFXDatePickerContent.this.selectedYearCell.set((Object)((Label)this.cellContent));
                                JFXDatePickerContent.this.yearsListView.scrollTo(this.getIndex() - 2 >= 0 ? this.getIndex() - 2 : this.getIndex());
                                JFXDatePickerContent.this.hideTransition.setOnFinished(null);
                            });
                            JFXDatePickerContent.this.hideTransition.play();
                        }
                    });
                    JFXDatePickerContent.this.selectedYearLabel.textProperty().addListener((o, oldVal, newVal) -> {
                        if (!JFXDatePickerContent.this.yearsListView.isVisible() && ((Label)this.cellContent).getText().equals(newVal)) {
                            JFXDatePickerContent.this.selectedYearCell.set((Object)((Label)this.cellContent));
                        }
                    });
                }

                @Override
                public void updateItem(String item, boolean empty) {
                    super.updateItem(item, empty);
                    if (!empty) {
                        this.cellRippler.setRipplerFill((Paint)Color.GREY);
                        Label lbl = (Label)this.cellContent;
                        lbl.setAlignment(Pos.CENTER);
                        lbl.setTextAlignment(TextAlignment.CENTER);
                        lbl.setMaxWidth(Double.MAX_VALUE);
                        if (!item.equals(JFXDatePickerContent.this.selectedYearLabel.getText())) {
                            lbl.setStyle("-fx-font-size: 16; -fx-font-weight: NORMAL;");
                            lbl.setTextFill((Paint)DEFAULT_COLOR);
                        } else {
                            JFXDatePickerContent.this.selectedYearCell.set((Object)((Label)this.cellContent));
                        }
                        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
                    }
                }
            });
        }
    };
    final DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MMMM");
    final DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("y");
    final DateTimeFormatter weekNumberFormatter = DateTimeFormatter.ofPattern("w");
    final DateTimeFormatter weekDayNameFormatter = DateTimeFormatter.ofPattern("ccc");
    final DateTimeFormatter dayCellFormatter = DateTimeFormatter.ofPattern("d");
    private ObjectProperty<YearMonth> selectedYearMonth = new SimpleObjectProperty((Object)this, "selectedYearMonth");

    JFXDatePickerContent(final DatePicker datePicker) {
        this.datePicker = (JFXDatePicker)datePicker;
        this.getStyleClass().add((Object)"date-picker-popup");
        LocalDate date = (LocalDate)datePicker.getValue();
        this.selectedYearMonth.set((Object)(date != null ? YearMonth.from(date) : YearMonth.now()));
        this.selectedYearMonth.addListener((observable, oldValue, newValue) -> this.updateValues());
        this.selectedYearCell.addListener((o, oldVal, newVal) -> {
            if (oldVal != null) {
                oldVal.setStyle("-fx-font-size: 16; -fx-font-weight: NORMAL;");
                oldVal.setTextFill((Paint)DEFAULT_COLOR);
            }
            if (newVal != null) {
                newVal.setStyle("-fx-font-size: 24; -fx-font-weight: BOLD;");
                newVal.setTextFill(this.datePicker.getDefaultColor());
            }
        });
        this.getChildren().add((Object)this.createHeaderPane());
        this.contentGrid = new GridPane(){

            protected double computePrefWidth(double height) {
                int nCols = JFXDatePickerContent.this.daysPerWeek + (datePicker.isShowWeekNumbers() ? 1 : 0);
                double leftSpace = this.snapSpace(this.getInsets().getLeft());
                double rightSpace = this.snapSpace(this.getInsets().getRight());
                double hgaps = this.snapSpace(this.getHgap()) * (double)(nCols - 1);
                double contentWidth = super.computePrefWidth(height) - leftSpace - rightSpace - hgaps;
                return this.snapSize(contentWidth / (double)nCols) * (double)nCols + leftSpace + rightSpace + hgaps;
            }

            protected void layoutChildren() {
                if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
                    super.layoutChildren();
                }
            }
        };
        this.contentGrid.setFocusTraversable(true);
        this.contentGrid.getStyleClass().add((Object)"calendar-grid");
        this.contentGrid.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.contentGrid.setPadding(new Insets(0.0, 12.0, 12.0, 12.0));
        this.contentGrid.setVgap(0.0);
        this.contentGrid.setHgap(0.0);
        this.createWeekDaysCells();
        this.createDayCells();
        VBox contentHolder = new VBox();
        contentHolder.getChildren().setAll((Object[])new Node[]{this.createCalendarMonthLabelPane(), this.contentGrid});
        this.calendarPlaceHolder.getChildren().setAll((Object[])new Node[]{contentHolder, this.createCalendarArrowsPane()});
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.calendarPlaceHolder.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.calendarPlaceHolder.heightProperty());
        this.calendarPlaceHolder.setClip((Node)clip);
        for (int i = 0; i <= 200; ++i) {
            this.yearsListView.getItems().add((Object)Integer.toString(1900 + i));
        }
        this.yearsListView.setVisible(false);
        this.yearsListView.setOpacity(0.0);
        this.yearsListView.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        StackPane contentPlaceHolder = new StackPane();
        this.yearsListView.maxWidthProperty().bind((ObservableValue)contentPlaceHolder.widthProperty());
        this.yearsListView.maxHeightProperty().bind((ObservableValue)contentPlaceHolder.heightProperty());
        contentPlaceHolder.getChildren().setAll((Object[])new Node[]{this.calendarPlaceHolder, this.yearsListView});
        this.getChildren().add((Object)contentPlaceHolder);
        this.refresh();
        this.addEventHandler(KeyEvent.ANY, event -> {
            Node node = this.getScene().getFocusOwner();
            if (node instanceof DateCell) {
                this.currentFocusedDayCell = (DateCell)node;
            }
            switch (event.getCode()) {
                case HOME: {
                    this.init();
                    this.goToDate(LocalDate.now(), true);
                    event.consume();
                    break;
                }
                case PAGE_UP: {
                    if (!this.backMonthButton.isDisabled()) {
                        this.forward(-1, ChronoUnit.MONTHS, true, true);
                    }
                    event.consume();
                    break;
                }
                case PAGE_DOWN: {
                    if (!this.forwardMonthButton.isDisabled()) {
                        this.forward(1, ChronoUnit.MONTHS, true, true);
                    }
                    event.consume();
                    break;
                }
                case ESCAPE: {
                    datePicker.hide();
                    event.consume();
                    break;
                }
                case F4: 
                case F10: 
                case UP: 
                case DOWN: 
                case LEFT: 
                case RIGHT: 
                case TAB: {
                    break;
                }
                default: {
                    event.consume();
                }
            }
        });
        this.showTransition = new CachedTransition((Node)this.yearsListView, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.yearsListView.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.calendarPlaceHolder.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)this.yearsListView.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.calendarPlaceHolder.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.yearsListView.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.calendarPlaceHolder.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedYearLabel.textFillProperty(), (Object)Color.WHITE, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedDateLabel.textFillProperty(), (Object)Color.rgb((int)255, (int)255, (int)255, (double)0.67), Interpolator.EASE_BOTH)})})){
            {
                this.setCycleDuration(Duration.millis((double)320.0));
                this.setDelay(Duration.seconds((double)0.0));
            }

            @Override
            protected void starting() {
                super.starting();
                JFXDatePickerContent.this.yearsListView.setVisible(true);
            }
        };
        this.hideTransition = new CachedTransition((Node)this.yearsListView, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.yearsListView.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.calendarPlaceHolder.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)this.yearsListView.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.calendarPlaceHolder.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.yearsListView.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.calendarPlaceHolder.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedDateLabel.textFillProperty(), (Object)Color.WHITE, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedYearLabel.textFillProperty(), (Object)Color.rgb((int)255, (int)255, (int)255, (double)0.67), Interpolator.EASE_BOTH)})})){
            {
                this.setCycleDuration(Duration.millis((double)320.0));
                this.setDelay(Duration.seconds((double)0.0));
            }

            @Override
            protected void stopping() {
                super.stopping();
                JFXDatePickerContent.this.yearsListView.setVisible(false);
            }
        };
    }

    ObjectProperty<YearMonth> displayedYearMonthProperty() {
        return this.selectedYearMonth;
    }

    private void createWeekDaysCells() {
        DateCell cell;
        int i;
        for (i = 0; i < this.daysPerWeek; ++i) {
            cell = new DateCell();
            cell.getStyleClass().add((Object)"day-name-cell");
            cell.setTextFill((Paint)DEFAULT_CELL_COLOR);
            cell.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            cell.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)12.0));
            cell.setAlignment(Pos.BASELINE_CENTER);
            this.weekDaysCells.add(cell);
        }
        for (i = 0; i < 6; ++i) {
            cell = new DateCell();
            cell.getStyleClass().add((Object)"week-number-cell");
            cell.setTextFill((Paint)DEFAULT_CELL_COLOR);
            cell.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            cell.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)12.0));
            this.weekNumberCells.add(cell);
        }
    }

    protected VBox createHeaderPane() {
        this.selectedYearLabel = new Label();
        this.selectedYearLabel.getStyleClass().add((Object)SPINNER_LABEL);
        this.selectedYearLabel.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.67));
        this.selectedYearLabel.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)14.0));
        HBox yearLabelContainer = new HBox();
        yearLabelContainer.getStyleClass().add((Object)"spinner");
        yearLabelContainer.getChildren().addAll((Object[])new Node[]{this.selectedYearLabel});
        yearLabelContainer.setAlignment(Pos.CENTER_LEFT);
        yearLabelContainer.setFillHeight(false);
        yearLabelContainer.setOnMouseClicked(click -> {
            if (!this.yearsListView.isVisible()) {
                int yearIndex = Integer.parseInt(this.selectedYearLabel.getText()) - 1900 - 2;
                this.yearsListView.scrollTo(yearIndex >= 0 ? yearIndex : yearIndex + 2);
                this.hideTransition.stop();
                this.showTransition.play();
            }
        });
        this.selectedDateLabel = new Label();
        this.selectedDateLabel.getStyleClass().add((Object)SPINNER_LABEL);
        this.selectedDateLabel.setTextFill((Paint)Color.WHITE);
        this.selectedDateLabel.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)32.0));
        HBox selectedDateContainer = new HBox();
        selectedDateContainer.getStyleClass().add((Object)"spinner");
        selectedDateContainer.getChildren().addAll((Object[])new Node[]{this.selectedDateLabel});
        selectedDateContainer.setAlignment(Pos.CENTER_LEFT);
        selectedDateContainer.setOnMouseClicked(click -> {
            if (this.yearsListView.isVisible()) {
                this.showTransition.stop();
                this.hideTransition.play();
            }
        });
        VBox headerPanel = new VBox();
        headerPanel.getStyleClass().add((Object)"month-year-pane");
        headerPanel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.datePicker.getDefaultColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        headerPanel.setPadding(new Insets(12.0, 24.0, 12.0, 24.0));
        headerPanel.getChildren().add((Object)yearLabelContainer);
        headerPanel.getChildren().add((Object)selectedDateContainer);
        return headerPanel;
    }

    protected BorderPane createCalendarArrowsPane() {
        SVGGlyph leftChevron = new SVGGlyph(0, "CHEVRON_LEFT", "M 742,-37 90,614 Q 53,651 53,704.5 53,758 90,795 l 652,651 q 37,37 90.5,37 53.5,0 90.5,-37 l 75,-75 q 37,-37 37,-90.5 0,-53.5 -37,-90.5 L 512,704 998,219 q 37,-38 37,-91 0,-53 -37,-90 L 923,-37 Q 886,-74 832.5,-74 779,-74 742,-37 z", (Paint)Color.GRAY);
        SVGGlyph rightChevron = new SVGGlyph(0, "CHEVRON_RIGHT", "m 1099,704 q 0,-52 -37,-91 L 410,-38 q -37,-37 -90,-37 -53,0 -90,37 l -76,75 q -37,39 -37,91 0,53 37,90 l 486,486 -486,485 q -37,39 -37,91 0,53 37,90 l 76,75 q 36,38 90,38 54,0 90,-38 l 652,-651 q 37,-37 37,-90 z", (Paint)Color.GRAY);
        leftChevron.setFill((Paint)DEFAULT_COLOR);
        leftChevron.setSize(6.0, 11.0);
        rightChevron.setFill((Paint)DEFAULT_COLOR);
        rightChevron.setSize(6.0, 11.0);
        this.backMonthButton = new JFXButton();
        this.backMonthButton.setMinSize(40.0, 40.0);
        this.backMonthButton.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, new CornerRadii(40.0), Insets.EMPTY)}));
        this.backMonthButton.getStyleClass().add((Object)"left-button");
        this.backMonthButton.setGraphic((Node)leftChevron);
        this.backMonthButton.setRipplerFill(this.datePicker.getDefaultColor());
        this.backMonthButton.setOnAction(t -> this.forward(-1, ChronoUnit.MONTHS, false, true));
        this.forwardMonthButton = new JFXButton();
        this.forwardMonthButton.setMinSize(40.0, 40.0);
        this.forwardMonthButton.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, new CornerRadii(40.0), Insets.EMPTY)}));
        this.forwardMonthButton.getStyleClass().add((Object)"right-button");
        this.forwardMonthButton.setGraphic((Node)rightChevron);
        this.forwardMonthButton.setRipplerFill(this.datePicker.getDefaultColor());
        this.forwardMonthButton.setOnAction(t -> this.forward(1, ChronoUnit.MONTHS, false, true));
        BorderPane arrowsContainer = new BorderPane();
        arrowsContainer.setLeft((Node)this.backMonthButton);
        arrowsContainer.setRight((Node)this.forwardMonthButton);
        arrowsContainer.setPadding(new Insets(4.0, 12.0, 2.0, 12.0));
        arrowsContainer.setPickOnBounds(false);
        return arrowsContainer;
    }

    protected BorderPane createCalendarMonthLabelPane() {
        this.monthYearLabel = new Label();
        this.monthYearLabel.getStyleClass().add((Object)SPINNER_LABEL);
        this.monthYearLabel.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)13.0));
        this.monthYearLabel.setTextFill((Paint)DEFAULT_COLOR);
        BorderPane monthContainer = new BorderPane();
        monthContainer.setMinHeight(50.0);
        monthContainer.setCenter((Node)this.monthYearLabel);
        monthContainer.setPadding(new Insets(2.0, 12.0, 2.0, 12.0));
        return monthContainer;
    }

    void updateContentGrid() {
        int i;
        this.contentGrid.getColumnConstraints().clear();
        this.contentGrid.getChildren().clear();
        int colsNumber = this.daysPerWeek + (this.datePicker.isShowWeekNumbers() ? 1 : 0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        for (i = 0; i < colsNumber; ++i) {
            this.contentGrid.getColumnConstraints().add((Object)columnConstraints);
        }
        for (i = 0; i < this.daysPerWeek; ++i) {
            this.contentGrid.add((Node)this.weekDaysCells.get(i), i + colsNumber - this.daysPerWeek, 1);
        }
        if (this.datePicker.isShowWeekNumbers()) {
            for (i = 0; i < 6; ++i) {
                this.contentGrid.add((Node)this.weekNumberCells.get(i), 0, i + 2);
            }
        }
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < this.daysPerWeek; ++col) {
                this.contentGrid.add((Node)this.dayCells.get(row * this.daysPerWeek + col), col + colsNumber - this.daysPerWeek, row + 2);
            }
        }
    }

    private void refresh() {
        this.updateDayNameCells();
        this.updateValues();
    }

    private void updateDayNameCells() {
        int weekFirstDay = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        LocalDate date = LocalDate.of(2009, 7, 12 + weekFirstDay);
        for (int i = 0; i < this.daysPerWeek; ++i) {
            String name = this.weekDayNameFormatter.withLocale(this.getLocale()).format(date.plus(i, ChronoUnit.DAYS));
            if (this.weekDayNameFormatter.getLocale() != Locale.CHINA) {
                name = name.substring(0, 1).toUpperCase();
            }
            this.weekDaysCells.get(i).setText(name);
        }
    }

    void updateValues() {
        this.updateWeekNumberDateCells();
        this.updateDayCells();
        this.updateMonthYearPane();
    }

    void updateWeekNumberDateCells() {
        if (this.datePicker.isShowWeekNumbers()) {
            Locale locale = this.getLocale();
            LocalDate firstDayOfMonth = ((YearMonth)this.selectedYearMonth.get()).atDay(1);
            for (int i = 0; i < 6; ++i) {
                LocalDate date = firstDayOfMonth.plus(i, ChronoUnit.WEEKS);
                String weekNumber = this.weekNumberFormatter.withLocale(locale).withDecimalStyle(DecimalStyle.of(locale)).format(date);
                this.weekNumberCells.get(i).setText(weekNumber);
            }
        }
    }

    private void updateDayCells() {
        int firstOfMonthIndex;
        Locale locale = this.getLocale();
        Chronology chrono = this.getPrimaryChronology();
        int firstDayOfWeek = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        firstOfMonthIndex += (firstOfMonthIndex = ((YearMonth)this.selectedYearMonth.get()).atDay(1).getDayOfWeek().getValue() - firstDayOfWeek) < 0 ? this.daysPerWeek : 0;
        YearMonth currentYearMonth = (YearMonth)this.selectedYearMonth.get();
        int daysInCurMonth = -1;
        for (int i = 0; i < 6 * this.daysPerWeek; ++i) {
            DateCell dayCell = this.dayCells.get(i);
            dayCell.getStyleClass().setAll((Object[])new String[]{"cell", "date-cell", "day-cell"});
            dayCell.setPrefSize(40.0, 42.0);
            dayCell.setDisable(false);
            dayCell.setStyle(null);
            dayCell.setGraphic(null);
            dayCell.setTooltip(null);
            dayCell.setTextFill((Paint)DEFAULT_COLOR);
            dayCell.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            try {
                LocalDate date;
                if (daysInCurMonth == -1) {
                    daysInCurMonth = currentYearMonth.lengthOfMonth();
                }
                int dayIndex = i - firstOfMonthIndex + 1;
                this.dayCellDates[i] = date = currentYearMonth.atDay(dayIndex);
                if (date.equals(LocalDate.now())) {
                    dayCell.setTextFill(this.datePicker.getDefaultColor());
                    dayCell.getStyleClass().add((Object)"today");
                }
                if (date.equals(this.datePicker.getValue())) {
                    dayCell.getStyleClass().add((Object)"selected");
                    dayCell.setTextFill((Paint)Color.WHITE);
                    dayCell.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.datePicker.getDefaultColor(), new CornerRadii(40.0), Insets.EMPTY)}));
                }
                ChronoLocalDate cDate = chrono.date(date);
                String cellText = this.dayCellFormatter.withLocale(locale).withChronology(chrono).withDecimalStyle(DecimalStyle.of(locale)).format(cDate);
                dayCell.setText(cellText);
                if (i < firstOfMonthIndex) {
                    dayCell.getStyleClass().add((Object)"previous-month");
                    dayCell.setText("");
                } else if (i >= firstOfMonthIndex + daysInCurMonth) {
                    dayCell.getStyleClass().add((Object)"next-month");
                    dayCell.setText("");
                }
                dayCell.updateItem(date, false);
                continue;
            }
            catch (DateTimeException ex) {
                dayCell.setText("");
                dayCell.setDisable(true);
            }
        }
    }

    protected void updateMonthYearPane() {
        YearMonth yearMonth = (YearMonth)this.selectedYearMonth.get();
        if (this.datePicker.getValue() != null) {
            this.selectedDateLabel.setText(DateTimeFormatter.ofPattern("EEE, MMM yy").format((TemporalAccessor)this.datePicker.getValue()));
        } else {
            this.selectedDateLabel.setText(DateTimeFormatter.ofPattern("EEE, MMM yy").format(LocalDate.now()));
        }
        this.selectedYearLabel.setText(this.formatYear(yearMonth));
        this.monthYearLabel.setText(this.formatMonth(yearMonth) + " " + this.formatYear(yearMonth));
        Chronology chrono = this.datePicker.getChronology();
        LocalDate firstDayOfMonth = yearMonth.atDay(1);
        this.backMonthButton.setDisable(!this.isValidDate(chrono, firstDayOfMonth, -1, ChronoUnit.DAYS));
        this.forwardMonthButton.setDisable(!this.isValidDate(chrono, firstDayOfMonth, 1, ChronoUnit.MONTHS));
    }

    private String formatMonth(YearMonth yearMonth) {
        try {
            Chronology chrono = this.getPrimaryChronology();
            ChronoLocalDate cDate = chrono.date(yearMonth.atDay(1));
            return this.monthFormatter.withLocale(this.getLocale()).withChronology(chrono).format(cDate);
        }
        catch (DateTimeException ex) {
            return "";
        }
    }

    private String formatYear(YearMonth yearMonth) {
        try {
            Chronology chrono = this.getPrimaryChronology();
            ChronoLocalDate cDate = chrono.date(yearMonth.atDay(1));
            return this.yearFormatter.withLocale(this.getLocale()).withChronology(chrono).withDecimalStyle(DecimalStyle.of(this.getLocale())).format(cDate);
        }
        catch (DateTimeException ex) {
            return "";
        }
    }

    protected LocalDate dayCellDate(DateCell dateCell) {
        assert (this.dayCellDates != null);
        return this.dayCellDates[this.dayCells.indexOf(dateCell)];
    }

    protected void forward(int offset, ChronoUnit unit, boolean focusDayCell, boolean withAnimation) {
        if (withAnimation && (this.tempImageTransition == null || this.tempImageTransition.getStatus() == Animation.Status.STOPPED)) {
            Pane monthContent = (Pane)this.calendarPlaceHolder.getChildren().get(0);
            this.getParent().setManaged(false);
            SnapshotParameters snapShotparams = new SnapshotParameters();
            snapShotparams.setFill((Paint)Color.TRANSPARENT);
            WritableImage temp = monthContent.snapshot(snapShotparams, new WritableImage((int)monthContent.getWidth(), (int)monthContent.getHeight()));
            ImageView tempImage = new ImageView((Image)temp);
            this.calendarPlaceHolder.getChildren().add(this.calendarPlaceHolder.getChildren().size() - 2, (Object)tempImage);
            TranslateTransition imageTransition = new TranslateTransition(Duration.millis((double)160.0), (Node)tempImage);
            imageTransition.setToX((double)(-offset) * this.calendarPlaceHolder.getWidth());
            imageTransition.setOnFinished(finish -> this.calendarPlaceHolder.getChildren().remove((Object)tempImage));
            monthContent.setTranslateX((double)offset * this.calendarPlaceHolder.getWidth());
            TranslateTransition contentTransition = new TranslateTransition(Duration.millis((double)160.0), (Node)monthContent);
            contentTransition.setToX(0.0);
            this.tempImageTransition = new ParallelTransition(new Animation[]{imageTransition, contentTransition});
            this.tempImageTransition.setOnFinished(finish -> {
                this.calendarPlaceHolder.getChildren().remove((Object)tempImage);
                this.getParent().setManaged(true);
            });
            this.tempImageTransition.play();
        }
        YearMonth yearMonth = (YearMonth)this.selectedYearMonth.get();
        DateCell dateCell = this.currentFocusedDayCell;
        if (dateCell == null || this.dayCellDate(dateCell).getMonth() != yearMonth.getMonth()) {
            dateCell = this.findDayCellOfDate(yearMonth.atDay(1));
        }
        this.goToDayCell(dateCell, offset, unit, focusDayCell);
    }

    private void goToDayCell(DateCell dateCell, int offset, ChronoUnit unit, boolean focusDayCell) {
        this.goToDate(this.dayCellDate(dateCell).plus(offset, unit), focusDayCell);
    }

    private void goToDate(LocalDate date, boolean focusDayCell) {
        if (this.isValidDate(this.datePicker.getChronology(), date)) {
            this.selectedYearMonth.set((Object)YearMonth.from(date));
            if (focusDayCell) {
                this.findDayCellOfDate(date).requestFocus();
            }
        }
    }

    private void selectDayCell(DateCell dateCell) {
        this.datePicker.setValue(this.dayCellDate(dateCell));
        this.datePicker.hide();
    }

    private DateCell findDayCellOfDate(LocalDate date) {
        for (int i = 0; i < this.dayCellDates.length; ++i) {
            if (!date.equals(this.dayCellDates[i])) continue;
            return this.dayCells.get(i);
        }
        return this.dayCells.get(this.dayCells.size() / 2 + 1);
    }

    void init() {
        this.calendarPlaceHolder.setOpacity(1.0);
        this.selectedDateLabel.setTextFill((Paint)Color.WHITE);
        this.selectedYearLabel.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.67));
        this.yearsListView.setOpacity(0.0);
        this.yearsListView.setVisible(false);
    }

    void clearFocus() {
        LocalDate focusDate = (LocalDate)this.datePicker.getValue();
        if (focusDate == null) {
            focusDate = LocalDate.now();
        }
        if (YearMonth.from(focusDate).equals(this.selectedYearMonth.get())) {
            this.goToDate(focusDate, true);
        }
    }

    protected void createDayCells() {
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < this.daysPerWeek; ++col) {
                DateCell dayCell = this.createDayCell();
                dayCell.addEventHandler(MouseEvent.MOUSE_CLICKED, click -> {
                    if (click.getButton() != MouseButton.PRIMARY) {
                        return;
                    }
                    DateCell selectedDayCell = (DateCell)click.getSource();
                    this.selectDayCell(selectedDayCell);
                    this.currentFocusedDayCell = selectedDayCell;
                });
                dayCell.setOnMouseEntered(event -> {
                    if (!dayCell.getStyleClass().contains((Object)"selected")) {
                        dayCell.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.valueOf((String)"#EDEDED"), new CornerRadii(40.0), Insets.EMPTY)}));
                    }
                });
                dayCell.setOnMouseExited(event -> {
                    if (!dayCell.getStyleClass().contains((Object)"selected")) {
                        dayCell.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
                    }
                });
                dayCell.setAlignment(Pos.BASELINE_CENTER);
                dayCell.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(5.0))}));
                dayCell.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)12.0));
                this.dayCells.add(dayCell);
            }
        }
        this.dayCellDates = new LocalDate[6 * this.daysPerWeek];
        this.updateContentGrid();
    }

    private DateCell createDayCell() {
        DateCell dayCell = null;
        if (this.datePicker.getDayCellFactory() != null) {
            dayCell = (DateCell)this.datePicker.getDayCellFactory().call((Object)this.datePicker);
        }
        if (dayCell == null) {
            dayCell = new DateCell();
        }
        return dayCell;
    }

    protected Chronology getPrimaryChronology() {
        return this.datePicker.getChronology();
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    protected boolean isValidDate(Chronology chrono, LocalDate date, int offset, ChronoUnit unit) {
        return date != null && this.isValidDate(chrono, date.plus(offset, unit));
    }

    protected boolean isValidDate(Chronology chrono, LocalDate date) {
        try {
            if (date != null) {
                chrono.date(date);
            }
            return true;
        }
        catch (DateTimeException ex) {
            return false;
        }
    }
}

