/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.time.Instant;
import java.util.List;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.game.GameInstallTask;
import org.jackhuang.hmcl.game.ReleaseType;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

@Immutable
public final class GameRemoteVersion
extends RemoteVersion {
    private final ReleaseType type;

    public GameRemoteVersion(String gameVersion, String selfVersion, List<String> url, ReleaseType type, Instant releaseDate) {
        super(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId(), gameVersion, selfVersion, releaseDate, GameRemoteVersion.getReleaseType(type), url);
        this.type = type;
    }

    public ReleaseType getType() {
        return this.type;
    }

    @Override
    public Task<Version> getInstallTask(DefaultDependencyManager dependencyManager, Version baseVersion) {
        return new GameInstallTask(dependencyManager, baseVersion, this);
    }

    @Override
    public int compareTo(RemoteVersion o) {
        if (!(o instanceof GameRemoteVersion)) {
            return 0;
        }
        int dateCompare = o.getReleaseDate().compareTo(this.getReleaseDate());
        if (dateCompare != 0) {
            return dateCompare;
        }
        return GameVersionNumber.compare(o.getSelfVersion(), this.getSelfVersion());
    }

    private static RemoteVersion.Type getReleaseType(ReleaseType type) {
        if (type == null) {
            return RemoteVersion.Type.UNCATEGORIZED;
        }
        return switch (type) {
            case ReleaseType.RELEASE -> RemoteVersion.Type.RELEASE;
            case ReleaseType.SNAPSHOT -> RemoteVersion.Type.SNAPSHOT;
            case ReleaseType.UNKNOWN -> RemoteVersion.Type.UNCATEGORIZED;
            case ReleaseType.PENDING -> RemoteVersion.Type.PENDING;
            case ReleaseType.UNOBFUSCATED -> RemoteVersion.Type.UNOBFUSCATED;
            default -> RemoteVersion.Type.OLD;
        };
    }
}

