/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.skin;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;

public class SkinMultipleCubes
extends Group {
    protected int width;
    protected int height;
    protected int depth;
    protected float startX;
    protected float startY;
    protected double length;
    protected double thick;

    public SkinMultipleCubes(int width, int height, int depth, float startX, float startY, double length, double thick) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.startX = startX;
        this.startY = startY;
        this.length = length;
        this.thick = thick;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setStartX(float startX) {
        this.startX = startX;
    }

    public float getStartX() {
        return this.startX;
    }

    public void setStartY(float startY) {
        this.startY = startY;
    }

    public float getStartY() {
        return this.startY;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getLength() {
        return this.length;
    }

    public void setThick(double thick) {
        this.thick = thick;
    }

    public double getThick() {
        return this.thick;
    }

    public void updateSkin(Image skin) {
        this.getChildren().clear();
        int start_x = (int)((double)this.startX * skin.getWidth());
        int start_y = (int)((double)this.startY * skin.getHeight());
        int interval = (int)Math.max(skin.getWidth() / 64.0, 1.0);
        int width_interval = this.width * interval;
        int height_interval = this.height * interval;
        int depth_interval = this.depth * interval;
        this.getChildren().add((Object)new Face(skin, start_x + depth_interval, start_y + depth_interval, this.width, this.height, interval, false, false, () -> new Box(this.length, this.length, this.thick), (b, p) -> {
            b.setTranslateX(((double)(this.width - 1) / 2.0 - p.getX()) * b.getWidth());
            b.setTranslateY(-((double)(this.height - 1) / 2.0 - p.getY()) * b.getHeight());
            b.setTranslateZ(((double)this.depth * this.length + this.thick) / 2.0);
        }));
        this.getChildren().add((Object)new Face(skin, start_x + width_interval + depth_interval * 2, start_y + depth_interval, this.width, this.height, interval, true, false, () -> new Box(this.length, this.length, this.thick), (b, p) -> {
            b.setTranslateX(((double)(this.width - 1) / 2.0 - p.getX()) * b.getWidth());
            b.setTranslateY(-((double)(this.height - 1) / 2.0 - p.getY()) * b.getHeight());
            b.setTranslateZ(-((double)this.depth * this.length + this.thick) / 2.0);
        }));
        this.getChildren().add((Object)new Face(skin, start_x + width_interval + depth_interval, start_y + depth_interval, this.depth, this.height, interval, false, false, () -> new Box(this.thick, this.length, this.length), (b, p) -> {
            b.setTranslateX(((double)this.width * this.length + this.thick) / 2.0);
            b.setTranslateY(-((double)(this.height - 1) / 2.0 - p.getY()) * b.getHeight());
            b.setTranslateZ(((double)(this.depth - 1) / 2.0 - p.getX()) * b.getDepth());
        }));
        this.getChildren().add((Object)new Face(skin, start_x, start_y + depth_interval, this.depth, this.height, interval, true, false, () -> new Box(this.thick, this.length, this.length), (b, p) -> {
            b.setTranslateX(-((double)this.width * this.length + this.thick) / 2.0);
            b.setTranslateY(-((double)(this.height - 1) / 2.0 - p.getY()) * b.getHeight());
            b.setTranslateZ(((double)(this.depth - 1) / 2.0 - p.getX()) * b.getDepth());
        }));
        this.getChildren().add((Object)new Face(skin, start_x + depth_interval, start_y, this.width, this.depth, interval, false, false, () -> new Box(this.length, this.thick, this.length), (b, p) -> {
            b.setTranslateX(((double)(this.width - 1) / 2.0 - p.getX()) * b.getWidth());
            b.setTranslateY(-((double)this.height * this.length + this.thick) / 2.0);
            b.setTranslateZ(-((double)(this.depth - 1) / 2.0 - p.getY()) * b.getDepth());
        }));
        this.getChildren().add((Object)new Face(skin, start_x + width_interval + depth_interval, start_y, this.width, this.depth, interval, false, false, () -> new Box(this.length, this.thick, this.length), (b, p) -> {
            b.setTranslateX(((double)(this.width - 1) / 2.0 - p.getX()) * b.getWidth());
            b.setTranslateY(((double)this.height * this.length + this.thick) / 2.0);
            b.setTranslateZ(-((double)(this.depth - 1) / 2.0 - p.getY()) * b.getDepth());
        }));
    }

    public static class Face
    extends Group {
        public Face(Image image, int startX, int startY, int width, int height, int interval, boolean reverseX, boolean reverseY, Supplier<Box> supplier, BiConsumer<Box, Point2D> consumer) {
            PixelReader reader = image.getPixelReader();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int argb = reader.getArgb(startX + (reverseX ? width - x - 1 : x) * interval, startY + (reverseY ? height - y - 1 : y) * interval);
                    if (argb == 0) continue;
                    Box pixel = supplier.get();
                    consumer.accept(pixel, new Point2D((double)x, (double)y));
                    pixel.setMaterial(this.createMaterial(Color.rgb((int)(argb >> 16 & 0xFF), (int)(argb >> 8 & 0xFF), (int)(argb >> 0 & 0xFF))));
                    this.getChildren().add((Object)pixel);
                }
            }
        }

        protected Material createMaterial(Color color) {
            return new PhongMaterial(color);
        }
    }
}

