/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Skin;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.versions.WorldExportPageSkin;
import org.jackhuang.hmcl.ui.wizard.WizardSinglePage;
import org.jackhuang.hmcl.util.i18n.I18n;

public class WorldExportPage
extends WizardSinglePage {
    private final StringProperty path = new SimpleStringProperty();
    private final StringProperty gameVersion = new SimpleStringProperty();
    private final StringProperty worldName = new SimpleStringProperty();
    private final World world;

    public WorldExportPage(World world, Path export, Runnable onFinish) {
        super(onFinish);
        this.world = world;
        this.path.set((Object)export.toString());
        this.gameVersion.set((Object)world.getGameVersion());
        this.worldName.set((Object)world.getWorldName());
    }

    protected Skin<?> createDefaultSkin() {
        return new WorldExportPageSkin(this);
    }

    public StringProperty pathProperty() {
        return this.path;
    }

    public StringProperty gameVersionProperty() {
        return this.gameVersion;
    }

    public StringProperty worldNameProperty() {
        return this.worldName;
    }

    public void export() {
        this.onFinish.run();
    }

    @Override
    public String getTitle() {
        return I18n.i18n("world.export.wizard", this.world.getFileName());
    }

    @Override
    protected Object finish() {
        return Task.runAsync(I18n.i18n("world.export.wizard", this.worldName.get()), () -> this.world.export(Paths.get((String)this.path.get(), new String[0]), (String)this.worldName.get()));
    }
}

