/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.ArrayList;
import java.util.Collection;
import org.jackhuang.hmcl.util.Lang;
import org.jetbrains.annotations.NotNull;

public final class InfiniteSizeList<T>
extends ArrayList<T> {
    private int actualSize = 0;

    public InfiniteSizeList(int initialCapacity) {
        super(initialCapacity);
    }

    public InfiniteSizeList() {
    }

    public InfiniteSizeList(@NotNull Collection<? extends T> c) {
        super(c);
        for (int i = super.size() - 1; i >= 0; --i) {
            if (super.get(i) == null) continue;
            this.actualSize = i + 1;
            break;
        }
    }

    @Override
    public T get(int index) {
        if (index >= super.size()) {
            return null;
        }
        return (T)super.get(index);
    }

    @Override
    public T set(int index, T element) {
        if (element == null) {
            if (index >= super.size()) {
                return null;
            }
            Object previous = super.get(index);
            if (previous != null) {
                super.set(index, null);
                if (index == this.actualSize - 1) {
                    this.actualSize = 0;
                    for (int i = index - 1; i >= 0; --i) {
                        if (super.get(i) == null) continue;
                        this.actualSize = i + 1;
                        break;
                    }
                }
                return (T)previous;
            }
            return null;
        }
        if (index >= super.size()) {
            this.allocate0(index);
        }
        Object previous = super.get(index);
        super.set(index, element);
        if (previous != null) {
            return (T)previous;
        }
        if (index >= this.actualSize) {
            this.actualSize = index + 1;
        }
        return null;
    }

    private void allocate0(int index) {
        this.addAll(Lang.immutableListOf(new Object[index + 1 - super.size()]));
    }

    @Override
    public int size() {
        return this.actualSize;
    }
}

