/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.javafx;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakListener;

public final class DirtyTracker {
    private final Set<Observable> dirty = Collections.newSetFromMap(new IdentityHashMap());
    private final Listener listener = new Listener(this);

    public void track(Observable observable) {
        if (!this.dirty.contains(observable)) {
            observable.addListener((InvalidationListener)this.listener);
        }
    }

    public boolean isDirty(Observable observable) {
        return this.dirty.contains(observable);
    }

    public void markDirty(Observable observable) {
        observable.removeListener((InvalidationListener)this.listener);
        this.dirty.add(observable);
    }

    private static final class Listener
    implements InvalidationListener,
    WeakListener {
        private final WeakReference<DirtyTracker> trackerReference;

        public Listener(DirtyTracker trackerReference) {
            this.trackerReference = new WeakReference<DirtyTracker>(trackerReference);
        }

        public boolean wasGarbageCollected() {
            return this.trackerReference.get() == null;
        }

        public void invalidated(Observable observable) {
            observable.removeListener((InvalidationListener)this);
            DirtyTracker tracker = (DirtyTracker)this.trackerReference.get();
            if (tracker != null) {
                tracker.markDirty(observable);
            }
        }
    }
}

