/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface OSVersion {
    public static final Windows WINDOWS_2000 = new Windows(5, 0);
    public static final Windows WINDOWS_XP = new Windows(5, 1);
    public static final Windows WINDOWS_VISTA = new Windows(6, 0);
    public static final Windows WINDOWS_7 = new Windows(6, 1);
    public static final Windows WINDOWS_8 = new Windows(6, 2);
    public static final Windows WINDOWS_8_1 = new Windows(6, 3);
    public static final Windows WINDOWS_10 = new Windows(10, 0);
    public static final Windows WINDOWS_11 = new Windows(10, 0, 22000);

    public static OSVersion of(OperatingSystem os, String version) {
        if (Objects.requireNonNull(os) == OperatingSystem.WINDOWS) {
            return Windows.parse(version);
        }
        return new Generic(os, VersionNumber.asVersion(version));
    }

    @NotNull
    public OperatingSystem getOperatingSystem();

    @NotNull
    public String getVersion();

    public boolean isAtLeast(@NotNull OSVersion var1);

    public record Windows(int major, int minor, int build, int revision, String version) implements OSVersion,
    Comparable<Windows>
    {
        public Windows(int major, int minor) {
            this(major, minor, 0);
        }

        public Windows(int major, int minor, int build) {
            this(major, minor, build, 0);
        }

        public Windows(int major, int minor, int build, int revision) {
            this(major, minor, build, revision, Windows.toVersion(major, minor, build, revision));
        }

        private static String toVersion(int major, int minor, int build, int revision) {
            StringBuilder builder = new StringBuilder();
            builder.append(major).append('.').append(minor);
            if (build > 0 || revision > 0) {
                builder.append('.').append(build);
                if (revision > 0) {
                    builder.append('.').append(revision);
                }
            }
            return builder.toString();
        }

        public static Windows parse(String version) {
            Matcher matcher = Pattern.compile("^(?<major>\\d+)\\.(?<minor>\\d+)(\\.(?<build>\\d+)(\\.(?<revision>\\d+))?)?").matcher(version);
            if (matcher.find()) {
                return new Windows(Integer.parseInt(matcher.group("major")), Integer.parseInt(matcher.group("minor")), matcher.group("build") != null ? Integer.parseInt(matcher.group("build")) : 0, matcher.group("revision") != null ? Integer.parseInt(matcher.group("revision")) : 0, version);
            }
            return new Windows(0, 0, 0, 0, version);
        }

        @Override
        @NotNull
        public OperatingSystem getOperatingSystem() {
            return OperatingSystem.WINDOWS;
        }

        @Override
        @NotNull
        public String getVersion() {
            return this.version;
        }

        @Override
        public boolean isAtLeast(@NotNull OSVersion otherVersion) {
            Windows other;
            return this == otherVersion || otherVersion instanceof Windows && this.compareTo(other = (Windows)otherVersion) >= 0;
        }

        @Override
        public int compareTo(@NotNull Windows that) {
            if (this.major != that.major) {
                return Integer.compare(this.major, that.major);
            }
            if (this.minor != that.minor) {
                return Integer.compare(this.minor, that.minor);
            }
            if (this.build != that.build) {
                return Integer.compare(this.build, that.build);
            }
            return Integer.compare(this.revision, that.revision);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.major, this.minor, this.build, this.revision);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof Windows)) return false;
            Windows that = (Windows)o;
            if (this.major != that.major) return false;
            if (this.minor != that.minor) return false;
            if (this.build != that.build) return false;
            if (this.revision != that.revision) return false;
            return true;
        }

        @Override
        @NotNull
        public String toString() {
            return this.version;
        }
    }

    public record Generic(@NotNull OperatingSystem os, @NotNull VersionNumber version) implements OSVersion
    {
        public Generic(@NotNull OperatingSystem os, @NotNull VersionNumber version) {
            Objects.requireNonNull(os);
            if (os == OperatingSystem.WINDOWS) {
                throw new IllegalArgumentException("Please use the " + Windows.class.getName());
            }
        }

        @Override
        @NotNull
        public OperatingSystem getOperatingSystem() {
            return this.os;
        }

        @Override
        @NotNull
        public String getVersion() {
            return this.version.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isAtLeast(@NotNull OSVersion otherVersion) {
            if (this == otherVersion) return true;
            if (!(otherVersion instanceof Generic)) return false;
            Generic that = (Generic)otherVersion;
            if (this.os != that.os) return false;
            if (this.version.compareTo(that.version) < 0) return false;
            return true;
        }

        @Override
        @NotNull
        public String toString() {
            return this.getVersion();
        }
    }
}

