/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.hardware;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.platform.hardware.HardwareVendor;
import org.jetbrains.annotations.Nullable;

public final class GraphicsCard {
    private final String name;
    @Nullable
    private final HardwareVendor vendor;
    @Nullable
    private final Type type;
    @Nullable
    private final String driver;
    @Nullable
    private final String driverVersion;

    public static String cleanName(String name) {
        Matcher matcher;
        if (name == null) {
            return null;
        }
        name = name.replaceAll("\\((TM|R)\\)(?=\\s|$)", "");
        if ((name = name.replace(" GPU", "")).contains("Snapdragon") && (name = StringUtils.normalizeWhitespaces(name)).startsWith("Snapdragon ") && (matcher = Pattern.compile("Snapdragon X Elite - (?<id>X1E\\S+) - Qualcomm Adreno").matcher(name)).matches()) {
            name = "Qualcomm Adreno Graphics";
        }
        return StringUtils.normalizeWhitespaces(name);
    }

    public static Builder builder() {
        return new Builder();
    }

    private GraphicsCard(String name, @Nullable HardwareVendor vendor, @Nullable Type type, @Nullable String driver, @Nullable String driverVersion) {
        this.name = Objects.requireNonNull(name);
        this.vendor = vendor;
        this.type = type;
        this.driver = driver;
        this.driverVersion = driverVersion;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public HardwareVendor getVendor() {
        return this.vendor;
    }

    @Nullable
    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name);
        if (this.type != null) {
            builder.append(" [").append((Object)this.type).append(']');
        }
        return builder.toString();
    }

    public static final class Builder {
        private String name;
        private HardwareVendor vendor;
        private Type type;
        private String driver;
        private String driverVersion;

        public GraphicsCard build() {
            Object name = this.name;
            if (name == null) {
                name = this.vendor != null ? String.valueOf(this.vendor) + " Graphics" : "Unknown";
            }
            return new GraphicsCard((String)name, this.vendor, this.type, this.driver, this.driverVersion);
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public HardwareVendor getVendor() {
            return this.vendor;
        }

        public Builder setVendor(HardwareVendor vendor) {
            this.vendor = vendor;
            return this;
        }

        public Type getType() {
            return this.type;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public String getDriver() {
            return this.driver;
        }

        public Builder setDriver(String driver) {
            this.driver = driver;
            return this;
        }

        public String getDriverVersion() {
            return this.driverVersion;
        }

        public Builder setDriverVersion(String driverVersion) {
            this.driverVersion = driverVersion;
            return this;
        }
    }

    public static enum Type {
        Integrated,
        Discrete;

    }
}

