/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone;

import com.jcloisterzone.XMLUtils;
import java.net.URL;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AppUpdate {
    private String version;
    private String description;
    private String downloadUrl;

    public static AppUpdate fetch(URL url) {
        Element el = XMLUtils.parseDocument(url).getDocumentElement();
        String version = XMLUtils.childValue(el, "number");
        String description = XMLUtils.childValue(el, "description");
        boolean isWin = System.getProperty("os.name").startsWith("Win");
        String downloadUrl = null;
        NodeList nl = el.getElementsByTagName("url");
        for (int i = 0; i < nl.getLength(); ++i) {
            boolean isWinUrl;
            String value = nl.item(i).getTextContent().trim();
            boolean bl = isWinUrl = value.endsWith(".zip") || value.endsWith(".7z") || value.endsWith(".exe");
            if (downloadUrl != null && isWin != isWinUrl) continue;
            downloadUrl = value;
        }
        return new AppUpdate(version, description, downloadUrl);
    }

    public AppUpdate(String version, String description, String downloadUrl) {
        this.version = version;
        this.description = description;
        this.downloadUrl = downloadUrl;
    }

    public String toString() {
        return this.version + " " + this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }
}

