/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.file.Path;

public class FileTeeStream
extends PrintStream {
    PrintStream outStream;
    File file;

    public FileTeeStream(PrintStream err, Path fileName) {
        super(err);
        this.file = fileName.toFile();
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        if (this.outStream == null && this.file != null) {
            try {
                this.outStream = new PrintStream(new FileOutputStream(this.file), true);
            }
            catch (FileNotFoundException e) {
                this.file = null;
                e.printStackTrace();
            }
        }
        super.write(buf, off, len);
        if (this.outStream != null) {
            this.outStream.write(buf, off, len);
            if (this.outStream.checkError()) {
                System.err.println("File stream write error.");
                this.outStream = null;
                this.file = null;
            }
        }
    }

    @Override
    public void flush() {
        super.flush();
        if (this.outStream != null) {
            this.outStream.flush();
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.outStream != null) {
            this.outStream.close();
        }
    }

    public File getFile() {
        return this.file;
    }
}

